/*
 * Decompiled with CFR 0.152.
 */
package io.invertase.firebase.messaging;

import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableMapKeySetIterator;
import com.facebook.react.bridge.ReadableType;
import com.facebook.react.bridge.WritableArray;
import com.facebook.react.bridge.WritableMap;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class JsonConvert {
    public static JSONObject reactToJSON(ReadableMap readableMap) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        ReadableMapKeySetIterator iterator = readableMap.keySetIterator();
        while (iterator.hasNextKey()) {
            String key = iterator.nextKey();
            ReadableType valueType = readableMap.getType(key);
            switch (valueType) {
                case Null: {
                    jsonObject.put(key, JSONObject.NULL);
                    break;
                }
                case Boolean: {
                    jsonObject.put(key, readableMap.getBoolean(key));
                    break;
                }
                case Number: {
                    try {
                        jsonObject.put(key, readableMap.getInt(key));
                    }
                    catch (Exception e) {
                        jsonObject.put(key, readableMap.getDouble(key));
                    }
                    break;
                }
                case String: {
                    jsonObject.put(key, (Object)readableMap.getString(key));
                    break;
                }
                case Map: {
                    jsonObject.put(key, (Object)JsonConvert.reactToJSON(readableMap.getMap(key)));
                    break;
                }
                case Array: {
                    jsonObject.put(key, (Object)JsonConvert.reactToJSON(readableMap.getArray(key)));
                }
            }
        }
        return jsonObject;
    }

    public static JSONArray reactToJSON(ReadableArray readableArray) throws JSONException {
        JSONArray jsonArray = new JSONArray();
        block10: for (int i = 0; i < readableArray.size(); ++i) {
            ReadableType valueType = readableArray.getType(i);
            switch (valueType) {
                case Null: {
                    jsonArray.put(JSONObject.NULL);
                    continue block10;
                }
                case Boolean: {
                    jsonArray.put(readableArray.getBoolean(i));
                    continue block10;
                }
                case Number: {
                    try {
                        jsonArray.put(readableArray.getInt(i));
                    }
                    catch (Exception e) {
                        jsonArray.put(readableArray.getDouble(i));
                    }
                    continue block10;
                }
                case String: {
                    jsonArray.put((Object)readableArray.getString(i));
                    continue block10;
                }
                case Map: {
                    jsonArray.put((Object)JsonConvert.reactToJSON(readableArray.getMap(i)));
                    continue block10;
                }
                case Array: {
                    jsonArray.put((Object)JsonConvert.reactToJSON(readableArray.getArray(i)));
                }
            }
        }
        return jsonArray;
    }

    public static WritableMap jsonToReact(JSONObject jsonObject) throws JSONException {
        WritableMap writableMap = Arguments.createMap();
        Iterator iterator = jsonObject.keys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            Object value = jsonObject.get(key);
            if (value instanceof Float || value instanceof Double) {
                writableMap.putDouble(key, jsonObject.getDouble(key));
                continue;
            }
            if (value instanceof Number) {
                writableMap.putInt(key, jsonObject.getInt(key));
                continue;
            }
            if (value instanceof String) {
                writableMap.putString(key, jsonObject.getString(key));
                continue;
            }
            if (value instanceof JSONObject) {
                writableMap.putMap(key, (ReadableMap)JsonConvert.jsonToReact(jsonObject.getJSONObject(key)));
                continue;
            }
            if (value instanceof JSONArray) {
                writableMap.putArray(key, (ReadableArray)JsonConvert.jsonToReact(jsonObject.getJSONArray(key)));
                continue;
            }
            if (value != JSONObject.NULL) continue;
            writableMap.putNull(key);
        }
        return writableMap;
    }

    public static WritableArray jsonToReact(JSONArray jsonArray) throws JSONException {
        WritableArray writableArray = Arguments.createArray();
        for (int i = 0; i < jsonArray.length(); ++i) {
            Object value = jsonArray.get(i);
            if (value instanceof Float || value instanceof Double) {
                writableArray.pushDouble(jsonArray.getDouble(i));
                continue;
            }
            if (value instanceof Number) {
                writableArray.pushInt(jsonArray.getInt(i));
                continue;
            }
            if (value instanceof String) {
                writableArray.pushString(jsonArray.getString(i));
                continue;
            }
            if (value instanceof JSONObject) {
                writableArray.pushMap((ReadableMap)JsonConvert.jsonToReact(jsonArray.getJSONObject(i)));
                continue;
            }
            if (value instanceof JSONArray) {
                writableArray.pushArray((ReadableArray)JsonConvert.jsonToReact(jsonArray.getJSONArray(i)));
                continue;
            }
            if (value != JSONObject.NULL) continue;
            writableArray.pushNull();
        }
        return writableArray;
    }
}

