/*
 * Decompiled with CFR 0.152.
 */
package io.invertase.firebase.messaging;

import android.content.Intent;
import android.os.Bundle;
import com.facebook.react.HeadlessJsTaskService;
import com.facebook.react.jstasks.HeadlessJsTaskConfig;
import com.google.firebase.messaging.RemoteMessage;
import io.invertase.firebase.common.ReactNativeFirebaseJSON;
import io.invertase.firebase.messaging.ReactNativeFirebaseMessagingSerializer;
import javax.annotation.Nullable;

public class ReactNativeFirebaseMessagingHeadlessService
extends HeadlessJsTaskService {
    private static final long TIMEOUT_DEFAULT = 60000L;
    private static final String TIMEOUT_JSON_KEY = "messaging_android_headless_task_timeout";
    private static final String TASK_KEY = "ReactNativeFirebaseMessagingHeadlessTask";

    @Nullable
    protected HeadlessJsTaskConfig getTaskConfig(Intent intent) {
        Bundle extras = intent.getExtras();
        if (extras == null) {
            return null;
        }
        RemoteMessage remoteMessage = (RemoteMessage)intent.getParcelableExtra("message");
        return new HeadlessJsTaskConfig(TASK_KEY, ReactNativeFirebaseMessagingSerializer.remoteMessageToWritableMap(remoteMessage), ReactNativeFirebaseJSON.getSharedInstance().getLongValue(TIMEOUT_JSON_KEY, 60000L), true);
    }
}

