/*
 * Decompiled with CFR 0.152.
 */
package io.invertase.firebase.messaging;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.util.Log;
import androidx.core.app.NotificationManagerCompat;
import com.facebook.react.bridge.ActivityEventListener;
import com.facebook.react.bridge.Promise;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.bridge.WritableNativeMap;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.messaging.FirebaseMessaging;
import com.google.firebase.messaging.RemoteMessage;
import io.invertase.firebase.common.ReactNativeFirebaseEventEmitter;
import io.invertase.firebase.common.ReactNativeFirebaseModule;
import io.invertase.firebase.interfaces.NativeEvent;
import io.invertase.firebase.messaging.ReactNativeFirebaseMessagingReceiver;
import io.invertase.firebase.messaging.ReactNativeFirebaseMessagingSerializer;
import io.invertase.firebase.messaging.ReactNativeFirebaseMessagingStore;
import io.invertase.firebase.messaging.ReactNativeFirebaseMessagingStoreHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;

public class ReactNativeFirebaseMessagingModule
extends ReactNativeFirebaseModule
implements ActivityEventListener {
    private static final String TAG = "Messaging";
    ReadableMap initialNotification = null;
    private HashMap<String, Boolean> initialNotificationMap = new HashMap();

    ReactNativeFirebaseMessagingModule(ReactApplicationContext reactContext) {
        super(reactContext, TAG);
        reactContext.addActivityEventListener((ActivityEventListener)this);
    }

    private WritableMap popRemoteMessageMapFromMessagingStore(String messageId) {
        ReactNativeFirebaseMessagingStore messagingStore = ReactNativeFirebaseMessagingStoreHelper.getInstance().getMessagingStore();
        WritableMap remoteMessageMap = messagingStore.getFirebaseMessageMap(messageId);
        messagingStore.clearFirebaseMessage(messageId);
        return remoteMessageMap;
    }

    @ReactMethod
    public void getInitialNotification(Promise promise) {
        if (this.initialNotification != null) {
            promise.resolve((Object)this.initialNotification);
            this.initialNotification = null;
            return;
        }
        Activity activity = this.getCurrentActivity();
        if (activity != null) {
            Intent intent = activity.getIntent();
            if (intent != null && intent.getExtras() != null) {
                RemoteMessage remoteMessage;
                WritableMap remoteMessageMap;
                String messageId = intent.getExtras().getString("google.message_id");
                if (messageId == null) {
                    messageId = intent.getExtras().getString("message_id");
                }
                if (messageId != null && this.initialNotificationMap.get(messageId) == null && (remoteMessageMap = (remoteMessage = ReactNativeFirebaseMessagingReceiver.notifications.get(messageId)) == null ? this.popRemoteMessageMapFromMessagingStore(messageId) : ReactNativeFirebaseMessagingSerializer.remoteMessageToWritableMap(remoteMessage)) != null) {
                    promise.resolve((Object)remoteMessageMap);
                    this.initialNotificationMap.put(messageId, true);
                    return;
                }
            }
        } else {
            Log.w((String)TAG, (String)"Attempt to call getInitialNotification failed. The current activity is not ready, try calling the method later in the React lifecycle.");
        }
        promise.resolve(null);
    }

    @ReactMethod
    public void setAutoInitEnabled(Boolean enabled, Promise promise) {
        Tasks.call((Executor)this.getExecutor(), () -> {
            FirebaseMessaging.getInstance().setAutoInitEnabled(enabled.booleanValue());
            return null;
        }).addOnCompleteListener(task -> {
            if (task.isSuccessful()) {
                promise.resolve((Object)FirebaseMessaging.getInstance().isAutoInitEnabled());
            } else {
                ReactNativeFirebaseMessagingModule.rejectPromiseWithExceptionMap((Promise)promise, (Exception)task.getException());
            }
        });
    }

    @ReactMethod
    public void getToken(String appName, String senderId, Promise promise) {
        FirebaseMessaging messagingInstance = (FirebaseMessaging)FirebaseApp.getInstance((String)appName).get(FirebaseMessaging.class);
        Tasks.call((Executor)this.getExecutor(), () -> (String)Tasks.await((Task)messagingInstance.getToken())).addOnCompleteListener(task -> {
            if (task.isSuccessful()) {
                promise.resolve(task.getResult());
            } else {
                ReactNativeFirebaseMessagingModule.rejectPromiseWithExceptionMap((Promise)promise, (Exception)task.getException());
            }
        });
    }

    @ReactMethod
    public void deleteToken(String appName, String senderId, Promise promise) {
        FirebaseMessaging messagingInstance = (FirebaseMessaging)FirebaseApp.getInstance((String)appName).get(FirebaseMessaging.class);
        Tasks.call((Executor)this.getExecutor(), () -> {
            Tasks.await((Task)messagingInstance.deleteToken());
            return null;
        }).addOnCompleteListener(task -> {
            if (task.isSuccessful()) {
                promise.resolve(task.getResult());
            } else {
                ReactNativeFirebaseMessagingModule.rejectPromiseWithExceptionMap((Promise)promise, (Exception)task.getException());
            }
        });
    }

    @ReactMethod
    public void hasPermission(Promise promise) {
        Tasks.call((Executor)this.getExecutor(), () -> NotificationManagerCompat.from((Context)this.getReactApplicationContext()).areNotificationsEnabled()).addOnCompleteListener(task -> {
            if (task.isSuccessful()) {
                promise.resolve((Object)((Boolean)task.getResult() != false ? 1 : 0));
            } else {
                ReactNativeFirebaseMessagingModule.rejectPromiseWithExceptionMap((Promise)promise, (Exception)task.getException());
            }
        });
    }

    @ReactMethod
    public void sendMessage(ReadableMap remoteMessageMap, Promise promise) {
        Tasks.call((Executor)this.getExecutor(), () -> {
            FirebaseMessaging.getInstance().send(ReactNativeFirebaseMessagingSerializer.remoteMessageFromReadableMap(remoteMessageMap));
            return null;
        }).addOnCompleteListener(task -> {
            if (task.isSuccessful()) {
                promise.resolve(task.getResult());
            } else {
                ReactNativeFirebaseMessagingModule.rejectPromiseWithExceptionMap((Promise)promise, (Exception)task.getException());
            }
        });
    }

    @ReactMethod
    public void subscribeToTopic(String topic, Promise promise) {
        FirebaseMessaging.getInstance().subscribeToTopic(topic).addOnCompleteListener(task -> {
            if (task.isSuccessful()) {
                promise.resolve(task.getResult());
            } else {
                ReactNativeFirebaseMessagingModule.rejectPromiseWithExceptionMap((Promise)promise, (Exception)task.getException());
            }
        });
    }

    @ReactMethod
    public void unsubscribeFromTopic(String topic, Promise promise) {
        FirebaseMessaging.getInstance().unsubscribeFromTopic(topic).addOnCompleteListener(task -> {
            if (task.isSuccessful()) {
                promise.resolve(task.getResult());
            } else {
                ReactNativeFirebaseMessagingModule.rejectPromiseWithExceptionMap((Promise)promise, (Exception)task.getException());
            }
        });
    }

    @ReactMethod
    public void setDeliveryMetricsExportToBigQuery(Boolean enabled, Promise promise) {
        Tasks.call((Executor)this.getExecutor(), () -> {
            FirebaseMessaging.getInstance().setDeliveryMetricsExportToBigQuery(enabled.booleanValue());
            return null;
        }).addOnCompleteListener(task -> {
            if (task.isSuccessful()) {
                promise.resolve((Object)FirebaseMessaging.getInstance().deliveryMetricsExportToBigQueryEnabled());
            } else {
                ReactNativeFirebaseMessagingModule.rejectPromiseWithExceptionMap((Promise)promise, (Exception)task.getException());
            }
        });
    }

    public Map<String, Object> getConstants() {
        HashMap<String, Object> constants = new HashMap<String, Object>();
        constants.put("isAutoInitEnabled", FirebaseMessaging.getInstance().isAutoInitEnabled());
        constants.put("isDeliveryMetricsExportToBigQueryEnabled", FirebaseMessaging.getInstance().deliveryMetricsExportToBigQueryEnabled());
        return constants;
    }

    public void onActivityResult(Activity activity, int requestCode, int resultCode, Intent data) {
    }

    public void onNewIntent(Intent intent) {
        if (intent != null && intent.getExtras() != null) {
            RemoteMessage remoteMessage;
            WritableMap remoteMessageMap;
            String messageId = intent.getExtras().getString("google.message_id");
            if (messageId == null) {
                messageId = intent.getExtras().getString("message_id");
            }
            if (messageId != null && (remoteMessageMap = (remoteMessage = ReactNativeFirebaseMessagingReceiver.notifications.get(messageId)) == null ? this.popRemoteMessageMapFromMessagingStore(messageId) : ReactNativeFirebaseMessagingSerializer.remoteMessageToWritableMap(remoteMessage)) != null) {
                WritableNativeMap newInitialNotification = new WritableNativeMap();
                newInitialNotification.merge((ReadableMap)remoteMessageMap);
                this.initialNotification = newInitialNotification;
                ReactNativeFirebaseMessagingReceiver.notifications.remove(messageId);
                ReactNativeFirebaseEventEmitter emitter = ReactNativeFirebaseEventEmitter.getSharedInstance();
                emitter.sendEvent((NativeEvent)ReactNativeFirebaseMessagingSerializer.remoteMessageMapToEvent(remoteMessageMap, true));
            }
        }
    }
}

