/*
 * Decompiled with CFR 0.152.
 */
package io.invertase.firebase.messaging;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;
import android.util.Log;
import com.facebook.react.HeadlessJsTaskService;
import com.google.firebase.messaging.RemoteMessage;
import io.invertase.firebase.app.ReactNativeFirebaseApp;
import io.invertase.firebase.common.ReactNativeFirebaseEventEmitter;
import io.invertase.firebase.common.SharedUtils;
import io.invertase.firebase.interfaces.NativeEvent;
import io.invertase.firebase.messaging.ReactNativeFirebaseMessagingHeadlessService;
import io.invertase.firebase.messaging.ReactNativeFirebaseMessagingSerializer;
import io.invertase.firebase.messaging.ReactNativeFirebaseMessagingStoreHelper;
import java.util.HashMap;

public class ReactNativeFirebaseMessagingReceiver
extends BroadcastReceiver {
    private static final String TAG = "RNFirebaseMsgReceiver";
    static HashMap<String, RemoteMessage> notifications = new HashMap();

    public void onReceive(Context context, Intent intent) {
        Log.d((String)TAG, (String)"broadcast received for message");
        if (ReactNativeFirebaseApp.getApplicationContext() == null) {
            ReactNativeFirebaseApp.setApplicationContext((Context)context.getApplicationContext());
        }
        if (intent.getExtras() == null) {
            Log.e((String)TAG, (String)"broadcast intent received with no extras");
            return;
        }
        RemoteMessage remoteMessage = new RemoteMessage(intent.getExtras());
        ReactNativeFirebaseEventEmitter emitter = ReactNativeFirebaseEventEmitter.getSharedInstance();
        if (remoteMessage.getNotification() != null) {
            notifications.put(remoteMessage.getMessageId(), remoteMessage);
            ReactNativeFirebaseMessagingStoreHelper.getInstance().getMessagingStore().storeFirebaseMessage(remoteMessage);
        }
        if (SharedUtils.isAppInForeground((Context)context)) {
            emitter.sendEvent((NativeEvent)ReactNativeFirebaseMessagingSerializer.remoteMessageToEvent(remoteMessage, false));
            return;
        }
        try {
            Intent backgroundIntent = new Intent(context, ReactNativeFirebaseMessagingHeadlessService.class);
            backgroundIntent.putExtra("message", (Parcelable)remoteMessage);
            ComponentName name = context.startService(backgroundIntent);
            if (name != null) {
                HeadlessJsTaskService.acquireWakeLockNow((Context)context);
            }
        }
        catch (IllegalStateException ex) {
            Log.e((String)TAG, (String)"Background messages only work if the message priority is set to 'high'", (Throwable)ex);
        }
    }
}

