/*
 * Decompiled with CFR 0.152.
 */
package io.invertase.firebase.messaging;

import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.WritableMap;
import com.google.firebase.messaging.RemoteMessage;
import io.invertase.firebase.common.UniversalFirebasePreferences;
import io.invertase.firebase.messaging.JsonConvert;
import io.invertase.firebase.messaging.ReactNativeFirebaseMessagingSerializer;
import io.invertase.firebase.messaging.ReactNativeFirebaseMessagingStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class ReactNativeFirebaseMessagingStoreImpl
implements ReactNativeFirebaseMessagingStore {
    private static final String S_KEY_ALL_NOTIFICATION_IDS = "all_notification_ids";
    private static final int MAX_SIZE_NOTIFICATIONS = 100;
    private final String DELIMITER = ",";

    @Override
    public void storeFirebaseMessage(RemoteMessage remoteMessage) {
        try {
            String remoteMessageString = JsonConvert.reactToJSON((ReadableMap)ReactNativeFirebaseMessagingSerializer.remoteMessageToWritableMap(remoteMessage)).toString();
            UniversalFirebasePreferences preferences = UniversalFirebasePreferences.getSharedInstance();
            preferences.setStringValue(remoteMessage.getMessageId(), remoteMessageString);
            String notifications = preferences.getStringValue(S_KEY_ALL_NOTIFICATION_IDS, "");
            notifications = notifications + remoteMessage.getMessageId() + ",";
            List<String> allNotificationList = this.convertToArray(notifications);
            if (allNotificationList.size() > 100) {
                String firstRemoteMessageId = allNotificationList.get(0);
                preferences.remove(firstRemoteMessageId);
                notifications = this.removeRemoteMessage(firstRemoteMessageId, notifications);
            }
            preferences.setStringValue(S_KEY_ALL_NOTIFICATION_IDS, notifications);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @Override
    @Deprecated
    public RemoteMessage getFirebaseMessage(String remoteMessageId) {
        WritableMap messageMap = this.getFirebaseMessageMap(remoteMessageId);
        if (messageMap != null) {
            return ReactNativeFirebaseMessagingSerializer.remoteMessageFromReadableMap((ReadableMap)messageMap);
        }
        return null;
    }

    @Override
    public WritableMap getFirebaseMessageMap(String remoteMessageId) {
        String remoteMessageString = UniversalFirebasePreferences.getSharedInstance().getStringValue(remoteMessageId, null);
        if (remoteMessageString != null) {
            try {
                WritableMap remoteMessageMap = JsonConvert.jsonToReact(new JSONObject(remoteMessageString));
                remoteMessageMap.putString("to", remoteMessageId);
                return remoteMessageMap;
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public void clearFirebaseMessage(String remoteMessageId) {
        UniversalFirebasePreferences preferences = UniversalFirebasePreferences.getSharedInstance();
        preferences.remove(remoteMessageId);
        String notifications = preferences.getStringValue(S_KEY_ALL_NOTIFICATION_IDS, "");
        if (!notifications.isEmpty()) {
            notifications = this.removeRemoteMessage(remoteMessageId, notifications);
            preferences.setStringValue(S_KEY_ALL_NOTIFICATION_IDS, notifications);
        }
    }

    private String removeRemoteMessage(String remoteMessageId, String notifications) {
        return notifications.replace(remoteMessageId + ",", "");
    }

    private List<String> convertToArray(String string) {
        return new ArrayList<String>(Arrays.asList(string.split(",")));
    }
}

