/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react;

import com.android.build.api.dsl.AndroidSourceDirectorySet;
import com.android.build.api.dsl.AndroidSourceSet;
import com.android.build.api.dsl.ApplicationExtension;
import com.android.build.api.dsl.LibraryExtension;
import com.android.build.api.variant.ApplicationAndroidComponentsExtension;
import com.android.build.api.variant.ApplicationVariant;
import com.android.build.api.variant.LibraryAndroidComponentsExtension;
import com.android.build.api.variant.SourceDirectories;
import com.android.build.api.variant.Variant;
import com.android.build.gradle.internal.tasks.factory.TaskFactoryUtils;
import com.facebook.react.ReactExtension;
import com.facebook.react.TaskConfigurationKt;
import com.facebook.react.internal.PrivateReactExtension;
import com.facebook.react.model.ModelPackageJson;
import com.facebook.react.tasks.GenerateAutolinkingNewArchitecturesFileTask;
import com.facebook.react.tasks.GenerateCodegenArtifactsTask;
import com.facebook.react.tasks.GenerateCodegenSchemaTask;
import com.facebook.react.tasks.GenerateEntryPointTask;
import com.facebook.react.tasks.GeneratePackageListTask;
import com.facebook.react.utils.AgpConfiguratorUtils;
import com.facebook.react.utils.BackwardCompatUtils;
import com.facebook.react.utils.DependencyUtils;
import com.facebook.react.utils.JdkConfiguratorUtils;
import com.facebook.react.utils.JsonUtils;
import com.facebook.react.utils.NdkConfiguratorUtils;
import com.facebook.react.utils.PathUtils;
import com.facebook.react.utils.ProjectUtils;
import java.io.File;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.JavaVersion;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.plugins.AppliedPlugin;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.internal.jvm.Jvm;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0010\u0010\b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u0018\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0002J(\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u000bH\u0002\u00a8\u0006\u0014"}, d2={"Lcom/facebook/react/ReactPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "<init>", "()V", "apply", "", "project", "checkJvmVersion", "configureResources", "reactExtension", "Lcom/facebook/react/ReactExtension;", "configureCodegen", "localExtension", "rootExtension", "Lcom/facebook/react/internal/PrivateReactExtension;", "isLibrary", "", "configureAutolinking", "extension", "react-native-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nReactPlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReactPlugin.kt\ncom/facebook/react/ReactPlugin\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,305:1\n1#2:306\n*E\n"})
public final class ReactPlugin
implements Plugin<Project> {
    public void apply(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.checkJvmVersion(project);
        Object[] objectArray = new Object[]{project};
        ReactExtension extension = (ReactExtension)project.getExtensions().create("react", ReactExtension.class, objectArray);
        PrivateReactExtension privateReactExtension = (PrivateReactExtension)project.getRootProject().getExtensions().findByType(PrivateReactExtension.class);
        if (privateReactExtension == null) {
            Object[] objectArray2 = new Object[]{project};
            privateReactExtension = (PrivateReactExtension)project.getRootProject().getExtensions().create("privateReact", PrivateReactExtension.class, objectArray2);
        }
        PrivateReactExtension rootExtension = privateReactExtension;
        project.getPluginManager().withPlugin("com.android.application", arg_0 -> ReactPlugin.apply$lambda$5(arg_0 -> ReactPlugin.apply$lambda$4(rootExtension, extension, project, this, arg_0), arg_0));
        AgpConfiguratorUtils.INSTANCE.configureBuildConfigFieldsForLibraries(project);
        AgpConfiguratorUtils.INSTANCE.configureNamespaceForLibraries(project);
        project.getPluginManager().withPlugin("com.android.library", arg_0 -> ReactPlugin.apply$lambda$7(arg_0 -> ReactPlugin.apply$lambda$6(this, project, extension, rootExtension, arg_0), arg_0));
    }

    private final void checkJvmVersion(Project project) {
        JavaVersion javaVersion = Jvm.current().getJavaVersion();
        String jvmVersion = javaVersion != null ? javaVersion.getMajorVersion() : null;
        Object object = jvmVersion;
        if ((object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 0) <= 16) {
            project.getLogger().error(StringsKt.trimIndent((String)("\n\n      ********************************************************************************\n\n      ERROR: requires JDK17 or higher.\n      Incompatible major version detected: '" + jvmVersion + "'\n\n      ********************************************************************************\n\n      ")));
            System.exit(1);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
    }

    private final void configureResources(Project project, ReactExtension reactExtension) {
        ((ApplicationAndroidComponentsExtension)project.getExtensions().getByType(ApplicationAndroidComponentsExtension.class)).finalizeDsl(arg_0 -> ReactPlugin.configureResources$lambda$8(reactExtension, arg_0));
    }

    private final void configureCodegen(Project project, ReactExtension localExtension, PrivateReactExtension rootExtension, boolean isLibrary) {
        Provider provider = project.getLayout().getBuildDirectory().dir("generated/source/codegen");
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"dir(...)");
        Provider generatedSrcDir = provider;
        DirectoryProperty directoryProperty = isLibrary ? localExtension.getJsRootDir().convention(project.getLayout().getProjectDirectory().dir("../")) : localExtension.getJsRootDir().convention((Provider)localExtension.getRoot());
        TaskProvider generateCodegenSchemaTask = project.getTasks().register("generateCodegenSchemaFromJavaScript", GenerateCodegenSchemaTask.class, arg_0 -> ReactPlugin.configureCodegen$lambda$15(arg_0 -> ReactPlugin.configureCodegen$lambda$14(rootExtension, generatedSrcDir, project, localExtension, isLibrary, arg_0), arg_0));
        TaskProvider generateCodegenArtifactsTask = project.getTasks().register("generateCodegenArtifactsFromSchema", GenerateCodegenArtifactsTask.class, arg_0 -> ReactPlugin.configureCodegen$lambda$20(arg_0 -> ReactPlugin.configureCodegen$lambda$19(generateCodegenSchemaTask, rootExtension, generatedSrcDir, project, localExtension, isLibrary, arg_0), arg_0));
        if (isLibrary) {
            ((LibraryAndroidComponentsExtension)project.getExtensions().getByType(LibraryAndroidComponentsExtension.class)).finalizeDsl(arg_0 -> ReactPlugin.configureCodegen$lambda$21(generatedSrcDir, arg_0));
        } else {
            ((ApplicationAndroidComponentsExtension)project.getExtensions().getByType(ApplicationAndroidComponentsExtension.class)).finalizeDsl(arg_0 -> ReactPlugin.configureCodegen$lambda$22(generatedSrcDir, arg_0));
        }
        TaskProvider taskProvider = project.getTasks().named("preBuild", Task.class);
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"named(...)");
        TaskProvider[] taskProviderArray = new TaskProvider[]{generateCodegenArtifactsTask};
        TaskFactoryUtils.dependsOn((TaskProvider)taskProvider, (TaskProvider[])taskProviderArray);
    }

    private final void configureAutolinking(Project project, ReactExtension extension) {
        Provider provider = project.getLayout().getBuildDirectory().dir("generated/autolinking/src/main/java");
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"dir(...)");
        Provider generatedAutolinkingJavaDir = provider;
        Provider provider2 = project.getLayout().getBuildDirectory().dir("generated/autolinking/src/main/jni");
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"dir(...)");
        Provider generatedAutolinkingJniDir = provider2;
        Provider rootGeneratedAutolinkingFile = project.getRootProject().getLayout().getBuildDirectory().file("generated/autolinking/autolinking.json");
        TaskProvider generatePackageListTask = project.getTasks().register("generateAutolinkingPackageList", GeneratePackageListTask.class, arg_0 -> ReactPlugin.configureAutolinking$lambda$24(arg_0 -> ReactPlugin.configureAutolinking$lambda$23(rootGeneratedAutolinkingFile, generatedAutolinkingJavaDir, arg_0), arg_0));
        TaskProvider generateEntryPointTask = project.getTasks().register("generateReactNativeEntryPoint", GenerateEntryPointTask.class, arg_0 -> ReactPlugin.configureAutolinking$lambda$26(arg_0 -> ReactPlugin.configureAutolinking$lambda$25(rootGeneratedAutolinkingFile, generatedAutolinkingJavaDir, arg_0), arg_0));
        if (ProjectUtils.INSTANCE.isNewArchEnabled$react_native_gradle_plugin(project, extension)) {
            TaskProvider generateAutolinkingNewArchitectureFilesTask = project.getTasks().register("generateAutolinkingNewArchitectureFiles", GenerateAutolinkingNewArchitecturesFileTask.class, arg_0 -> ReactPlugin.configureAutolinking$lambda$28(arg_0 -> ReactPlugin.configureAutolinking$lambda$27(rootGeneratedAutolinkingFile, generatedAutolinkingJniDir, arg_0), arg_0));
            TaskProvider taskProvider = project.getTasks().named("preBuild", Task.class);
            Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"named(...)");
            TaskProvider[] taskProviderArray = new TaskProvider[]{generateAutolinkingNewArchitectureFilesTask};
            TaskFactoryUtils.dependsOn((TaskProvider)taskProvider, (TaskProvider[])taskProviderArray);
        }
        TaskProvider taskProvider = project.getTasks().named("preBuild", Task.class);
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"named(...)");
        Object object = new TaskProvider[]{generatePackageListTask, generateEntryPointTask};
        TaskFactoryUtils.dependsOn((TaskProvider)taskProvider, (TaskProvider[])object);
        object = project.getExtensions().getByType(ApplicationAndroidComponentsExtension.class);
        ApplicationAndroidComponentsExtension $this$configureAutolinking_u24lambda_u2430 = (ApplicationAndroidComponentsExtension)object;
        boolean bl = false;
        $this$configureAutolinking_u24lambda_u2430.onVariants($this$configureAutolinking_u24lambda_u2430.selector().all(), arg_0 -> ReactPlugin.configureAutolinking$lambda$30$lambda$29(generatedAutolinkingJavaDir, arg_0));
    }

    private static final Unit apply$lambda$4$lambda$0(ReactExtension $extension, Project $project, Project it) {
        File reactNativeDir = ((Directory)$extension.getReactNativeDir().get()).getAsFile();
        File propertiesFile = new File(reactNativeDir, "ReactAndroid/gradle.properties");
        Pair<String, String> versionAndGroupStrings = DependencyUtils.INSTANCE.readVersionAndGroupStrings(propertiesFile);
        String versionString = (String)versionAndGroupStrings.getFirst();
        String groupString = (String)versionAndGroupStrings.getSecond();
        DependencyUtils.INSTANCE.configureDependencies($project, versionString, groupString);
        DependencyUtils.INSTANCE.configureRepositories($project);
        return Unit.INSTANCE;
    }

    private static final void apply$lambda$4$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit apply$lambda$4$lambda$3$lambda$2(Project $project, ReactExtension $extension, ApplicationVariant variant) {
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        Variant variant2 = (Variant)variant;
        Intrinsics.checkNotNull((Object)$extension);
        TaskConfigurationKt.configureReactTasks($project, variant2, $extension);
        return Unit.INSTANCE;
    }

    private static final Unit apply$lambda$4(PrivateReactExtension $rootExtension, ReactExtension $extension, Project $project, ReactPlugin this$0, AppliedPlugin it) {
        $rootExtension.getRoot().set((Provider)$extension.getRoot());
        $rootExtension.getReactNativeDir().set((Provider)$extension.getReactNativeDir());
        $rootExtension.getCodegenDir().set((Provider)$extension.getCodegenDir());
        $rootExtension.getNodeExecutableAndArgs().set((Provider)$extension.getNodeExecutableAndArgs());
        $project.afterEvaluate(arg_0 -> ReactPlugin.apply$lambda$4$lambda$1(arg_0 -> ReactPlugin.apply$lambda$4$lambda$0($extension, $project, arg_0), arg_0));
        Intrinsics.checkNotNull((Object)$extension);
        NdkConfiguratorUtils.INSTANCE.configureReactNativeNdk($project, $extension);
        AgpConfiguratorUtils.INSTANCE.configureBuildConfigFieldsForApp($project, $extension);
        AgpConfiguratorUtils.INSTANCE.configureDevServerLocation($project);
        BackwardCompatUtils.INSTANCE.configureBackwardCompatibilityReactMap($project);
        JdkConfiguratorUtils.INSTANCE.configureJavaToolChains($project);
        Object object = $project.getExtensions().getByType(ApplicationAndroidComponentsExtension.class);
        ApplicationAndroidComponentsExtension $this$apply_u24lambda_u244_u24lambda_u243 = (ApplicationAndroidComponentsExtension)object;
        boolean bl = false;
        $this$apply_u24lambda_u244_u24lambda_u243.onVariants($this$apply_u24lambda_u244_u24lambda_u243.selector().all(), arg_0 -> ReactPlugin.apply$lambda$4$lambda$3$lambda$2($project, $extension, arg_0));
        this$0.configureAutolinking($project, $extension);
        Intrinsics.checkNotNull((Object)$rootExtension);
        this$0.configureCodegen($project, $extension, $rootExtension, false);
        this$0.configureResources($project, $extension);
        AgpConfiguratorUtils.INSTANCE.configureBuildTypesForApp($project);
        return Unit.INSTANCE;
    }

    private static final void apply$lambda$5(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit apply$lambda$6(ReactPlugin this$0, Project $project, ReactExtension $extension, PrivateReactExtension $rootExtension, AppliedPlugin it) {
        Intrinsics.checkNotNull((Object)$extension);
        Intrinsics.checkNotNull((Object)$rootExtension);
        this$0.configureCodegen($project, $extension, $rootExtension, true);
        return Unit.INSTANCE;
    }

    private static final void apply$lambda$7(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit configureResources$lambda$8(ReactExtension $reactExtension, ApplicationExtension ext) {
        Intrinsics.checkNotNullParameter((Object)ext, (String)"ext");
        Object object = $reactExtension.getBundleAssetName().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        String bundleFileExtension = StringsKt.substringAfterLast((String)((String)object), (char)'.', (String)"");
        if (!((Boolean)$reactExtension.getEnableBundleCompression().get()).booleanValue() && !StringsKt.isBlank((CharSequence)bundleFileExtension)) {
            ext.getAndroidResources().getNoCompress().add(bundleFileExtension);
        }
        return Unit.INSTANCE;
    }

    private static final Unit configureCodegen$lambda$14$lambda$10(ConfigurableFileTree tree) {
        String[] stringArray = new String[]{"**/*.js"};
        tree.include(stringArray);
        stringArray = new String[]{"**/*.jsx"};
        tree.include(stringArray);
        stringArray = new String[]{"**/*.ts"};
        tree.include(stringArray);
        stringArray = new String[]{"**/*.tsx"};
        tree.include(stringArray);
        stringArray = new String[]{"node_modules/**/*"};
        tree.exclude(stringArray);
        stringArray = new String[]{"**/*.d.ts"};
        tree.exclude(stringArray);
        stringArray = new String[]{"**/build/**/*"};
        tree.exclude(stringArray);
        return Unit.INSTANCE;
    }

    private static final void configureCodegen$lambda$14$lambda$11(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final boolean configureCodegen$lambda$14$lambda$12(boolean $isLibrary, boolean $needsCodegenFromPackageJson, boolean $includesGeneratedCode, Task it) {
        return ($isLibrary || $needsCodegenFromPackageJson) && !$includesGeneratedCode;
    }

    private static final boolean configureCodegen$lambda$14$lambda$13(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit configureCodegen$lambda$14(PrivateReactExtension $rootExtension, Provider $generatedSrcDir, Project $project, ReactExtension $localExtension, boolean $isLibrary, GenerateCodegenSchemaTask it) {
        boolean includesGeneratedCode;
        ModelPackageJson parsedPackageJson;
        ModelPackageJson modelPackageJson;
        ModelPackageJson modelPackageJson2;
        File packageJson;
        it.getNodeExecutableAndArgs().set((Provider)$rootExtension.getNodeExecutableAndArgs());
        it.getCodegenDir().set((Provider)$rootExtension.getCodegenDir());
        it.getGeneratedSrcDir().set($generatedSrcDir);
        it.getNodeWorkingDir().set((Object)$project.getLayout().getProjectDirectory().getAsFile().getAbsolutePath());
        File file = packageJson = PathUtils.findPackageJsonFile($project, $rootExtension.getRoot());
        if (file != null) {
            File it2 = file;
            boolean bl = false;
            modelPackageJson2 = JsonUtils.INSTANCE.fromPackageJson(it2);
        } else {
            modelPackageJson2 = null;
        }
        String jsSrcsDirInPackageJson = (modelPackageJson = (parsedPackageJson = modelPackageJson2)) != null && (modelPackageJson = modelPackageJson.getCodegenConfig()) != null ? modelPackageJson.getJsSrcsDir() : null;
        Object object = parsedPackageJson;
        boolean bl = object != null && (object = object.getCodegenConfig()) != null && (object = object.getIncludesGeneratedCode()) != null ? (Boolean)object : (includesGeneratedCode = false);
        if (jsSrcsDirInPackageJson != null) {
            it.getJsRootDir().set(new File(packageJson.getParentFile(), jsSrcsDirInPackageJson));
        } else {
            it.getJsRootDir().set((Provider)$localExtension.getJsRootDir());
        }
        it.getJsInputFiles().set((Object)$project.fileTree((Object)it.getJsRootDir(), arg_0 -> ReactPlugin.configureCodegen$lambda$14$lambda$11(ReactPlugin::configureCodegen$lambda$14$lambda$10, arg_0)));
        boolean needsCodegenFromPackageJson = ProjectUtils.INSTANCE.needsCodegenFromPackageJson$react_native_gradle_plugin($project, $rootExtension.getRoot());
        it.onlyIf(arg_0 -> ReactPlugin.configureCodegen$lambda$14$lambda$13(arg_0 -> ReactPlugin.configureCodegen$lambda$14$lambda$12($isLibrary, needsCodegenFromPackageJson, includesGeneratedCode, arg_0), arg_0));
        return Unit.INSTANCE;
    }

    private static final void configureCodegen$lambda$15(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final boolean configureCodegen$lambda$19$lambda$17(boolean $isLibrary, boolean $needsCodegenFromPackageJson, boolean $includesGeneratedCode, Task it) {
        return ($isLibrary || $needsCodegenFromPackageJson) && !$includesGeneratedCode;
    }

    private static final boolean configureCodegen$lambda$19$lambda$18(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit configureCodegen$lambda$19(TaskProvider $generateCodegenSchemaTask, PrivateReactExtension $rootExtension, Provider $generatedSrcDir, Project $project, ReactExtension $localExtension, boolean $isLibrary, GenerateCodegenArtifactsTask task) {
        ModelPackageJson parsedPackageJson;
        Object object;
        ModelPackageJson modelPackageJson;
        File packageJson;
        Object[] objectArray = new Object[]{$generateCodegenSchemaTask};
        task.dependsOn(objectArray);
        task.getReactNativeDir().set((Provider)$rootExtension.getReactNativeDir());
        task.getNodeExecutableAndArgs().set((Provider)$rootExtension.getNodeExecutableAndArgs());
        task.getGeneratedSrcDir().set($generatedSrcDir);
        task.getPackageJsonFile().set(PathUtils.findPackageJsonFile($project, $rootExtension.getRoot()));
        task.getCodegenJavaPackageName().set((Provider)$localExtension.getCodegenJavaPackageName());
        task.getLibraryName().set((Provider)$localExtension.getLibraryName());
        task.getNodeWorkingDir().set((Object)$project.getLayout().getProjectDirectory().getAsFile().getAbsolutePath());
        boolean needsCodegenFromPackageJson = ProjectUtils.INSTANCE.needsCodegenFromPackageJson$react_native_gradle_plugin($project, $rootExtension.getRoot());
        File file = packageJson = PathUtils.findPackageJsonFile($project, $rootExtension.getRoot());
        if (file != null) {
            File it = file;
            boolean bl = false;
            modelPackageJson = JsonUtils.INSTANCE.fromPackageJson(it);
        } else {
            modelPackageJson = null;
        }
        boolean includesGeneratedCode = (object = (parsedPackageJson = modelPackageJson)) != null && (object = object.getCodegenConfig()) != null && (object = object.getIncludesGeneratedCode()) != null ? (Boolean)object : false;
        task.onlyIf(arg_0 -> ReactPlugin.configureCodegen$lambda$19$lambda$18(arg_0 -> ReactPlugin.configureCodegen$lambda$19$lambda$17($isLibrary, needsCodegenFromPackageJson, includesGeneratedCode, arg_0), arg_0));
        return Unit.INSTANCE;
    }

    private static final void configureCodegen$lambda$20(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit configureCodegen$lambda$21(Provider $generatedSrcDir, LibraryExtension ext) {
        Intrinsics.checkNotNullParameter((Object)ext, (String)"ext");
        AndroidSourceDirectorySet androidSourceDirectorySet = ((AndroidSourceSet)ext.getSourceSets().getByName("main")).getJava();
        File file = ((Directory)$generatedSrcDir.get()).dir("java").getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAsFile(...)");
        androidSourceDirectorySet.srcDir((Object)file);
        return Unit.INSTANCE;
    }

    private static final Unit configureCodegen$lambda$22(Provider $generatedSrcDir, ApplicationExtension ext) {
        Intrinsics.checkNotNullParameter((Object)ext, (String)"ext");
        AndroidSourceDirectorySet androidSourceDirectorySet = ((AndroidSourceSet)ext.getSourceSets().getByName("main")).getJava();
        File file = ((Directory)$generatedSrcDir.get()).dir("java").getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAsFile(...)");
        androidSourceDirectorySet.srcDir((Object)file);
        return Unit.INSTANCE;
    }

    private static final Unit configureAutolinking$lambda$23(Provider $rootGeneratedAutolinkingFile, Provider $generatedAutolinkingJavaDir, GeneratePackageListTask task) {
        task.getAutolinkInputFile().set($rootGeneratedAutolinkingFile);
        task.getGeneratedOutputDirectory().set($generatedAutolinkingJavaDir);
        return Unit.INSTANCE;
    }

    private static final void configureAutolinking$lambda$24(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit configureAutolinking$lambda$25(Provider $rootGeneratedAutolinkingFile, Provider $generatedAutolinkingJavaDir, GenerateEntryPointTask task) {
        task.getAutolinkInputFile().set($rootGeneratedAutolinkingFile);
        task.getGeneratedOutputDirectory().set($generatedAutolinkingJavaDir);
        return Unit.INSTANCE;
    }

    private static final void configureAutolinking$lambda$26(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit configureAutolinking$lambda$27(Provider $rootGeneratedAutolinkingFile, Provider $generatedAutolinkingJniDir, GenerateAutolinkingNewArchitecturesFileTask task) {
        task.getAutolinkInputFile().set($rootGeneratedAutolinkingFile);
        task.getGeneratedOutputDirectory().set($generatedAutolinkingJniDir);
        return Unit.INSTANCE;
    }

    private static final void configureAutolinking$lambda$28(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit configureAutolinking$lambda$30$lambda$29(Provider $generatedAutolinkingJavaDir, ApplicationVariant variant) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
            SourceDirectories.Flat flat = variant.getSources().getJava();
            if (flat == null) break block0;
            String string = ((Directory)$generatedAutolinkingJavaDir.get()).getAsFile().getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
            flat.addStaticSourceDirectory(string);
        }
        return Unit.INSTANCE;
    }
}

