/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react;

import com.android.build.api.variant.SourceDirectories;
import com.android.build.api.variant.Variant;
import com.facebook.react.ReactExtension;
import com.facebook.react.TaskConfigurationKt;
import com.facebook.react.tasks.BundleHermesCTask;
import com.facebook.react.utils.BackwardCompatUtils;
import com.facebook.react.utils.KotlinStdlibCompatUtils;
import com.facebook.react.utils.NdkConfiguratorUtils;
import com.facebook.react.utils.PathUtils;
import com.facebook.react.utils.ProjectUtils;
import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a8\u0006\u0007"}, d2={"configureReactTasks", "", "Lorg/gradle/api/Project;", "variant", "Lcom/android/build/api/variant/Variant;", "config", "Lcom/facebook/react/ReactExtension;", "react-native-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nTaskConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TaskConfiguration.kt\ncom/facebook/react/TaskConfigurationKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,90:1\n1755#2,3:91\n*S KotlinDebug\n*F\n+ 1 TaskConfiguration.kt\ncom/facebook/react/TaskConfigurationKt\n*L\n52#1:91,3\n*E\n"})
public final class TaskConfigurationKt {
    public static final void configureReactTasks(@NotNull Project $this$configureReactTasks, @NotNull Variant variant, @NotNull ReactExtension config) {
        block7: {
            boolean bl;
            boolean isHermesEnabledInThisVariant;
            File cliFile;
            File jsIntermediateSourceMapsDir;
            File jsSourceMapsDir;
            File jsBundleDir;
            File resourcesDir;
            String targetName;
            block6: {
                Intrinsics.checkNotNullParameter((Object)$this$configureReactTasks, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
                Intrinsics.checkNotNullParameter((Object)config, (String)"config");
                targetName = KotlinStdlibCompatUtils.INSTANCE.capitalizeCompat(variant.getName());
                String targetPath = variant.getName();
                File buildDir = ((Directory)$this$configureReactTasks.getLayout().getBuildDirectory().get()).getAsFile();
                resourcesDir = new File(buildDir, "generated/res/react/" + targetPath);
                jsBundleDir = new File(buildDir, "generated/assets/react/" + targetPath);
                jsSourceMapsDir = new File(buildDir, "generated/sourcemaps/react/" + targetPath);
                jsIntermediateSourceMapsDir = new File(buildDir, "intermediates/sourcemaps/react/" + targetPath);
                cliFile = PathUtils.detectedCliFile(config);
                Project project = $this$configureReactTasks.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                boolean isHermesEnabledInProject = ProjectUtils.INSTANCE.isHermesEnabled$react_native_gradle_plugin(project);
                Object object = config.getEnableHermesOnlyInVariants().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                isHermesEnabledInThisVariant = !((Collection)object).isEmpty() ? ((List)config.getEnableHermesOnlyInVariants().get()).contains(variant.getName()) && isHermesEnabledInProject : isHermesEnabledInProject;
                Object object2 = config.getDebuggableVariants().get();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
                Iterable $this$any$iv = (Iterable)object2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        if (!StringsKt.equals((String)it, (String)variant.getName(), (boolean)true)) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            boolean isDebuggableVariant = bl;
            Project project = $this$configureReactTasks.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            boolean useThirdPartyJSC = ProjectUtils.INSTANCE.getUseThirdPartyJSC$react_native_gradle_plugin(project);
            Project project2 = $this$configureReactTasks.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            NdkConfiguratorUtils.INSTANCE.configureNewArchPackagingOptions(project2, config, variant);
            NdkConfiguratorUtils.INSTANCE.configureJsEnginePackagingOptions(config, variant, isHermesEnabledInThisVariant, useThirdPartyJSC);
            if (!(isHermesEnabledInThisVariant || useThirdPartyJSC || Intrinsics.areEqual((Object)$this$configureReactTasks.getRootProject().getName(), (Object)"react-native-github"))) {
                Project project3 = $this$configureReactTasks.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
                BackwardCompatUtils.INSTANCE.showJSCRemovalMessage(project3);
            }
            if (isDebuggableVariant) break block7;
            String entryFileEnvVariable = System.getenv("ENTRY_FILE");
            TaskProvider bundleTask = $this$configureReactTasks.getTasks().register("createBundle" + targetName + "JsAndAssets", BundleHermesCTask.class, arg_0 -> TaskConfigurationKt.configureReactTasks$lambda$2(arg_0 -> TaskConfigurationKt.configureReactTasks$lambda$1(config, cliFile, entryFileEnvVariable, jsBundleDir, resourcesDir, isHermesEnabledInThisVariant, jsIntermediateSourceMapsDir, jsSourceMapsDir, arg_0), arg_0));
            SourceDirectories.Layered layered = variant.getSources().getRes();
            if (layered != null) {
                Intrinsics.checkNotNull((Object)bundleTask);
                layered.addGeneratedSourceDirectory(bundleTask, (Function1)configureReactTasks.1.INSTANCE);
            }
            SourceDirectories.Layered layered2 = variant.getSources().getAssets();
            if (layered2 != null) {
                Intrinsics.checkNotNull((Object)bundleTask);
                layered2.addGeneratedSourceDirectory(bundleTask, (Function1)configureReactTasks.2.INSTANCE);
            }
        }
    }

    private static final Unit configureReactTasks$lambda$1(ReactExtension $config, File $cliFile, String $entryFileEnvVariable, File $jsBundleDir, File $resourcesDir, boolean $isHermesEnabledInThisVariant, File $jsIntermediateSourceMapsDir, File $jsSourceMapsDir, BundleHermesCTask it) {
        it.getRoot().set((Provider)$config.getRoot());
        it.getNodeExecutableAndArgs().set((Provider)$config.getNodeExecutableAndArgs());
        it.getCliFile().set($cliFile);
        it.getBundleCommand().set((Provider)$config.getBundleCommand());
        it.getEntryFile().set(PathUtils.detectedEntryFile($config, $entryFileEnvVariable));
        it.getExtraPackagerArgs().set((Provider)$config.getExtraPackagerArgs());
        it.getBundleConfig().set((Provider)$config.getBundleConfig());
        it.getBundleAssetName().set((Provider)$config.getBundleAssetName());
        it.getJsBundleDir().set($jsBundleDir);
        it.getResourcesDir().set($resourcesDir);
        it.getHermesEnabled().set((Object)$isHermesEnabledInThisVariant);
        it.getMinifyEnabled().set((Object)(!$isHermesEnabledInThisVariant ? 1 : 0));
        it.getDevEnabled().set((Object)false);
        it.getJsIntermediateSourceMapsDir().set($jsIntermediateSourceMapsDir);
        it.getJsSourceMapsDir().set($jsSourceMapsDir);
        it.getHermesCommand().set((Provider)$config.getHermesCommand());
        it.getHermesFlags().set((Provider)$config.getHermesFlags());
        it.getReactNativeDir().set((Provider)$config.getReactNativeDir());
        return Unit.INSTANCE;
    }

    private static final void configureReactTasks$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

