/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.tasks;

import com.facebook.react.utils.FileUtilsKt;
import com.facebook.react.utils.Os;
import com.facebook.react.utils.PathUtils;
import com.facebook.react.utils.TaskUtilsKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.ExecOperations;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0014\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\b\r\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010:\u001a\u00020;H\u0007J\u0015\u0010<\u001a\u00020=2\u0006\u0010#\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b>J\u0015\u0010?\u001a\u00020=2\u0006\u0010#\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b@J\u0015\u0010A\u001a\u00020=2\u0006\u0010#\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\bBJ\u0016\u0010C\u001a\u00020;2\f\u0010D\u001a\b\u0012\u0004\u0012\u00020F0EH\u0002J#\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020F0E2\u0006\u0010G\u001a\u00020=2\u0006\u0010H\u001a\u00020=H\u0000\u00a2\u0006\u0002\bIJ+\u0010J\u001a\b\u0012\u0004\u0012\u00020F0E2\u0006\u0010.\u001a\u00020\u00122\u0006\u0010K\u001a\u00020=2\u0006\u0010G\u001a\u00020=H\u0000\u00a2\u0006\u0002\bLJ3\u0010M\u001a\b\u0012\u0004\u0012\u00020F0E2\u0006\u0010N\u001a\u00020=2\u0006\u0010O\u001a\u00020=2\u0006\u0010P\u001a\u00020=2\u0006\u0010Q\u001a\u00020=H\u0000\u00a2\u0006\u0002\bRR\u0014\u0010\u0004\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\f\u001a\u00020\r8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00168gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u000bR\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00120\u001c8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020\u00168gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0018R\u0014\u0010!\u001a\u00020\u00168gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0018R\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00120\u001c8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u001eR\u001a\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u001c8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u001eR\u001a\u0010(\u001a\b\u0012\u0004\u0012\u00020&0\u001c8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u001eR\u001a\u0010*\u001a\b\u0012\u0004\u0012\u00020&0\u001c8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u001eR\u001a\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u0014R\u001a\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00120\u001c8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u0010\u001eR\u001a\u00100\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u0010\u0014R\u0014\u00102\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u0010\u000bR\u0014\u00104\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u0010\u000bR\u0014\u00106\u001a\u00020\u00168gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u0010\u0018R\u0014\u00108\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b9\u0010\u000b\u00a8\u0006S"}, d2={"Lcom/facebook/react/tasks/BundleHermesCTask;", "Lorg/gradle/api/DefaultTask;", "<init>", "()V", "execOperations", "Lorg/gradle/process/ExecOperations;", "getExecOperations", "()Lorg/gradle/process/ExecOperations;", "root", "Lorg/gradle/api/file/DirectoryProperty;", "getRoot", "()Lorg/gradle/api/file/DirectoryProperty;", "sources", "Lorg/gradle/api/file/ConfigurableFileTree;", "getSources", "()Lorg/gradle/api/file/ConfigurableFileTree;", "nodeExecutableAndArgs", "Lorg/gradle/api/provider/ListProperty;", "", "getNodeExecutableAndArgs", "()Lorg/gradle/api/provider/ListProperty;", "cliFile", "Lorg/gradle/api/file/RegularFileProperty;", "getCliFile", "()Lorg/gradle/api/file/RegularFileProperty;", "reactNativeDir", "getReactNativeDir", "bundleCommand", "Lorg/gradle/api/provider/Property;", "getBundleCommand", "()Lorg/gradle/api/provider/Property;", "entryFile", "getEntryFile", "bundleConfig", "getBundleConfig", "bundleAssetName", "getBundleAssetName", "minifyEnabled", "", "getMinifyEnabled", "hermesEnabled", "getHermesEnabled", "devEnabled", "getDevEnabled", "extraPackagerArgs", "getExtraPackagerArgs", "hermesCommand", "getHermesCommand", "hermesFlags", "getHermesFlags", "jsBundleDir", "getJsBundleDir", "resourcesDir", "getResourcesDir", "jsIntermediateSourceMapsDir", "getJsIntermediateSourceMapsDir", "jsSourceMapsDir", "getJsSourceMapsDir", "run", "", "resolvePackagerSourceMapFile", "Ljava/io/File;", "resolvePackagerSourceMapFile$react_native_gradle_plugin", "resolveOutputSourceMap", "resolveOutputSourceMap$react_native_gradle_plugin", "resolveCompilerSourceMap", "resolveCompilerSourceMap$react_native_gradle_plugin", "runCommand", "command", "", "", "bundleFile", "sourceMapFile", "getBundleCommand$react_native_gradle_plugin", "getHermescCommand", "bytecodeFile", "getHermescCommand$react_native_gradle_plugin", "getComposeSourceMapsCommand", "composeScript", "packagerSourceMap", "compilerSourceMap", "outputSourceMap", "getComposeSourceMapsCommand$react_native_gradle_plugin", "react-native-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nBundleHermesCTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BundleHermesCTask.kt\ncom/facebook/react/tasks/BundleHermesCTask\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,205:1\n37#2,2:206\n37#2,2:208\n*S KotlinDebug\n*F\n+ 1 BundleHermesCTask.kt\ncom/facebook/react/tasks/BundleHermesCTask\n*L\n186#1:206,2\n197#1:208,2\n*E\n"})
public abstract class BundleHermesCTask
extends DefaultTask {
    @NotNull
    private final ConfigurableFileTree sources;

    public BundleHermesCTask() {
        this.setGroup("react");
        ConfigurableFileTree configurableFileTree = this.getProject().fileTree((Object)this.getRoot(), arg_0 -> BundleHermesCTask.sources$lambda$1(BundleHermesCTask::sources$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)configurableFileTree, (String)"fileTree(...)");
        this.sources = configurableFileTree;
    }

    @Inject
    @NotNull
    public abstract ExecOperations getExecOperations();

    @Internal
    @NotNull
    public abstract DirectoryProperty getRoot();

    @InputFiles
    @NotNull
    public final ConfigurableFileTree getSources() {
        return this.sources;
    }

    @Input
    @NotNull
    public abstract ListProperty<String> getNodeExecutableAndArgs();

    @InputFile
    @NotNull
    public abstract RegularFileProperty getCliFile();

    @Internal
    @NotNull
    public abstract DirectoryProperty getReactNativeDir();

    @Input
    @NotNull
    public abstract Property<String> getBundleCommand();

    @InputFile
    @NotNull
    public abstract RegularFileProperty getEntryFile();

    @InputFile
    @Optional
    @NotNull
    public abstract RegularFileProperty getBundleConfig();

    @Input
    @NotNull
    public abstract Property<String> getBundleAssetName();

    @Input
    @NotNull
    public abstract Property<Boolean> getMinifyEnabled();

    @Input
    @NotNull
    public abstract Property<Boolean> getHermesEnabled();

    @Input
    @NotNull
    public abstract Property<Boolean> getDevEnabled();

    @Input
    @NotNull
    public abstract ListProperty<String> getExtraPackagerArgs();

    @Input
    @NotNull
    public abstract Property<String> getHermesCommand();

    @Input
    @NotNull
    public abstract ListProperty<String> getHermesFlags();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getJsBundleDir();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getResourcesDir();

    @OutputDirectory
    @NotNull
    public abstract RegularFileProperty getJsIntermediateSourceMapsDir();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getJsSourceMapsDir();

    @TaskAction
    public final void run() {
        ((Directory)this.getJsBundleDir().get()).getAsFile().mkdirs();
        ((Directory)this.getResourcesDir().get()).getAsFile().mkdirs();
        ((RegularFile)this.getJsIntermediateSourceMapsDir().get()).getAsFile().mkdirs();
        ((Directory)this.getJsSourceMapsDir().get()).getAsFile().mkdirs();
        String bundleAssetFilename = (String)this.getBundleAssetName().get();
        File bundleFile = new File(((Directory)this.getJsBundleDir().get()).getAsFile(), bundleAssetFilename);
        Intrinsics.checkNotNull((Object)bundleAssetFilename);
        File packagerSourceMap = this.resolvePackagerSourceMapFile$react_native_gradle_plugin(bundleAssetFilename);
        List<Object> bundleCommand = this.getBundleCommand$react_native_gradle_plugin(bundleFile, packagerSourceMap);
        this.runCommand(bundleCommand);
        if (((Boolean)this.getHermesEnabled().get()).booleanValue()) {
            File file = ((Directory)this.getRoot().get()).getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAsFile(...)");
            Object object = this.getHermesCommand().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            String detectedHermesCommand = PathUtils.detectOSAwareHermesCommand(file, (String)object);
            File bytecodeFile = new File(bundleFile + ".hbc");
            File outputSourceMap = this.resolveOutputSourceMap$react_native_gradle_plugin(bundleAssetFilename);
            File compilerSourceMap = this.resolveCompilerSourceMap$react_native_gradle_plugin(bundleAssetFilename);
            List<Object> hermesCommand = this.getHermescCommand$react_native_gradle_plugin(detectedHermesCommand, bytecodeFile, bundleFile);
            this.runCommand(hermesCommand);
            FileUtilsKt.moveTo(bytecodeFile, bundleFile);
            if (((List)this.getHermesFlags().get()).contains("-output-source-map")) {
                File hermesTempSourceMapFile = new File(bytecodeFile + ".map");
                FileUtilsKt.moveTo(hermesTempSourceMapFile, compilerSourceMap);
                File reactNativeDir = ((Directory)this.getReactNativeDir().get()).getAsFile();
                File composeScriptFile = new File(reactNativeDir, "scripts/compose-source-maps.js");
                List<Object> composeSourceMapsCommand = this.getComposeSourceMapsCommand$react_native_gradle_plugin(composeScriptFile, packagerSourceMap, compilerSourceMap, outputSourceMap);
                this.runCommand(composeSourceMapsCommand);
            }
        }
    }

    @NotNull
    public final File resolvePackagerSourceMapFile$react_native_gradle_plugin(@NotNull String bundleAssetName) {
        Intrinsics.checkNotNullParameter((Object)bundleAssetName, (String)"bundleAssetName");
        return (Boolean)this.getHermesEnabled().get() != false ? new File(((RegularFile)this.getJsIntermediateSourceMapsDir().get()).getAsFile(), bundleAssetName + ".packager.map") : this.resolveOutputSourceMap$react_native_gradle_plugin(bundleAssetName);
    }

    @NotNull
    public final File resolveOutputSourceMap$react_native_gradle_plugin(@NotNull String bundleAssetName) {
        Intrinsics.checkNotNullParameter((Object)bundleAssetName, (String)"bundleAssetName");
        return new File(((Directory)this.getJsSourceMapsDir().get()).getAsFile(), bundleAssetName + ".map");
    }

    @NotNull
    public final File resolveCompilerSourceMap$react_native_gradle_plugin(@NotNull String bundleAssetName) {
        Intrinsics.checkNotNullParameter((Object)bundleAssetName, (String)"bundleAssetName");
        return new File(((RegularFile)this.getJsIntermediateSourceMapsDir().get()).getAsFile(), bundleAssetName + ".compiler.map");
    }

    private final void runCommand(List<? extends Object> command) {
        this.getExecOperations().exec(arg_0 -> BundleHermesCTask.runCommand$lambda$3(arg_0 -> BundleHermesCTask.runCommand$lambda$2(this, command, arg_0), arg_0));
    }

    @NotNull
    public final List<Object> getBundleCommand$react_native_gradle_plugin(@NotNull File bundleFile, @NotNull File sourceMapFile) {
        List list;
        Intrinsics.checkNotNullParameter((Object)bundleFile, (String)"bundleFile");
        Intrinsics.checkNotNullParameter((Object)sourceMapFile, (String)"sourceMapFile");
        File rootFile = ((Directory)this.getRoot().get()).getAsFile();
        List $this$getBundleCommand_u24lambda_u244 = list = (List)new ArrayList();
        boolean bl = false;
        Object object = this.getNodeExecutableAndArgs().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        $this$getBundleCommand_u24lambda_u244.addAll((Collection)object);
        File file = ((RegularFile)this.getCliFile().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAsFile(...)");
        Intrinsics.checkNotNull((Object)rootFile);
        $this$getBundleCommand_u24lambda_u244.add(Os.INSTANCE.cliPath(file, rootFile));
        Object object2 = this.getBundleCommand().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        $this$getBundleCommand_u24lambda_u244.add(object2);
        $this$getBundleCommand_u24lambda_u244.add("--platform");
        $this$getBundleCommand_u24lambda_u244.add("android");
        $this$getBundleCommand_u24lambda_u244.add("--dev");
        $this$getBundleCommand_u24lambda_u244.add(((Boolean)this.getDevEnabled().get()).toString());
        $this$getBundleCommand_u24lambda_u244.add("--reset-cache");
        $this$getBundleCommand_u24lambda_u244.add("--entry-file");
        File file2 = ((RegularFile)this.getEntryFile().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getAsFile(...)");
        $this$getBundleCommand_u24lambda_u244.add(Os.INSTANCE.cliPath(file2, rootFile));
        $this$getBundleCommand_u24lambda_u244.add("--bundle-output");
        $this$getBundleCommand_u24lambda_u244.add(Os.INSTANCE.cliPath(bundleFile, rootFile));
        $this$getBundleCommand_u24lambda_u244.add("--assets-dest");
        File file3 = ((Directory)this.getResourcesDir().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"getAsFile(...)");
        $this$getBundleCommand_u24lambda_u244.add(Os.INSTANCE.cliPath(file3, rootFile));
        $this$getBundleCommand_u24lambda_u244.add("--sourcemap-output");
        $this$getBundleCommand_u24lambda_u244.add(Os.INSTANCE.cliPath(sourceMapFile, rootFile));
        if (this.getBundleConfig().isPresent()) {
            $this$getBundleCommand_u24lambda_u244.add("--config");
            File file4 = ((RegularFile)this.getBundleConfig().get()).getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file4, (String)"getAsFile(...)");
            $this$getBundleCommand_u24lambda_u244.add(Os.INSTANCE.cliPath(file4, rootFile));
        }
        $this$getBundleCommand_u24lambda_u244.add("--minify");
        $this$getBundleCommand_u24lambda_u244.add(((Boolean)this.getMinifyEnabled().get()).toString());
        Object object3 = this.getExtraPackagerArgs().get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
        $this$getBundleCommand_u24lambda_u244.addAll((Collection)object3);
        $this$getBundleCommand_u24lambda_u244.add("--verbose");
        List commandLine = list;
        return TaskUtilsKt.windowsAwareCommandLine((List)commandLine);
    }

    @NotNull
    public final List<Object> getHermescCommand$react_native_gradle_plugin(@NotNull String hermesCommand, @NotNull File bytecodeFile, @NotNull File bundleFile) {
        Intrinsics.checkNotNullParameter((Object)hermesCommand, (String)"hermesCommand");
        Intrinsics.checkNotNullParameter((Object)bytecodeFile, (String)"bytecodeFile");
        Intrinsics.checkNotNullParameter((Object)bundleFile, (String)"bundleFile");
        File rootFile = ((Directory)this.getRoot().get()).getAsFile();
        SpreadBuilder spreadBuilder = new SpreadBuilder(8);
        spreadBuilder.add((Object)hermesCommand);
        spreadBuilder.add((Object)"-w");
        spreadBuilder.add((Object)"-emit-binary");
        spreadBuilder.add((Object)"-max-diagnostic-width=80");
        spreadBuilder.add((Object)"-out");
        Intrinsics.checkNotNull((Object)rootFile);
        spreadBuilder.add((Object)Os.INSTANCE.cliPath(bytecodeFile, rootFile));
        spreadBuilder.add((Object)Os.INSTANCE.cliPath(bundleFile, rootFile));
        Object object = this.getHermesFlags().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        Collection $this$toTypedArray$iv = (Collection)object;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        spreadBuilder.addSpread((Object)thisCollection$iv.toArray(new String[0]));
        return TaskUtilsKt.windowsAwareCommandLine((Object[])spreadBuilder.toArray(new Object[spreadBuilder.size()]));
    }

    @NotNull
    public final List<Object> getComposeSourceMapsCommand$react_native_gradle_plugin(@NotNull File composeScript, @NotNull File packagerSourceMap, @NotNull File compilerSourceMap, @NotNull File outputSourceMap) {
        Intrinsics.checkNotNullParameter((Object)composeScript, (String)"composeScript");
        Intrinsics.checkNotNullParameter((Object)packagerSourceMap, (String)"packagerSourceMap");
        Intrinsics.checkNotNullParameter((Object)compilerSourceMap, (String)"compilerSourceMap");
        Intrinsics.checkNotNullParameter((Object)outputSourceMap, (String)"outputSourceMap");
        File rootFile = ((Directory)this.getRoot().get()).getAsFile();
        SpreadBuilder spreadBuilder = new SpreadBuilder(6);
        Object object = this.getNodeExecutableAndArgs().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        Collection $this$toTypedArray$iv = (Collection)object;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        spreadBuilder.addSpread((Object)thisCollection$iv.toArray(new String[0]));
        Intrinsics.checkNotNull((Object)rootFile);
        spreadBuilder.add((Object)Os.INSTANCE.cliPath(composeScript, rootFile));
        spreadBuilder.add((Object)Os.INSTANCE.cliPath(packagerSourceMap, rootFile));
        spreadBuilder.add((Object)Os.INSTANCE.cliPath(compilerSourceMap, rootFile));
        spreadBuilder.add((Object)"-o");
        spreadBuilder.add((Object)Os.INSTANCE.cliPath(outputSourceMap, rootFile));
        return TaskUtilsKt.windowsAwareCommandLine((Object[])spreadBuilder.toArray(new Object[spreadBuilder.size()]));
    }

    private static final Unit sources$lambda$0(ConfigurableFileTree it) {
        String[] stringArray = new String[]{"**/*.js"};
        it.include(stringArray);
        stringArray = new String[]{"**/*.jsx"};
        it.include(stringArray);
        stringArray = new String[]{"**/*.ts"};
        it.include(stringArray);
        stringArray = new String[]{"**/*.tsx"};
        it.include(stringArray);
        stringArray = new String[]{"**/android/**/*"};
        it.exclude(stringArray);
        stringArray = new String[]{"**/ios/**/*"};
        it.exclude(stringArray);
        stringArray = new String[]{"**/build/**/*"};
        it.exclude(stringArray);
        stringArray = new String[]{"**/node_modules/**/*"};
        it.exclude(stringArray);
        return Unit.INSTANCE;
    }

    private static final void sources$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit runCommand$lambda$2(BundleHermesCTask this$0, List $command, ExecSpec exec) {
        exec.workingDir((Object)((Directory)this$0.getRoot().get()).getAsFile());
        exec.commandLine((Iterable)$command);
        return Unit.INSTANCE;
    }

    private static final void runCommand$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

