/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.tasks;

import com.facebook.react.model.ModelCodegenConfig;
import com.facebook.react.utils.JsonUtils;
import com.facebook.react.utils.Os;
import com.facebook.react.utils.TaskUtilsKt;
import java.io.File;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Exec;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010%\u001a\u00020&H\u0014J\u0019\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100(H\u0000\u00a2\u0006\u0002\b)J\u001d\u0010*\u001a\u00020&2\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b+R\u0014\u0010\u0004\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u000b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u00148gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0012R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0012R\u0019\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0019\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u001c8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u001fR\u0019\u0010#\u001a\b\u0012\u0004\u0012\u00020!0\u001c8G\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u001f\u00a8\u0006,"}, d2={"Lcom/facebook/react/tasks/GenerateCodegenArtifactsTask;", "Lorg/gradle/api/tasks/Exec;", "<init>", "()V", "reactNativeDir", "Lorg/gradle/api/file/DirectoryProperty;", "getReactNativeDir", "()Lorg/gradle/api/file/DirectoryProperty;", "generatedSrcDir", "getGeneratedSrcDir", "packageJsonFile", "Lorg/gradle/api/file/RegularFileProperty;", "getPackageJsonFile", "()Lorg/gradle/api/file/RegularFileProperty;", "nodeWorkingDir", "Lorg/gradle/api/provider/Property;", "", "getNodeWorkingDir", "()Lorg/gradle/api/provider/Property;", "nodeExecutableAndArgs", "Lorg/gradle/api/provider/ListProperty;", "getNodeExecutableAndArgs", "()Lorg/gradle/api/provider/ListProperty;", "codegenJavaPackageName", "getCodegenJavaPackageName", "libraryName", "getLibraryName", "generatedSchemaFile", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/RegularFile;", "getGeneratedSchemaFile", "()Lorg/gradle/api/provider/Provider;", "generatedJavaFiles", "Lorg/gradle/api/file/Directory;", "getGeneratedJavaFiles", "generatedJniFiles", "getGeneratedJniFiles", "exec", "", "resolveTaskParameters", "Lkotlin/Pair;", "resolveTaskParameters$react_native_gradle_plugin", "setupCommandLine", "setupCommandLine$react_native_gradle_plugin", "react-native-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nGenerateCodegenArtifactsTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GenerateCodegenArtifactsTask.kt\ncom/facebook/react/tasks/GenerateCodegenArtifactsTask\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,87:1\n37#2,2:88\n*S KotlinDebug\n*F\n+ 1 GenerateCodegenArtifactsTask.kt\ncom/facebook/react/tasks/GenerateCodegenArtifactsTask\n*L\n73#1:88,2\n*E\n"})
public abstract class GenerateCodegenArtifactsTask
extends Exec {
    @NotNull
    private final Provider<RegularFile> generatedSchemaFile;
    @NotNull
    private final Provider<Directory> generatedJavaFiles;
    @NotNull
    private final Provider<Directory> generatedJniFiles;

    public GenerateCodegenArtifactsTask() {
        Provider provider = this.getGeneratedSrcDir().file("schema.json");
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"file(...)");
        this.generatedSchemaFile = provider;
        Provider provider2 = this.getGeneratedSrcDir().dir("java");
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"dir(...)");
        this.generatedJavaFiles = provider2;
        Provider provider3 = this.getGeneratedSrcDir().dir("jni");
        Intrinsics.checkNotNullExpressionValue((Object)provider3, (String)"dir(...)");
        this.generatedJniFiles = provider3;
    }

    @Internal
    @NotNull
    public abstract DirectoryProperty getReactNativeDir();

    @Internal
    @NotNull
    public abstract DirectoryProperty getGeneratedSrcDir();

    @InputFile
    @NotNull
    public abstract RegularFileProperty getPackageJsonFile();

    @Input
    @NotNull
    public abstract Property<String> getNodeWorkingDir();

    @Input
    @NotNull
    public abstract ListProperty<String> getNodeExecutableAndArgs();

    @Input
    @NotNull
    public abstract Property<String> getCodegenJavaPackageName();

    @Input
    @NotNull
    public abstract Property<String> getLibraryName();

    @InputFile
    @NotNull
    public final Provider<RegularFile> getGeneratedSchemaFile() {
        return this.generatedSchemaFile;
    }

    @OutputDirectory
    @NotNull
    public final Provider<Directory> getGeneratedJavaFiles() {
        return this.generatedJavaFiles;
    }

    @OutputDirectory
    @NotNull
    public final Provider<Directory> getGeneratedJniFiles() {
        return this.generatedJniFiles;
    }

    protected void exec() {
        Pair<String, String> pair = this.resolveTaskParameters$react_native_gradle_plugin();
        String resolvedLibraryName = (String)pair.component1();
        String resolvedCodegenJavaPackageName = (String)pair.component2();
        this.setupCommandLine$react_native_gradle_plugin(resolvedLibraryName, resolvedCodegenJavaPackageName);
        super.exec();
    }

    @NotNull
    public final Pair<String, String> resolveTaskParameters$react_native_gradle_plugin() {
        Object object;
        Object resolvedLibraryName;
        ModelCodegenConfig parsedPackageJson;
        Object object2;
        ModelCodegenConfig modelCodegenConfig;
        if (this.getPackageJsonFile().isPresent() && ((RegularFile)this.getPackageJsonFile().get()).getAsFile().exists()) {
            File file = ((RegularFile)this.getPackageJsonFile().get()).getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAsFile(...)");
            modelCodegenConfig = JsonUtils.INSTANCE.fromPackageJson(file);
        } else {
            modelCodegenConfig = null;
        }
        if ((object2 = (parsedPackageJson = modelCodegenConfig)) == null || (object2 = object2.getCodegenConfig()) == null || (object2 = object2.getName()) == null) {
            object2 = resolvedLibraryName = (String)this.getLibraryName().get();
        }
        if ((object = parsedPackageJson) == null || (object = object.getCodegenConfig()) == null || (object = object.getAndroid()) == null || (object = object.getJavaPackageName()) == null) {
            object = (String)this.getCodegenJavaPackageName().get();
        }
        Object resolvedCodegenJavaPackageName = object;
        return TuplesKt.to((Object)resolvedLibraryName, (Object)resolvedCodegenJavaPackageName);
    }

    public final void setupCommandLine$react_native_gradle_plugin(@NotNull String libraryName, @NotNull String codegenJavaPackageName) {
        Intrinsics.checkNotNullParameter((Object)libraryName, (String)"libraryName");
        Intrinsics.checkNotNullParameter((Object)codegenJavaPackageName, (String)"codegenJavaPackageName");
        File workingDir = new File((String)this.getNodeWorkingDir().get());
        SpreadBuilder spreadBuilder = new SpreadBuilder(12);
        Object object = this.getNodeExecutableAndArgs().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        Collection $this$toTypedArray$iv = (Collection)object;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        spreadBuilder.addSpread((Object)thisCollection$iv.toArray(new String[0]));
        File file = ((RegularFile)this.getReactNativeDir().file("scripts/generate-specs-cli.js").get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAsFile(...)");
        spreadBuilder.add((Object)Os.INSTANCE.cliPath(file, workingDir));
        spreadBuilder.add((Object)"--platform");
        spreadBuilder.add((Object)"android");
        spreadBuilder.add((Object)"--schemaPath");
        File file2 = ((RegularFile)this.generatedSchemaFile.get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getAsFile(...)");
        spreadBuilder.add((Object)Os.INSTANCE.cliPath(file2, workingDir));
        spreadBuilder.add((Object)"--outputDir");
        File file3 = ((Directory)this.getGeneratedSrcDir().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"getAsFile(...)");
        spreadBuilder.add((Object)Os.INSTANCE.cliPath(file3, workingDir));
        spreadBuilder.add((Object)"--libraryName");
        spreadBuilder.add((Object)libraryName);
        spreadBuilder.add((Object)"--javaPackageName");
        spreadBuilder.add((Object)codegenJavaPackageName);
        this.commandLine(TaskUtilsKt.windowsAwareCommandLine((Object[])spreadBuilder.toArray(new Object[spreadBuilder.size()])));
    }
}

