/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.tasks;

import com.facebook.react.model.ModelAutolinkingConfigJson;
import com.facebook.react.utils.JsonUtils;
import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b&\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\f\u001a\u00020\rH\u0007J\u0015\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0011R\u0014\u0010\u0004\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lcom/facebook/react/tasks/GenerateEntryPointTask;", "Lorg/gradle/api/DefaultTask;", "<init>", "()V", "autolinkInputFile", "Lorg/gradle/api/file/RegularFileProperty;", "getAutolinkInputFile", "()Lorg/gradle/api/file/RegularFileProperty;", "generatedOutputDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "getGeneratedOutputDirectory", "()Lorg/gradle/api/file/DirectoryProperty;", "taskAction", "", "composeFileContent", "", "packageName", "composeFileContent$react_native_gradle_plugin", "Companion", "react-native-gradle-plugin"})
public abstract class GenerateEntryPointTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String GENERATED_FILENAME = "com/facebook/react/ReactNativeApplicationEntryPoint.java";
    @NotNull
    private static final String generatedFileContentsTemplate = "package com.facebook.react;\n\nimport android.app.Application;\nimport android.content.Context;\nimport android.content.res.Resources;\n\nimport com.facebook.react.defaults.DefaultNewArchitectureEntryPoint;\nimport com.facebook.react.common.annotations.internal.LegacyArchitectureLogger;\nimport com.facebook.react.views.view.WindowUtilKt;\nimport com.facebook.react.soloader.OpenSourceMergedSoMapping;\nimport com.facebook.soloader.SoLoader;\n\nimport java.io.IOException;\n\n/**\n  * This class is the entry point for loading React Native using the configuration\n  * that the users specifies in their .gradle files.\n  *\n  * The `loadReactNative(this)` method invocation should be called inside the\n  * application onCreate otherwise the app won't load correctly.            \n  */\npublic class ReactNativeApplicationEntryPoint {\n  public static void loadReactNative(Context context) {\n    try {\n       SoLoader.init(context, OpenSourceMergedSoMapping.INSTANCE);\n    } catch (IOException error) {\n      throw new RuntimeException(error);\n    }\n    \n    if ({{packageName}}.BuildConfig.IS_NEW_ARCHITECTURE_ENABLED) {\n      DefaultNewArchitectureEntryPoint.load();\n    }\n    \n    if ({{packageName}}.BuildConfig.IS_EDGE_TO_EDGE_ENABLED) {\n      WindowUtilKt.setEdgeToEdgeFeatureFlagOn();\n    }\n  }\n}";

    public GenerateEntryPointTask() {
        this.setGroup("react");
    }

    @InputFile
    @NotNull
    public abstract RegularFileProperty getAutolinkInputFile();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getGeneratedOutputDirectory();

    @TaskAction
    public final void taskAction() {
        File file;
        File file2 = ((RegularFile)this.getAutolinkInputFile().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getAsFile(...)");
        ModelAutolinkingConfigJson modelAutolinkingConfigJson = JsonUtils.INSTANCE.fromAutolinkingConfigJson(file2);
        if (modelAutolinkingConfigJson == null) {
            throw new IllegalStateException(StringsKt.trimIndent((String)("\n        RNGP - Autolinking: Could not parse autolinking config file:\n        " + ((RegularFile)this.getAutolinkInputFile().get()).getAsFile().getAbsolutePath() + "\n        \n        The file is either missing or not containing valid JSON so the build won't succeed. \n      ")).toString());
        }
        ModelAutolinkingConfigJson model = modelAutolinkingConfigJson;
        Object object = model.getProject();
        if (object == null || (object = object.getAndroid()) == null || (object = object.getPackageName()) == null) {
            throw new IllegalStateException("RNGP - Autolinking: Could not find project.android.packageName in react-native config output! Could not autolink packages without this field.".toString());
        }
        Object packageName = object;
        String generatedFileContents = this.composeFileContent$react_native_gradle_plugin((String)packageName);
        File outputDir = ((Directory)this.getGeneratedOutputDirectory().get()).getAsFile();
        outputDir.mkdirs();
        File $this$taskAction_u24lambda_u240 = file = new File(outputDir, GENERATED_FILENAME);
        boolean bl = false;
        $this$taskAction_u24lambda_u240.getParentFile().mkdirs();
        FilesKt.writeText$default((File)$this$taskAction_u24lambda_u240, (String)generatedFileContents, null, (int)2, null);
    }

    @NotNull
    public final String composeFileContent$react_native_gradle_plugin(@NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        return StringsKt.replace$default((String)generatedFileContentsTemplate, (String)"{{packageName}}", (String)packageName, (boolean)false, (int)4, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/facebook/react/tasks/GenerateEntryPointTask$Companion;", "", "<init>", "()V", "GENERATED_FILENAME", "", "generatedFileContentsTemplate", "getGeneratedFileContentsTemplate", "()Ljava/lang/String;", "react-native-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getGeneratedFileContentsTemplate() {
            return generatedFileContentsTemplate;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

