/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.utils;

import java.io.File;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\b\u0010\u0005\u001a\u00020\u0001H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"DEFAULT_DEV_SERVER_PORT", "", "getPackageNameFromManifest", "manifest", "Ljava/io/File;", "getHostIpAddress", "react-native-gradle-plugin"})
public final class AgpConfiguratorUtilsKt {
    @NotNull
    public static final String DEFAULT_DEV_SERVER_PORT = "8081";

    @Nullable
    public static final String getPackageNameFromManifest(@NotNull File manifest) {
        Intrinsics.checkNotNullParameter((Object)manifest, (String)"manifest");
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        Intrinsics.checkNotNullExpressionValue((Object)documentBuilderFactory, (String)"newInstance(...)");
        DocumentBuilderFactory factory = documentBuilderFactory;
        DocumentBuilder documentBuilder = factory.newDocumentBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)documentBuilder, (String)"newDocumentBuilder(...)");
        DocumentBuilder builder = documentBuilder;
        try {
            Element manifestElement;
            Document xmlDocument = builder.parse(manifest);
            Node node = xmlDocument.getElementsByTagName("manifest").item(0);
            Element element = manifestElement = node instanceof Element ? (Element)node : null;
            String packageName = element != null ? element.getAttribute("package") : null;
            CharSequence charSequence = packageName;
            return charSequence == null || charSequence.length() == 0 ? null : packageName;
        }
        catch (Exception e) {
            return null;
        }
    }

    @NotNull
    public static final String getHostIpAddress() {
        Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"getNetworkInterfaces(...)");
        String string = (String)SequencesKt.firstOrNull((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.flatMap((Sequence)SequencesKt.filter((Sequence)SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration)), AgpConfiguratorUtilsKt::getHostIpAddress$lambda$0), AgpConfiguratorUtilsKt::getHostIpAddress$lambda$1), AgpConfiguratorUtilsKt::getHostIpAddress$lambda$2), AgpConfiguratorUtilsKt::getHostIpAddress$lambda$3));
        if (string == null) {
            string = "localhost";
        }
        return string;
    }

    private static final boolean getHostIpAddress$lambda$0(NetworkInterface it) {
        return it.isUp() && !it.isLoopback();
    }

    private static final Sequence getHostIpAddress$lambda$1(NetworkInterface it) {
        Enumeration<InetAddress> enumeration = it.getInetAddresses();
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"getInetAddresses(...)");
        return SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration));
    }

    private static final boolean getHostIpAddress$lambda$2(InetAddress it) {
        return it instanceof Inet4Address && !((Inet4Address)it).isLoopbackAddress();
    }

    private static final String getHostIpAddress$lambda$3(InetAddress it) {
        return it.getHostAddress();
    }
}

