/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.utils;

import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/facebook/react/utils/BackwardCompatUtils;", "", "<init>", "()V", "hasShownJSCRemovalMessage", "", "configureBackwardCompatibilityReactMap", "", "project", "Lorg/gradle/api/Project;", "showJSCRemovalMessage", "react-native-gradle-plugin"})
public final class BackwardCompatUtils {
    @NotNull
    public static final BackwardCompatUtils INSTANCE = new BackwardCompatUtils();
    private static boolean hasShownJSCRemovalMessage;

    private BackwardCompatUtils() {
    }

    public final void configureBackwardCompatibilityReactMap(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (project.getExtensions().getExtraProperties().has("react")) {
            Map reactMap;
            Object object = project.getExtensions().getExtraProperties().get("react");
            Map map = object instanceof Map ? (Map)object : null;
            if (map == null) {
                map = MapsKt.emptyMap();
            }
            if (!(reactMap = map).isEmpty()) {
                project.getLogger().error("********************************************************************************\n\nERROR: Using old project.ext.react configuration.\nWe identified that your project is using a old configuration block as:\n\nproject.ext.react = [\n    // ...\n]\n\nYou should migrate to the new configuration:\n\nreact {\n    // ...\n}\nYou can find documentation inside `android/app/build.gradle` on how to use it.\n\n********************************************************************************");
            }
        }
        project.getExtensions().getExtraProperties().set("react", (Object)MapsKt.emptyMap());
    }

    public final void showJSCRemovalMessage(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (hasShownJSCRemovalMessage) {
            return;
        }
        String message = "\n=============== JavaScriptCore is being moved ===============\nJavaScriptCore has been extracted from react-native core\nand will be removed in a future release. It can now be\ninstalled from `@react-native-community/javascriptcore`\nSee: https://github.com/react-native-community/javascriptcore\n=============================================================\n";
        project.getLogger().warn(message);
        hasShownJSCRemovalMessage = true;
    }
}

