/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.utils;

import com.android.build.api.dsl.ApplicationBuildFeatures;
import com.android.build.api.dsl.ApplicationDefaultConfig;
import com.android.build.api.dsl.ApplicationExtension;
import com.android.build.api.variant.ApplicationAndroidComponentsExtension;
import com.android.build.api.variant.Variant;
import com.facebook.react.ReactExtension;
import com.facebook.react.utils.ProjectUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.plugins.AppliedPlugin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u001e\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fJ&\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010J.\u0010\u0012\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\u00132\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010\u00a8\u0006\u0016"}, d2={"Lcom/facebook/react/utils/NdkConfiguratorUtils;", "", "<init>", "()V", "configureReactNativeNdk", "", "project", "Lorg/gradle/api/Project;", "extension", "Lcom/facebook/react/ReactExtension;", "configureNewArchPackagingOptions", "variant", "Lcom/android/build/api/variant/Variant;", "configureJsEnginePackagingOptions", "config", "hermesEnabled", "", "useThirdPartyJSC", "getPackagingOptionsForVariant", "Lkotlin/Pair;", "", "", "react-native-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nNdkConfiguratorUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NdkConfiguratorUtils.kt\ncom/facebook/react/utils/NdkConfiguratorUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,154:1\n2632#2,3:155\n2632#2,3:158\n2632#2,3:161\n2632#2,3:164\n2632#2,3:167\n*S KotlinDebug\n*F\n+ 1 NdkConfiguratorUtils.kt\ncom/facebook/react/utils/NdkConfiguratorUtils\n*L\n44#1:155,3\n47#1:158,3\n50#1:161,3\n54#1:164,3\n57#1:167,3\n*E\n"})
public final class NdkConfiguratorUtils {
    @NotNull
    public static final NdkConfiguratorUtils INSTANCE = new NdkConfiguratorUtils();

    private NdkConfiguratorUtils() {
    }

    public final void configureReactNativeNdk(@NotNull Project project, @NotNull ReactExtension extension) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        project.getPluginManager().withPlugin("com.android.application", arg_0 -> NdkConfiguratorUtils.configureReactNativeNdk$lambda$7(arg_0 -> NdkConfiguratorUtils.configureReactNativeNdk$lambda$6(project, extension, arg_0), arg_0));
    }

    public final void configureNewArchPackagingOptions(@NotNull Project project, @NotNull ReactExtension extension, @NotNull Variant variant) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        if (!ProjectUtils.INSTANCE.isNewArchEnabled$react_native_gradle_plugin(project, extension)) {
            Object[] objectArray = new String[]{"**/libfbjni.so", "**/libc++_shared.so"};
            variant.getPackaging().getJniLibs().getPickFirsts().addAll((Iterable)CollectionsKt.listOf((Object[])objectArray));
        } else {
            Object[] objectArray = new String[]{"**/libfbjni.so", "**/libreactnative.so", "**/libjsi.so", "**/libc++_shared.so"};
            variant.getPackaging().getJniLibs().getPickFirsts().addAll((Iterable)CollectionsKt.listOf((Object[])objectArray));
        }
    }

    public final void configureJsEnginePackagingOptions(@NotNull ReactExtension config, @NotNull Variant variant, boolean hermesEnabled, boolean useThirdPartyJSC) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        if (((Boolean)config.getEnableSoCleanup().get()).booleanValue()) {
            Pair<List<String>, List<String>> pair = this.getPackagingOptionsForVariant(hermesEnabled, useThirdPartyJSC);
            List excludes = (List)pair.component1();
            List includes = (List)pair.component2();
            variant.getPackaging().getJniLibs().getExcludes().addAll((Iterable)excludes);
            variant.getPackaging().getJniLibs().getPickFirsts().addAll((Iterable)includes);
        }
    }

    @NotNull
    public final Pair<List<String>, List<String>> getPackagingOptionsForVariant(boolean hermesEnabled, boolean useThirdPartyJSC) {
        boolean bl;
        List excludes = new ArrayList();
        List includes = new ArrayList();
        if (hermesEnabled) {
            excludes.add("**/libjsc.so");
            excludes.add("**/libjsctooling.so");
            includes.add("**/libhermes.so");
            bl = includes.add("**/libhermestooling.so");
        } else if (useThirdPartyJSC) {
            excludes.add("**/libhermes.so");
            excludes.add("**/libhermestooling.so");
            excludes.add("**/libjsctooling.so");
            bl = includes.add("**/libjsc.so");
        } else {
            excludes.add("**/libhermes.so");
            excludes.add("**/libhermestooling.so");
            includes.add("**/libjsc.so");
            bl = includes.add("**/libjsctooling.so");
        }
        return TuplesKt.to((Object)excludes, (Object)includes);
    }

    private static final Unit configureReactNativeNdk$lambda$6$lambda$5(Project $project, ReactExtension $extension, ApplicationExtension ext) {
        List<String> architectures;
        boolean bl;
        List cmakeArgs;
        block27: {
            boolean bl2;
            String it;
            boolean $i$f$none;
            Iterable $this$none$iv;
            block26: {
                boolean bl3;
                block25: {
                    boolean bl4;
                    block24: {
                        boolean bl5;
                        block23: {
                            Intrinsics.checkNotNullParameter((Object)ext, (String)"ext");
                            if (!ProjectUtils.INSTANCE.isNewArchEnabled$react_native_gradle_plugin($project, $extension)) {
                                return Unit.INSTANCE;
                            }
                            ((ApplicationBuildFeatures)ext.getBuildFeatures()).setPrefab(Boolean.valueOf(true));
                            if (ext.getExternalNativeBuild().getCmake().getPath() == null) {
                                ext.getExternalNativeBuild().getCmake().setPath(new File(((Directory)$extension.getReactNativeDir().get()).getAsFile(), "ReactAndroid/cmake-utils/default-app-setup/CMakeLists.txt"));
                            }
                            cmakeArgs = ((ApplicationDefaultConfig)ext.getDefaultConfig()).getExternalNativeBuild().getCmake().getArguments();
                            $this$none$iv = cmakeArgs;
                            $i$f$none = false;
                            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                                bl5 = true;
                            } else {
                                for (Object element$iv : $this$none$iv) {
                                    it = (String)element$iv;
                                    boolean bl6 = false;
                                    if (!StringsKt.startsWith$default((String)it, (String)"-DPROJECT_BUILD_DIR", (boolean)false, (int)2, null)) continue;
                                    bl5 = false;
                                    break block23;
                                }
                                bl5 = true;
                            }
                        }
                        if (bl5) {
                            cmakeArgs.add("-DPROJECT_BUILD_DIR=" + ((Directory)$project.getLayout().getBuildDirectory().get()).getAsFile());
                        }
                        $this$none$iv = cmakeArgs;
                        $i$f$none = false;
                        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                            bl4 = true;
                        } else {
                            for (Object element$iv : $this$none$iv) {
                                it = (String)element$iv;
                                boolean bl7 = false;
                                if (!StringsKt.startsWith$default((String)it, (String)"-DPROJECT_ROOT_DIR", (boolean)false, (int)2, null)) continue;
                                bl4 = false;
                                break block24;
                            }
                            bl4 = true;
                        }
                    }
                    if (bl4) {
                        cmakeArgs.add("-DPROJECT_ROOT_DIR=" + $project.getRootProject().getLayout().getProjectDirectory().getAsFile());
                    }
                    $this$none$iv = cmakeArgs;
                    $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl3 = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            it = (String)element$iv;
                            boolean bl8 = false;
                            if (!StringsKt.startsWith$default((String)it, (String)"-DREACT_ANDROID_DIR", (boolean)false, (int)2, null)) continue;
                            bl3 = false;
                            break block25;
                        }
                        bl3 = true;
                    }
                }
                if (bl3) {
                    cmakeArgs.add("-DREACT_ANDROID_DIR=" + ((RegularFile)$extension.getReactNativeDir().file("ReactAndroid").get()).getAsFile());
                }
                $this$none$iv = cmakeArgs;
                $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        it = (String)element$iv;
                        boolean bl9 = false;
                        if (!StringsKt.startsWith$default((String)it, (String)"-DANDROID_STL", (boolean)false, (int)2, null)) continue;
                        bl2 = false;
                        break block26;
                    }
                    bl2 = true;
                }
            }
            if (bl2) {
                cmakeArgs.add("-DANDROID_STL=c++_shared");
            }
            $this$none$iv = cmakeArgs;
            $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    it = (String)element$iv;
                    boolean bl10 = false;
                    if (!StringsKt.startsWith$default((String)it, (String)"-DANDROID_SUPPORT_FLEXIBLE_PAGE_SIZES", (boolean)false, (int)2, null)) continue;
                    bl = false;
                    break block27;
                }
                bl = true;
            }
        }
        if (bl) {
            cmakeArgs.add("-DANDROID_SUPPORT_FLEXIBLE_PAGE_SIZES=ON");
        }
        if (!((Collection)(architectures = ProjectUtils.INSTANCE.getReactNativeArchitectures$react_native_gradle_plugin($project))).isEmpty() && !ext.getSplits().getAbi().isEnable()) {
            ((ApplicationDefaultConfig)ext.getDefaultConfig()).getNdk().getAbiFilters().addAll((Collection)architectures);
        }
        return Unit.INSTANCE;
    }

    private static final Unit configureReactNativeNdk$lambda$6(Project $project, ReactExtension $extension, AppliedPlugin it) {
        ((ApplicationAndroidComponentsExtension)$project.getExtensions().getByType(ApplicationAndroidComponentsExtension.class)).finalizeDsl(arg_0 -> NdkConfiguratorUtils.configureReactNativeNdk$lambda$6$lambda$5($project, $extension, arg_0));
        return Unit.INSTANCE;
    }

    private static final void configureReactNativeNdk$lambda$7(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

