/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.utils;

import com.facebook.react.utils.KotlinStdlibCompatUtils;
import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u0006\u0010\u0006\u001a\u00020\u0005J\u0006\u0010\u0007\u001a\u00020\u0005J\n\u0010\b\u001a\u00020\t*\u00020\tJ\u0012\u0010\n\u001a\u00020\t*\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b\u00a8\u0006\r"}, d2={"Lcom/facebook/react/utils/Os;", "", "<init>", "()V", "isWindows", "", "isMac", "isLinuxAmd64", "unixifyPath", "", "cliPath", "Ljava/io/File;", "base", "shared"})
public final class Os {
    @NotNull
    public static final Os INSTANCE = new Os();

    private Os() {
    }

    public final boolean isWindows() {
        String string = System.getProperty("os.name");
        return string != null && (string = KotlinStdlibCompatUtils.INSTANCE.lowercaseCompat(string)) != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"windows", (boolean)false, (int)2, null) : false;
    }

    public final boolean isMac() {
        String string = System.getProperty("os.name");
        return string != null && (string = KotlinStdlibCompatUtils.INSTANCE.lowercaseCompat(string)) != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"mac", (boolean)false, (int)2, null) : false;
    }

    public final boolean isLinuxAmd64() {
        String string = System.getProperty("os.name");
        boolean osNameMatch = string != null && (string = KotlinStdlibCompatUtils.INSTANCE.lowercaseCompat(string)) != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"linux", (boolean)false, (int)2, null) : false;
        String string2 = System.getProperty("os.arch");
        boolean archMatch = string2 != null && (string2 = KotlinStdlibCompatUtils.INSTANCE.lowercaseCompat(string2)) != null ? StringsKt.contains$default((CharSequence)string2, (CharSequence)"amd64", (boolean)false, (int)2, null) : false;
        return osNameMatch && archMatch;
    }

    @NotNull
    public final String unixifyPath(@NotNull String $this$unixifyPath) {
        Intrinsics.checkNotNullParameter((Object)$this$unixifyPath, (String)"<this>");
        String it = StringsKt.replace$default((String)StringsKt.replace$default((String)$this$unixifyPath, (char)'\\', (char)'/', (boolean)false, (int)4, null), (String)":", (String)"", (boolean)false, (int)4, null);
        boolean bl = false;
        return !StringsKt.startsWith$default((String)it, (String)"/", (boolean)false, (int)2, null) ? "/" + it : it;
    }

    @NotNull
    public final String cliPath(@NotNull File $this$cliPath, @NotNull File base) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$cliPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        if (this.isWindows()) {
            String string2 = FilesKt.relativeTo((File)$this$cliPath, (File)base).getPath();
            Intrinsics.checkNotNull((Object)string2);
            string = string2;
        } else {
            String string3 = $this$cliPath.getAbsolutePath();
            Intrinsics.checkNotNull((Object)string3);
            string = string3;
        }
        return string;
    }
}

