/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.devsupport;

import android.content.Context;
import android.net.Uri;
import androidx.compose.runtime.internal.StabilityInferred;
import com.facebook.react.devsupport.DevServerHelper;
import com.facebook.react.devsupport.interfaces.PackagerStatusCallback;
import com.facebook.react.modules.debug.interfaces.DeveloperSettings;
import com.facebook.react.packagerconnection.PackagerConnectionSettings;
import expo.modules.devlauncher.launcher.DevLauncherControllerInterface;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0016J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0016J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0013H\u0016J\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0013H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lcom/facebook/react/devsupport/DevLauncherDevServerHelper;", "Lcom/facebook/react/devsupport/DevServerHelper;", "context", "Landroid/content/Context;", "controller", "Lexpo/modules/devlauncher/launcher/DevLauncherControllerInterface;", "devSettings", "Lcom/facebook/react/modules/debug/interfaces/DeveloperSettings;", "packagerConnection", "Lcom/facebook/react/packagerconnection/PackagerConnectionSettings;", "<init>", "(Landroid/content/Context;Lexpo/modules/devlauncher/launcher/DevLauncherControllerInterface;Lcom/facebook/react/modules/debug/interfaces/DeveloperSettings;Lcom/facebook/react/packagerconnection/PackagerConnectionSettings;)V", "httpClient", "Lokhttp3/OkHttpClient;", "getHttpClient", "()Lokhttp3/OkHttpClient;", "httpClient$delegate", "Lkotlin/Lazy;", "getDevServerBundleURL", "", "jsModulePath", "getDevServerSplitBundleURL", "getSourceUrl", "mainModuleName", "getSourceMapUrl", "isPackagerRunning", "", "callback", "Lcom/facebook/react/devsupport/interfaces/PackagerStatusCallback;", "expo-dev-launcher_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nDevLauncherDevServerHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DevLauncherDevServerHelper.kt\ncom/facebook/react/devsupport/DevLauncherDevServerHelper\n+ 2 Uri.kt\nandroidx/core/net/UriKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,101:1\n29#2:102\n29#2:116\n1617#3,9:103\n1869#3:112\n1870#3:114\n1626#3:115\n1#4:113\n*S KotlinDebug\n*F\n+ 1 DevLauncherDevServerHelper.kt\ncom/facebook/react/devsupport/DevLauncherDevServerHelper\n*L\n53#1:102\n76#1:116\n54#1:103,9\n54#1:112\n54#1:114\n54#1:115\n54#1:113\n*E\n"})
public final class DevLauncherDevServerHelper
extends DevServerHelper {
    @Nullable
    private final DevLauncherControllerInterface controller;
    @NotNull
    private final Lazy httpClient$delegate;
    public static final int $stable = 8;

    public DevLauncherDevServerHelper(@NotNull Context context, @Nullable DevLauncherControllerInterface controller, @NotNull DeveloperSettings devSettings, @NotNull PackagerConnectionSettings packagerConnection) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)devSettings, (String)"devSettings");
        Intrinsics.checkNotNullParameter((Object)packagerConnection, (String)"packagerConnection");
        super(devSettings, context, packagerConnection);
        this.controller = controller;
        this.httpClient$delegate = LazyKt.lazy(DevLauncherDevServerHelper::httpClient_delegate$lambda$0);
    }

    private final OkHttpClient getHttpClient() {
        Lazy lazy = this.httpClient$delegate;
        return (OkHttpClient)lazy.getValue();
    }

    @NotNull
    public String getDevServerBundleURL(@NotNull String jsModulePath) {
        Intrinsics.checkNotNullParameter((Object)jsModulePath, (String)"jsModulePath");
        Object object = this.controller;
        if (object == null || (object = object.getManifest()) == null || (object = object.getBundleURL()) == null) {
            object = super.getDevServerBundleURL(jsModulePath);
        }
        return object;
    }

    @NotNull
    public String getDevServerSplitBundleURL(@NotNull String jsModulePath) {
        Intrinsics.checkNotNullParameter((Object)jsModulePath, (String)"jsModulePath");
        Object object = this.controller;
        if (object == null || (object = object.getManifest()) == null || (object = object.getBundleURL()) == null) {
            object = super.getDevServerSplitBundleURL(jsModulePath);
        }
        return object;
    }

    @NotNull
    public String getSourceUrl(@NotNull String mainModuleName) {
        Intrinsics.checkNotNullParameter((Object)mainModuleName, (String)"mainModuleName");
        Object object = this.controller;
        if (object == null || (object = object.getManifest()) == null || (object = object.getBundleURL()) == null) {
            object = super.getSourceUrl(mainModuleName);
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String getSourceMapUrl(@NotNull String mainModuleName) {
        void $this$mapNotNullTo$iv$iv;
        Object bundleURL;
        Intrinsics.checkNotNullParameter((Object)mainModuleName, (String)"mainModuleName");
        String defaultValue = super.getSourceMapUrl(mainModuleName);
        Object object = this.controller;
        if (object == null || (object = object.getManifest()) == null || (object = object.getBundleURL()) == null) {
            return defaultValue;
        }
        Object $this$toUri$iv = bundleURL = object;
        boolean $i$f$toUri = false;
        Uri parsedURL = Uri.parse((String)$this$toUri$iv);
        Set set = parsedURL.getQueryParameterNames();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getQueryParameterNames(...)");
        Iterable $this$mapNotNull$iv = set;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String key = (String)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)key);
            if (StringsKt.startsWith$default((String)key, (String)"transform", (boolean)false, (int)2, null)) {
                String string = parsedURL.getQueryParameter(key);
                if (string == null) {
                    String string2 = "Required value was null.";
                    throw new IllegalArgumentException(string2.toString());
                }
                pair = TuplesKt.to((Object)key, (Object)string);
            } else {
                pair = null;
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        if ($this$mapNotNull$iv.isEmpty()) {
            boolean bl = false;
            return defaultValue;
        }
        List customOptions = (List)$this$mapNotNull$iv;
        String customOptionsString = CollectionsKt.joinToString$default((Iterable)customOptions, (CharSequence)"&", null, null, (int)0, null, DevLauncherDevServerHelper::getSourceMapUrl$lambda$3, (int)30, null);
        return defaultValue + "&" + customOptionsString;
    }

    public void isPackagerRunning(@NotNull PackagerStatusCallback callback) {
        Object bundleURL;
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        Object object = this.controller;
        if (object == null || (object = object.getManifest()) == null || (object = object.getBundleURL()) == null) {
            super.isPackagerRunning(callback);
            return;
        }
        Object $this$toUri$iv = bundleURL = object;
        boolean $i$f$toUri = false;
        Uri bundleUri = Uri.parse((String)$this$toUri$iv);
        String string = bundleUri.buildUpon().path("status").clearQuery().build().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String statusUrl = string;
        Request request = new Request.Builder().url(statusUrl).build();
        this.getHttpClient().newCall(request).enqueue(new Callback(callback){
            final /* synthetic */ PackagerStatusCallback $callback;
            {
                this.$callback = $callback;
            }

            public void onFailure(Call call, IOException e) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$callback.onPackagerStatusFetched(false);
            }

            public void onResponse(Call call, Response response) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                if (!response.isSuccessful()) {
                    this.$callback.onPackagerStatusFetched(false);
                    return;
                }
                Object object = response.body();
                if (object == null || (object = object.string()) == null) {
                    object = "";
                }
                Object body = object;
                this.$callback.onPackagerStatusFetched(Intrinsics.areEqual((Object)body, (Object)"packager-status:running"));
            }
        });
    }

    private static final OkHttpClient httpClient_delegate$lambda$0() {
        return new OkHttpClient.Builder().connectTimeout(5000L, TimeUnit.MILLISECONDS).readTimeout(0L, TimeUnit.MILLISECONDS).writeTimeout(0L, TimeUnit.MILLISECONDS).build();
    }

    private static final CharSequence getSourceMapUrl$lambda$3(Pair pair) {
        Intrinsics.checkNotNullParameter((Object)pair, (String)"<destruct>");
        String key = (String)pair.component1();
        String value = (String)pair.component2();
        return key + "=" + value;
    }
}

