/*
 * Decompiled with CFR 0.152.
 */
package expo.modules.devlauncher.helpers;

import android.net.Uri;
import androidx.compose.runtime.internal.StabilityInferred;
import expo.modules.devlauncher.helpers.DevLauncherURLHelperKt;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005R\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lexpo/modules/devlauncher/helpers/DevLauncherUrl;", "", "url", "Landroid/net/Uri;", "<init>", "(Landroid/net/Uri;)V", "getUrl", "()Landroid/net/Uri;", "setUrl", "queryParams", "", "", "getQueryParams", "()Ljava/util/Map;", "expo-dev-launcher_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nDevLauncherURLHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DevLauncherURLHelper.kt\nexpo/modules/devlauncher/helpers/DevLauncherUrl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,31:1\n1869#2,2:32\n*S KotlinDebug\n*F\n+ 1 DevLauncherURLHelper.kt\nexpo/modules/devlauncher/helpers/DevLauncherUrl\n*L\n17#1:32,2\n*E\n"})
public final class DevLauncherUrl {
    @NotNull
    private Uri url;
    @NotNull
    private final Map<String, String> queryParams;
    public static final int $stable = 8;

    public DevLauncherUrl(@NotNull Uri url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.url = url;
        this.queryParams = new LinkedHashMap();
        Set set = this.url.getQueryParameterNames();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getQueryParameterNames(...)");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String name = (String)element$iv;
            boolean bl = false;
            Map<String, String> map = this.queryParams;
            String string = this.url.getQueryParameter(name);
            if (string == null) {
                string = "";
            }
            String string2 = string;
            map.put(name, string2);
        }
        if (DevLauncherURLHelperKt.isDevLauncherUrl(this.url)) {
            if (this.queryParams.get("url") != null) {
                Uri queryUrl = Uri.parse((String)this.queryParams.get("url"));
                Intrinsics.checkNotNull((Object)queryUrl);
                this.url = DevLauncherURLHelperKt.replaceEXPScheme(queryUrl, "http");
            }
        } else {
            this.url = DevLauncherURLHelperKt.replaceEXPScheme(this.url, "http");
        }
    }

    @NotNull
    public final Uri getUrl() {
        return this.url;
    }

    public final void setUrl(@NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"<set-?>");
        this.url = uri;
    }

    @NotNull
    public final Map<String, String> getQueryParams() {
        return this.queryParams;
    }
}

