/*
 * Decompiled with CFR 0.152.
 */
package expo.modules.devlauncher.launcher.configurators;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.os.Build;
import android.util.Log;
import android.view.View;
import android.view.WindowInsets;
import androidx.annotation.UiThread;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.core.view.ViewCompat;
import com.facebook.react.ReactActivity;
import expo.modules.devlauncher.helpers.DevLauncherColorsHelperKt;
import expo.modules.manifests.core.Manifest;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\b\u0007\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\rJ\u001a\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0003J\u0018\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u000bH\u0003J\u0018\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u000bH\u0003J\u0018\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u000e\u0010\u001a\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lexpo/modules/devlauncher/launcher/configurators/DevLauncherExpoActivityConfigurator;", "", "manifest", "Lexpo/modules/manifests/core/Manifest;", "context", "Landroid/content/Context;", "<init>", "(Lexpo/modules/manifests/core/Manifest;Landroid/content/Context;)V", "applyTaskDescription", "", "activity", "Landroid/app/Activity;", "applyOrientation", "Lcom/facebook/react/ReactActivity;", "applyStatusBarConfiguration", "setStyle", "", "style", "setHidden", "hidden", "", "setTranslucent", "translucent", "setColor", "color", "", "applyNavigationBarConfiguration", "Companion", "expo-dev-launcher_release"})
@StabilityInferred(parameters=0)
public final class DevLauncherExpoActivityConfigurator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Manifest manifest;
    @NotNull
    private final Context context;
    public static final int $stable = 8;
    private static final String TAG = DevLauncherExpoActivityConfigurator.class.getSimpleName();

    public DevLauncherExpoActivityConfigurator(@NotNull Manifest manifest, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)manifest, (String)"manifest");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.manifest = manifest;
        this.context = context;
    }

    public final void applyTaskDescription(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        if (!DevLauncherColorsHelperKt.isValidColor(this.manifest.getPrimaryColor())) {
            return;
        }
        int color = Color.parseColor((String)this.manifest.getPrimaryColor());
        Bitmap icon = BitmapFactory.decodeResource((Resources)this.context.getResources(), (int)this.context.getApplicationInfo().icon);
        activity.setTaskDescription(new ActivityManager.TaskDescription(this.manifest.getName(), icon, color));
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void applyOrientation(@NotNull ReactActivity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        String string = this.manifest.getOrientation();
        if (string != null) {
            int n = -1;
            switch (string.hashCode()) {
                case 1544803905: {
                    if (!string.equals("default")) break;
                    n = 1;
                    break;
                }
                case 729267099: {
                    if (!string.equals("portrait")) break;
                    n = 2;
                    break;
                }
                case 1430647483: {
                    if (!string.equals("landscape")) break;
                    n = 3;
                    break;
                }
            }
            switch (n) {
                case 1: {
                    activity.setRequestedOrientation(-1);
                    return;
                }
                case 2: {
                    activity.setRequestedOrientation(1);
                    return;
                }
                case 3: {
                    activity.setRequestedOrientation(0);
                    return;
                }
            }
        }
        activity.setRequestedOrientation(-1);
    }

    public final void applyStatusBarConfiguration(@NotNull ReactActivity activity) {
        JSONObject statusBarOptions;
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        JSONObject jSONObject = statusBarOptions = this.manifest.getAndroidStatusBarOptions();
        String style = jSONObject != null ? jSONObject.optString("barStyle") : null;
        JSONObject jSONObject2 = statusBarOptions;
        String backgroundColor = jSONObject2 != null ? jSONObject2.optString("backgroundColor") : null;
        boolean translucent = statusBarOptions == null || statusBarOptions.optBoolean("translucent", true);
        boolean hidden = statusBarOptions != null && statusBarOptions.optBoolean("hidden", false);
        activity.runOnUiThread(() -> DevLauncherExpoActivityConfigurator.applyStatusBarConfiguration$lambda$0(activity, this, hidden, translucent, style, backgroundColor));
    }

    @UiThread
    private final String setStyle(String style, Activity activity) {
        String appliedStatusBarStyle = "light-content";
        View view = activity.getWindow().getDecorView();
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"getDecorView(...)");
        View decorView = view;
        int systemUiVisibilityFlags = decorView.getSystemUiVisibility();
        String string = style;
        if (Intrinsics.areEqual((Object)string, (Object)"light-content")) {
            systemUiVisibilityFlags &= 0xFFFFDFFF;
            appliedStatusBarStyle = "light-content";
        } else if (Intrinsics.areEqual((Object)string, (Object)"dark-content")) {
            systemUiVisibilityFlags |= 0x2000;
            appliedStatusBarStyle = "dark-content";
        } else {
            systemUiVisibilityFlags |= 0x2000;
            appliedStatusBarStyle = "dark-content";
        }
        decorView.setSystemUiVisibility(systemUiVisibilityFlags);
        return appliedStatusBarStyle;
    }

    @UiThread
    private final void setHidden(boolean hidden, Activity activity) {
        if (hidden) {
            activity.getWindow().addFlags(1024);
            activity.getWindow().clearFlags(2048);
        } else {
            activity.getWindow().addFlags(2048);
            activity.getWindow().clearFlags(1024);
        }
    }

    @UiThread
    private final void setTranslucent(boolean translucent, Activity activity) {
        View view = activity.getWindow().getDecorView();
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"getDecorView(...)");
        View decorView = view;
        if (translucent) {
            decorView.setOnApplyWindowInsetsListener(DevLauncherExpoActivityConfigurator::setTranslucent$lambda$1);
        } else {
            decorView.setOnApplyWindowInsetsListener(null);
        }
        ViewCompat.requestApplyInsets((View)decorView);
    }

    @UiThread
    public final void setColor(int color, @NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        activity.getWindow().addFlags(Integer.MIN_VALUE);
        activity.getWindow().setStatusBarColor(color);
    }

    /*
     * Unable to fully structure code
     */
    public final void applyNavigationBarConfiguration(@NotNull ReactActivity activity) {
        block14: {
            block17: {
                block15: {
                    block16: {
                        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                        v0 = this.manifest.getAndroidNavigationBarOptions();
                        if (v0 == null) {
                            return;
                        }
                        navBarOptions = v0;
                        navBarColor = navBarOptions.optString("backgroundColor");
                        if (DevLauncherColorsHelperKt.isValidColor(navBarColor)) {
                            try {
                                activity.getWindow().clearFlags(0x8000000);
                                activity.getWindow().setNavigationBarColor(Color.parseColor((String)navBarColor));
                            }
                            catch (Throwable e) {
                                Log.e((String)DevLauncherExpoActivityConfigurator.TAG, (String)"Failed to configure androidNavigationBar.backgroundColor", (Throwable)e);
                            }
                        }
                        if (!Intrinsics.areEqual((Object)(navBarAppearance = navBarOptions.optString("barStyle")), (Object)"") && Build.VERSION.SDK_INT >= 26) {
                            try {
                                activity.getWindow().clearFlags(0x8000000);
                                activity.getWindow().addFlags(-2147483648);
                                if (Intrinsics.areEqual((Object)navBarAppearance, (Object)"dark-content")) {
                                    v1 = activity.getWindow().getDecorView();
                                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getDecorView(...)");
                                    decorView = v1;
                                    flags = decorView.getSystemUiVisibility();
                                    decorView.setSystemUiVisibility(flags |= 16);
                                }
                            }
                            catch (Throwable e) {
                                Log.e((String)DevLauncherExpoActivityConfigurator.TAG, (String)"Failed to configure androidNavigationBar.barStyle", (Throwable)e);
                            }
                        }
                        if (Intrinsics.areEqual((Object)(navBarVisible = navBarOptions.optString("visible")), (Object)"")) break block14;
                        v2 = activity.getWindow().getDecorView();
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getDecorView(...)");
                        decorView = v2;
                        v3 = decorView.getSystemUiVisibility();
                        var8_10 = navBarVisible;
                        if (var8_10 == null) break block15;
                        switch (var8_10.hashCode()) {
                            case -1197068329: {
                                if (!var8_10.equals("sticky-immersive")) {
                                    ** break;
                                }
                                break block16;
                            }
                            case 1137617595: {
                                if (var8_10.equals("immersive")) break;
                                ** break;
                            }
                            case 1570144589: {
                                if (!var8_10.equals("leanback")) ** break;
                                v4 = 6;
                                break block17;
                            }
                        }
                        v4 = 2054;
                        break block17;
                    }
                    v4 = 4102;
                    break block17;
                }
                v4 = 0;
            }
            flags = v3 | v4;
            decorView.setSystemUiVisibility(flags);
        }
    }

    private static final void applyStatusBarConfiguration$lambda$0(ReactActivity $activity, DevLauncherExpoActivityConfigurator this$0, boolean $hidden, boolean $translucent, String $style, String $backgroundColor) {
        $activity.getWindow().clearFlags(0x4000000);
        this$0.setHidden($hidden, (Activity)$activity);
        this$0.setTranslucent($translucent, (Activity)$activity);
        String appliedStyle = this$0.setStyle($style, (Activity)$activity);
        String normalizedStatusBarBackgroundColor = DevLauncherColorsHelperKt.RGBAtoARGB($backgroundColor);
        int finalBackgroundColor = normalizedStatusBarBackgroundColor == null || !DevLauncherColorsHelperKt.isValidColor(normalizedStatusBarBackgroundColor) ? (Intrinsics.areEqual((Object)appliedStyle, (Object)"light-content") ? Color.parseColor((String)"#88000000") : 0) : Color.parseColor((String)normalizedStatusBarBackgroundColor);
        this$0.setColor(finalBackgroundColor, (Activity)$activity);
    }

    private static final WindowInsets setTranslucent$lambda$1(View v, WindowInsets insets) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        WindowInsets defaultInsets = v.onApplyWindowInsets(insets);
        return defaultInsets.replaceSystemWindowInsets(defaultInsets.getSystemWindowInsetLeft(), 0, defaultInsets.getSystemWindowInsetRight(), defaultInsets.getSystemWindowInsetBottom());
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lexpo/modules/devlauncher/launcher/configurators/DevLauncherExpoActivityConfigurator$Companion;", "", "<init>", "()V", "TAG", "", "kotlin.jvm.PlatformType", "expo-dev-launcher_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

