/*
 * Decompiled with CFR 0.152.
 */
package expo.modules.devlauncher;

import com.android.build.api.instrumentation.AsmClassVisitorFactory;
import com.android.build.api.instrumentation.ClassContext;
import com.android.build.api.instrumentation.ClassData;
import com.android.build.api.instrumentation.FramesComputationMode;
import com.android.build.api.instrumentation.InstrumentationParameters;
import com.android.build.api.instrumentation.InstrumentationScope;
import com.android.build.api.variant.AndroidComponentsExtension;
import com.android.build.api.variant.Component;
import com.android.build.api.variant.Variant;
import com.facebook.react.ReactExtension;
import expo.modules.devlauncher.DevLauncherPlugin;
import java.util.Collection;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0005\u000e\u000f\u0010\u0011\u0012B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002\u00a8\u0006\u0013"}, d2={"Lexpo/modules/devlauncher/DevLauncherPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "<init>", "()V", "apply", "", "project", "isDebugVariant", "", "variant", "Lcom/android/build/api/variant/Variant;", "reactExtension", "Lcom/facebook/react/ReactExtension;", "DevLauncherPluginParameters", "DevLauncherClassVisitorFactory", "OkHttpClassVisitor", "OkHttpClientCustomBuildMethod", "Companion", "expo-dev-launcher-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nDevLauncherPlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DevLauncherPlugin.kt\nexpo/modules/devlauncher/DevLauncherPlugin\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,130:1\n1755#2,3:131\n*S KotlinDebug\n*F\n+ 1 DevLauncherPlugin.kt\nexpo/modules/devlauncher/DevLauncherPlugin\n*L\n52#1:131,3\n*E\n"})
public abstract class DevLauncherPlugin
implements Plugin<Project> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Lazy<Logger> logger$delegate = LazyKt.lazy(DevLauncherPlugin::logger_delegate$lambda$1);

    public void apply(@NotNull Project project) {
        Boolean enableNetworkInspector;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object v = project.getProperties().get("EX_DEV_CLIENT_NETWORK_INSPECTOR");
        Boolean bl = v != null && (v = v.toString()) != null ? Boolean.valueOf(Boolean.parseBoolean(v)) : (enableNetworkInspector = null);
        if (enableNetworkInspector == null || enableNetworkInspector.booleanValue()) {
            boolean networkAddonsInstalled;
            boolean bl2 = networkAddonsInstalled = project.findProject(":expo-network-addons") != null;
            if (networkAddonsInstalled) {
                Companion.getLogger$expo_dev_launcher_gradle_plugin().warn("[DevLauncherPlugin] expo-network-addons is installed and will take this plugin's responsibilities");
                return;
            }
            AndroidComponentsExtension androidComponents = (AndroidComponentsExtension)project.getExtensions().getByType(AndroidComponentsExtension.class);
            ReactExtension reactExtension = (ReactExtension)project.getExtensions().findByType(ReactExtension.class);
            androidComponents.onVariants(androidComponents.selector().all(), new Function1<?, Unit>(this, reactExtension){
                final /* synthetic */ DevLauncherPlugin this$0;
                final /* synthetic */ ReactExtension $reactExtension;
                {
                    this.this$0 = $receiver;
                    this.$reactExtension = $reactExtension;
                }

                public final void invoke(Variant variant) {
                    Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
                    if (!DevLauncherPlugin.access$isDebugVariant(this.this$0, variant, this.$reactExtension)) {
                        return;
                    }
                    ((Component)variant).getInstrumentation().transformClassesWith(DevLauncherClassVisitorFactory.class, InstrumentationScope.ALL, apply.1::invoke$lambda$0);
                    ((Component)variant).getInstrumentation().setAsmFramesComputationMode(FramesComputationMode.COMPUTE_FRAMES_FOR_INSTRUMENTED_METHODS);
                }

                private static final Unit invoke$lambda$0(DevLauncherPluginParameters it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    it.getEnabled().set((Object)true);
                    return Unit.INSTANCE;
                }
            });
        }
    }

    private final boolean isDebugVariant(Variant variant, ReactExtension reactExtension) {
        boolean bl;
        block5: {
            if (!Intrinsics.areEqual((Object)System.getenv("EX_UPDATES_NATIVE_DEBUG"), (Object)"1") && reactExtension != null) {
                Object object = reactExtension.getDebuggableVariants().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                Iterable $this$any$iv = (Iterable)object;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        if (!StringsKt.equals((String)it, (String)variant.getName(), (boolean)true)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            } else {
                bl = Intrinsics.areEqual((Object)variant.getBuildType(), (Object)"debug") || Intrinsics.areEqual((Object)variant.getBuildType(), (Object)"debugOptimized");
            }
        }
        return bl;
    }

    private static final Logger logger_delegate$lambda$1() {
        return LoggerFactory.getLogger(DevLauncherPlugin.class);
    }

    public static final /* synthetic */ boolean access$isDebugVariant(DevLauncherPlugin $this, Variant variant, ReactExtension reactExtension) {
        return $this.isDebugVariant(variant, reactExtension);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R#\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u00058@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lexpo/modules/devlauncher/DevLauncherPlugin$Companion;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLogger$expo_dev_launcher_gradle_plugin", "()Lorg/slf4j/Logger;", "logger$delegate", "Lkotlin/Lazy;", "expo-dev-launcher-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public final Logger getLogger$expo_dev_launcher_gradle_plugin() {
            Lazy lazy = logger$delegate;
            return (Logger)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lexpo/modules/devlauncher/DevLauncherPlugin$DevLauncherClassVisitorFactory;", "Lcom/android/build/api/instrumentation/AsmClassVisitorFactory;", "Lexpo/modules/devlauncher/DevLauncherPlugin$DevLauncherPluginParameters;", "<init>", "()V", "createClassVisitor", "Lorg/objectweb/asm/ClassVisitor;", "classContext", "Lcom/android/build/api/instrumentation/ClassContext;", "nextClassVisitor", "isInstrumentable", "", "classData", "Lcom/android/build/api/instrumentation/ClassData;", "expo-dev-launcher-gradle-plugin"})
    public static abstract class DevLauncherClassVisitorFactory
    implements AsmClassVisitorFactory<DevLauncherPluginParameters> {
        @NotNull
        public ClassVisitor createClassVisitor(@NotNull ClassContext classContext, @NotNull ClassVisitor nextClassVisitor) {
            Intrinsics.checkNotNullParameter((Object)classContext, (String)"classContext");
            Intrinsics.checkNotNullParameter((Object)nextClassVisitor, (String)"nextClassVisitor");
            if (((Boolean)((DevLauncherPluginParameters)this.getParameters().get()).getEnabled().getOrElse((Object)false)).booleanValue()) {
                Object object = this.getInstrumentationContext().getApiVersion().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                return new OkHttpClassVisitor(classContext, ((Number)object).intValue(), nextClassVisitor);
            }
            return nextClassVisitor;
        }

        public boolean isInstrumentable(@NotNull ClassData classData) {
            Intrinsics.checkNotNullParameter((Object)classData, (String)"classData");
            if (((Boolean)((DevLauncherPluginParameters)this.getParameters().get()).getEnabled().getOrElse((Object)false)).booleanValue()) {
                return CollectionsKt.listOf((Object)"okhttp3.OkHttpClient$Builder").contains(classData.getClassName());
            }
            return false;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lexpo/modules/devlauncher/DevLauncherPlugin$DevLauncherPluginParameters;", "Lcom/android/build/api/instrumentation/InstrumentationParameters;", "enabled", "Lorg/gradle/api/provider/Property;", "", "getEnabled", "()Lorg/gradle/api/provider/Property;", "expo-dev-launcher-gradle-plugin"})
    public static interface DevLauncherPluginParameters
    extends InstrumentationParameters {
        @Input
        @Optional
        @NotNull
        public Property<Boolean> getEnabled();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0007\u0010\bJE\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\r2\u0010\u0010\u0010\u001a\f\u0012\u0006\b\u0001\u0012\u00020\r\u0018\u00010\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lexpo/modules/devlauncher/DevLauncherPlugin$OkHttpClassVisitor;", "Lorg/objectweb/asm/ClassVisitor;", "classContext", "Lcom/android/build/api/instrumentation/ClassContext;", "api", "", "classVisitor", "<init>", "(Lcom/android/build/api/instrumentation/ClassContext;ILorg/objectweb/asm/ClassVisitor;)V", "visitMethod", "Lorg/objectweb/asm/MethodVisitor;", "access", "name", "", "descriptor", "signature", "exceptions", "", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)Lorg/objectweb/asm/MethodVisitor;", "expo-dev-launcher-gradle-plugin"})
    public static final class OkHttpClassVisitor
    extends ClassVisitor {
        @NotNull
        private final ClassContext classContext;

        public OkHttpClassVisitor(@NotNull ClassContext classContext, int api, @NotNull ClassVisitor classVisitor) {
            Intrinsics.checkNotNullParameter((Object)classContext, (String)"classContext");
            Intrinsics.checkNotNullParameter((Object)classVisitor, (String)"classVisitor");
            super(api, classVisitor);
            this.classContext = classContext;
        }

        @NotNull
        public MethodVisitor visitMethod(int access, @Nullable String name, @Nullable String descriptor, @Nullable String signature, @Nullable String[] exceptions) {
            MethodVisitor originalVisitor = super.visitMethod(access, name, descriptor, signature, exceptions);
            if (Intrinsics.areEqual((Object)name, (Object)"build")) {
                Intrinsics.checkNotNull((Object)originalVisitor);
                return new OkHttpClientCustomBuildMethod(this.api, originalVisitor);
            }
            Intrinsics.checkNotNull((Object)originalVisitor);
            return originalVisitor;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lexpo/modules/devlauncher/DevLauncherPlugin$OkHttpClientCustomBuildMethod;", "Lorg/objectweb/asm/MethodVisitor;", "api", "", "methodVisitor", "<init>", "(ILorg/objectweb/asm/MethodVisitor;)V", "visitCode", "", "expo-dev-launcher-gradle-plugin"})
    public static final class OkHttpClientCustomBuildMethod
    extends MethodVisitor {
        public OkHttpClientCustomBuildMethod(int api, @NotNull MethodVisitor methodVisitor) {
            Intrinsics.checkNotNullParameter((Object)methodVisitor, (String)"methodVisitor");
            super(api, methodVisitor);
        }

        public void visitCode() {
            this.visitVarInsn(25, 0);
            this.visitTypeInsn(187, "expo/modules/kotlin/devtools/ExpoNetworkInspectOkHttpAppInterceptor");
            this.visitInsn(89);
            this.visitMethodInsn(183, "expo/modules/kotlin/devtools/ExpoNetworkInspectOkHttpAppInterceptor", "<init>", "()V", false);
            this.visitTypeInsn(192, "okhttp3/Interceptor");
            this.visitMethodInsn(182, "okhttp3/OkHttpClient$Builder", "addInterceptor", "(Lokhttp3/Interceptor;)Lokhttp3/OkHttpClient$Builder;", false);
            this.visitVarInsn(25, 0);
            this.visitTypeInsn(187, "expo/modules/kotlin/devtools/ExpoNetworkInspectOkHttpNetworkInterceptor");
            this.visitInsn(89);
            this.visitMethodInsn(183, "expo/modules/kotlin/devtools/ExpoNetworkInspectOkHttpNetworkInterceptor", "<init>", "()V", false);
            this.visitTypeInsn(192, "okhttp3/Interceptor");
            this.visitMethodInsn(182, "okhttp3/OkHttpClient$Builder", "addNetworkInterceptor", "(Lokhttp3/Interceptor;)Lokhttp3/OkHttpClient$Builder;", false);
            this.visitTypeInsn(187, "okhttp3/OkHttpClient");
            this.visitInsn(89);
            this.visitVarInsn(25, 0);
            this.visitMethodInsn(183, "okhttp3/OkHttpClient", "<init>", "(Lokhttp3/OkHttpClient$Builder;)V", false);
            this.visitInsn(176);
        }
    }
}

