/*
 * Decompiled with CFR 0.152.
 */
package expo.modules.devmenu.detectors;

import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import androidx.compose.runtime.internal.StabilityInferred;
import expo.modules.devmenu.detectors.ShakeDetectorKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\fJ\u0006\u0010\u0018\u001a\u00020\u0004J\u0010\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000eH\u0016J\b\u0010 \u001a\u00020\u0004H\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\bH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006$"}, d2={"Lexpo/modules/devmenu/detectors/ShakeDetector;", "Landroid/hardware/SensorEventListener;", "shakeListener", "Lkotlin/Function0;", "", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "accelerationX", "", "accelerationY", "accelerationZ", "sensorManager", "Landroid/hardware/SensorManager;", "numShakes", "", "lastDispatchedShakeTimestamp", "", "minRecordedShakes", "getMinRecordedShakes", "()I", "setMinRecordedShakes", "(I)V", "start", "manager", "stop", "onSensorChanged", "sensorEvent", "Landroid/hardware/SensorEvent;", "onAccuracyChanged", "sensor", "Landroid/hardware/Sensor;", "i", "reset", "atLeastRequiredForce", "", "a", "expo-dev-menu_release"})
@StabilityInferred(parameters=0)
public final class ShakeDetector
implements SensorEventListener {
    @NotNull
    private final Function0<Unit> shakeListener;
    private float accelerationX;
    private float accelerationY;
    private float accelerationZ;
    @Nullable
    private SensorManager sensorManager;
    private int numShakes;
    private long lastDispatchedShakeTimestamp;
    private int minRecordedShakes;
    public static final int $stable = 8;

    public ShakeDetector(@NotNull Function0<Unit> shakeListener) {
        Intrinsics.checkNotNullParameter(shakeListener, (String)"shakeListener");
        this.shakeListener = shakeListener;
        this.minRecordedShakes = 3;
    }

    public final int getMinRecordedShakes() {
        return this.minRecordedShakes;
    }

    public final void setMinRecordedShakes(int n) {
        this.minRecordedShakes = n;
    }

    public final void start(@NotNull SensorManager manager) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
            Sensor sensor = manager.getDefaultSensor(1);
            if (sensor == null) break block0;
            Sensor it = sensor;
            boolean bl = false;
            this.sensorManager = manager;
            manager.registerListener((SensorEventListener)this, it, 2);
            this.lastDispatchedShakeTimestamp = 0L;
            this.reset();
        }
    }

    public final void stop() {
        SensorManager sensorManager = this.sensorManager;
        if (sensorManager != null) {
            sensorManager.unregisterListener((SensorEventListener)this);
        }
        this.sensorManager = null;
    }

    public void onSensorChanged(@NotNull SensorEvent sensorEvent) {
        Intrinsics.checkNotNullParameter((Object)sensorEvent, (String)"sensorEvent");
        if (sensorEvent.timestamp - this.lastDispatchedShakeTimestamp < ShakeDetectorKt.access$getMIN_TIME_AFTER_SHAKE_NS$p()) {
            return;
        }
        float ax = sensorEvent.values[0];
        float ay = sensorEvent.values[1];
        float az = sensorEvent.values[2] - 9.80665f;
        if (this.atLeastRequiredForce(ax) && ax * this.accelerationX <= 0.0f) {
            int n = this.numShakes;
            this.numShakes = n + 1;
            this.accelerationX = ax;
        } else if (this.atLeastRequiredForce(ay) && ay * this.accelerationY <= 0.0f) {
            int n = this.numShakes;
            this.numShakes = n + 1;
            this.accelerationY = ay;
        } else if (this.atLeastRequiredForce(az) && az * this.accelerationZ <= 0.0f) {
            int n = this.numShakes;
            this.numShakes = n + 1;
            this.accelerationZ = az;
        }
        if (this.numShakes >= this.minRecordedShakes) {
            this.reset();
            this.shakeListener.invoke();
            this.lastDispatchedShakeTimestamp = sensorEvent.timestamp;
        }
    }

    public void onAccuracyChanged(@NotNull Sensor sensor, int i) {
        Intrinsics.checkNotNullParameter((Object)sensor, (String)"sensor");
    }

    private final void reset() {
        this.numShakes = 0;
        this.accelerationX = 0.0f;
        this.accelerationY = 0.0f;
        this.accelerationZ = 0.0f;
    }

    private final boolean atLeastRequiredForce(float a) {
        return Math.abs(a) > 13.042845f;
    }
}

