/*
 * Decompiled with CFR 0.152.
 */
package expo.modules.devmenu.detectors;

import android.os.SystemClock;
import android.view.MotionEvent;
import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0011\u001a\u00020\u00042\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0010\u00a8\u0006\u0014"}, d2={"Lexpo/modules/devmenu/detectors/ThreeFingerLongPressDetector;", "", "longPressListener", "Lkotlin/Function0;", "", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "getLongPressListener", "()Lkotlin/jvm/functions/Function0;", "startedDetecting", "", "startTime", "", "startPosition", "", "Landroid/view/MotionEvent$PointerCoords;", "[Landroid/view/MotionEvent$PointerCoords;", "onTouchEvent", "event", "Landroid/view/MotionEvent;", "expo-dev-menu_release"})
@StabilityInferred(parameters=0)
public final class ThreeFingerLongPressDetector {
    @NotNull
    private final Function0<Unit> longPressListener;
    private boolean startedDetecting;
    private long startTime;
    @NotNull
    private MotionEvent.PointerCoords[] startPosition;
    public static final int $stable = 8;

    public ThreeFingerLongPressDetector(@NotNull Function0<Unit> longPressListener) {
        Intrinsics.checkNotNullParameter(longPressListener, (String)"longPressListener");
        this.longPressListener = longPressListener;
        this.startTime = Long.MAX_VALUE;
        int n = 0;
        MotionEvent.PointerCoords[] pointerCoordsArray = new MotionEvent.PointerCoords[3];
        ThreeFingerLongPressDetector threeFingerLongPressDetector = this;
        while (n < 3) {
            int n2 = n++;
            pointerCoordsArray[n2] = new MotionEvent.PointerCoords();
        }
        threeFingerLongPressDetector.startPosition = pointerCoordsArray;
    }

    @NotNull
    public final Function0<Unit> getLongPressListener() {
        return this.longPressListener;
    }

    public final void onTouchEvent(@Nullable MotionEvent event) {
        if (!this.startedDetecting) {
            MotionEvent motionEvent = event;
            boolean bl = motionEvent != null ? motionEvent.getAction() == 2 : false;
            if (bl && event.getPointerCount() == 3) {
                this.startedDetecting = true;
                this.startTime = SystemClock.uptimeMillis();
                for (int i = 0; i < 3; ++i) {
                    event.getPointerCoords(i, this.startPosition[i]);
                }
                return;
            }
        }
        MotionEvent motionEvent = event;
        if (!(motionEvent != null ? motionEvent.getAction() == 2 : false) || event.getPointerCount() != 3) {
            this.startedDetecting = false;
            return;
        }
        for (int i = 0; i < 3; ++i) {
            MotionEvent.PointerCoords out = new MotionEvent.PointerCoords();
            event.getPointerCoords(i, out);
            if (!((double)Math.abs(out.x - this.startPosition[i].x) > 20.0) && !((double)Math.abs(out.y - this.startPosition[i].y) > 20.0)) continue;
            this.startedDetecting = false;
            return;
        }
        if (SystemClock.uptimeMillis() - this.startTime >= 800L) {
            this.longPressListener.invoke();
            this.startedDetecting = false;
        }
    }
}

