/*
 * Decompiled with CFR 0.152.
 */
package expo.modules.devmenu.devtools;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.provider.Settings;
import android.util.Log;
import androidx.compose.runtime.internal.StabilityInferred;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.devsupport.interfaces.DevSupportManager;
import com.facebook.react.modules.debug.interfaces.DeveloperSettings;
import expo.interfaces.devmenu.DevMenuManagerInterface;
import expo.interfaces.devmenu.ReactHostWrapper;
import expo.modules.devmenu.DevMenuManager;
import expo.modules.devmenu.api.DevMenuMetroClient;
import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u0018J\u000e\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u0018J\u0017\u0010\u001e\u001a\u00020\u00182\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00180 H\u0082\bJ\u0010\u0010!\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\r\u001a\u0004\u0018\u00010\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\u0014\u001a\u0004\u0018\u00010\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\""}, d2={"Lexpo/modules/devmenu/devtools/DevMenuDevToolsDelegate;", "", "manager", "Lexpo/interfaces/devmenu/DevMenuManagerInterface;", "reactHost", "Lexpo/interfaces/devmenu/ReactHostWrapper;", "<init>", "(Lexpo/interfaces/devmenu/DevMenuManagerInterface;Lexpo/interfaces/devmenu/ReactHostWrapper;)V", "_reactDevManager", "Ljava/lang/ref/WeakReference;", "Lcom/facebook/react/devsupport/interfaces/DevSupportManager;", "_reactContext", "Lcom/facebook/react/bridge/ReactContext;", "reactDevManager", "getReactDevManager", "()Lcom/facebook/react/devsupport/interfaces/DevSupportManager;", "devSettings", "Lcom/facebook/react/modules/debug/interfaces/DeveloperSettings;", "getDevSettings", "()Lcom/facebook/react/modules/debug/interfaces/DeveloperSettings;", "reactContext", "getReactContext", "()Lcom/facebook/react/bridge/ReactContext;", "reload", "", "toggleElementInspector", "togglePerformanceMonitor", "context", "Landroid/content/Context;", "openJSInspector", "runWithDevSupportEnabled", "action", "Lkotlin/Function0;", "requestOverlaysPermission", "expo-dev-menu_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nDevMenuDevToolsDelegate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DevMenuDevToolsDelegate.kt\nexpo/modules/devmenu/devtools/DevMenuDevToolsDelegate\n+ 2 Uri.kt\nandroidx/core/net/UriKt\n*L\n1#1,101:1\n78#1,6:102\n78#1,6:108\n78#1,6:114\n29#2:120\n*S KotlinDebug\n*F\n+ 1 DevMenuDevToolsDelegate.kt\nexpo/modules/devmenu/devtools/DevMenuDevToolsDelegate\n*L\n44#1:102,6\n53#1:108,6\n58#1:114,6\n91#1:120\n*E\n"})
public final class DevMenuDevToolsDelegate {
    @NotNull
    private final DevMenuManagerInterface manager;
    @NotNull
    private final WeakReference<DevSupportManager> _reactDevManager;
    @NotNull
    private final WeakReference<ReactContext> _reactContext;
    public static final int $stable = 8;

    public DevMenuDevToolsDelegate(@NotNull DevMenuManagerInterface manager, @NotNull ReactHostWrapper reactHost) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)reactHost, (String)"reactHost");
        this.manager = manager;
        this._reactDevManager = new WeakReference<DevSupportManager>(reactHost.getDevSupportManager());
        this._reactContext = new WeakReference<ReactContext>(reactHost.getCurrentReactContext());
    }

    @Nullable
    public final DevSupportManager getReactDevManager() {
        return (DevSupportManager)this._reactDevManager.get();
    }

    @Nullable
    public final DeveloperSettings getDevSettings() {
        DevSupportManager devSupportManager = this.getReactDevManager();
        return devSupportManager != null ? devSupportManager.getDevSettings() : null;
    }

    @Nullable
    public final ReactContext getReactContext() {
        return (ReactContext)this._reactContext.get();
    }

    public final void reload() {
        DevSupportManager devSupportManager = this.getReactDevManager();
        if (devSupportManager == null) {
            return;
        }
        DevSupportManager reactDevManager = devSupportManager;
        this.manager.closeMenu();
        UiThreadUtil.runOnUiThread(() -> DevMenuDevToolsDelegate.reload$lambda$0(reactDevManager));
    }

    public final void toggleElementInspector() {
        DevMenuDevToolsDelegate this_$iv = this;
        boolean $i$f$runWithDevSupportEnabled = false;
        DevSupportManager devSupportManager = this_$iv.getReactDevManager();
        if (devSupportManager != null) {
            DevSupportManager reactDevManager$iv = devSupportManager;
            boolean currentSetting$iv = reactDevManager$iv.getDevSupportEnabled();
            reactDevManager$iv.setDevSupportEnabled(true);
            boolean bl = false;
            DevSupportManager devSupportManager2 = this.getReactDevManager();
            if (devSupportManager2 != null) {
                devSupportManager2.toggleElementInspector();
            }
            reactDevManager$iv.setDevSupportEnabled(currentSetting$iv);
        }
    }

    public final void togglePerformanceMonitor(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        DevSupportManager devSupportManager = this.getReactDevManager();
        if (devSupportManager == null) {
            return;
        }
        DevSupportManager reactDevManager = devSupportManager;
        DeveloperSettings developerSettings = this.getDevSettings();
        if (developerSettings == null) {
            return;
        }
        DeveloperSettings devSettings = developerSettings;
        this.requestOverlaysPermission(context);
        DevMenuDevToolsDelegate this_$iv = this;
        boolean $i$f$runWithDevSupportEnabled = false;
        DevSupportManager devSupportManager2 = this_$iv.getReactDevManager();
        if (devSupportManager2 != null) {
            DevSupportManager reactDevManager$iv = devSupportManager2;
            boolean currentSetting$iv = reactDevManager$iv.getDevSupportEnabled();
            reactDevManager$iv.setDevSupportEnabled(true);
            boolean bl = false;
            reactDevManager.setFpsDebugEnabled(!devSettings.isFpsDebugEnabled());
            reactDevManager$iv.setDevSupportEnabled(currentSetting$iv);
        }
    }

    public final void openJSInspector() {
        DevMenuDevToolsDelegate this_$iv = this;
        boolean $i$f$runWithDevSupportEnabled = false;
        DevSupportManager devSupportManager = this_$iv.getReactDevManager();
        if (devSupportManager != null) {
            DevSupportManager reactDevManager$iv = devSupportManager;
            boolean currentSetting$iv = reactDevManager$iv.getDevSupportEnabled();
            reactDevManager$iv.setDevSupportEnabled(true);
            boolean bl = false;
            DeveloperSettings developerSettings = this.getDevSettings();
            if (developerSettings == null) {
                return;
            }
            DeveloperSettings devSettings = developerSettings;
            ReactContext reactContext = this.getReactContext();
            if (reactContext == null) {
                return;
            }
            ReactContext reactContext2 = reactContext;
            String metroHost = "http://" + devSettings.getPackagerConnectionSettings().getDebugServerHost();
            BuildersKt.launch$default((CoroutineScope)this.manager.getCoroutineScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(metroHost, reactContext2, null){
                int label;
                final /* synthetic */ String $metroHost;
                final /* synthetic */ ReactContext $reactContext;
                {
                    this.$metroHost = $metroHost;
                    this.$reactContext = $reactContext;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            DevMenuMetroClient devMenuMetroClient = DevMenuManager.INSTANCE.getMetroClient();
                            String string = this.$reactContext.getPackageName();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPackageName(...)");
                            this.label = 1;
                            Object object3 = devMenuMetroClient.openJSInspector(this.$metroHost, string, (Continuation<? super Unit>)((Continuation)this));
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            Object object3;
                            try {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                object3 = $result;
                                return Unit.INSTANCE;
                            }
                            catch (Exception e) {
                                Log.w((String)"[disabled] ExpoDevMenu", (String)("Unable to open js inspector: " + e.getMessage()), (Throwable)e);
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
            reactDevManager$iv.setDevSupportEnabled(currentSetting$iv);
        }
    }

    private final void runWithDevSupportEnabled(Function0<Unit> action) {
        boolean $i$f$runWithDevSupportEnabled = false;
        DevSupportManager devSupportManager = this.getReactDevManager();
        if (devSupportManager == null) {
            return;
        }
        DevSupportManager reactDevManager = devSupportManager;
        boolean currentSetting = reactDevManager.getDevSupportEnabled();
        reactDevManager.setDevSupportEnabled(true);
        action.invoke();
        reactDevManager.setDevSupportEnabled(currentSetting);
    }

    private final void requestOverlaysPermission(Context context) {
        if (!Settings.canDrawOverlays((Context)context)) {
            Intent intent;
            String $this$toUri$iv = "package:" + context.getApplicationContext().getPackageName();
            boolean $i$f$toUri = false;
            Uri uri = Uri.parse((String)$this$toUri$iv);
            Intent $this$requestOverlaysPermission_u24lambda_u244 = intent = new Intent("android.settings.action.MANAGE_OVERLAY_PERMISSION", uri);
            boolean bl = false;
            $this$requestOverlaysPermission_u24lambda_u244.setFlags(0x10000000);
            Intent intent2 = intent;
            if (intent2.resolveActivity(context.getPackageManager()) != null) {
                context.startActivity(intent2);
            }
        }
    }

    private static final void reload$lambda$0(DevSupportManager $reactDevManager) {
        $reactDevManager.handleReloadJS();
    }
}

