/*
 * Decompiled with CFR 0.152.
 */
package expo.modules.devmenu.fab;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0001\u0018\u00002\u00020\u0001:\u0002\u0012\u0013B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fJ\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0010\u001a\u00020\nH\u0002J\u0006\u0010\u0011\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lexpo/modules/devmenu/fab/ExpoVelocityTracker;", "", "timeFrameMillis", "", "<init>", "(J)V", "positions", "Ljava/util/LinkedList;", "Lexpo/modules/devmenu/fab/ExpoVelocityTracker$PositionSnapshot;", "registerPosition", "", "x", "", "y", "calculateVelocity", "Lexpo/modules/devmenu/fab/ExpoVelocityTracker$PointF;", "pruneOldPositions", "clear", "PointF", "PositionSnapshot", "expo-dev-menu_release"})
@StabilityInferred(parameters=0)
public final class ExpoVelocityTracker {
    private final long timeFrameMillis;
    @NotNull
    private final LinkedList<PositionSnapshot> positions;
    public static final int $stable = 8;

    public ExpoVelocityTracker(long timeFrameMillis) {
        this.timeFrameMillis = timeFrameMillis;
        this.positions = new LinkedList();
    }

    public /* synthetic */ ExpoVelocityTracker(long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            l = 100L;
        }
        this(l);
    }

    public final void registerPosition(float x, float y) {
        PositionSnapshot snapshot = new PositionSnapshot(new PointF(x, y), System.currentTimeMillis());
        this.positions.add(snapshot);
        this.pruneOldPositions();
    }

    @NotNull
    public final PointF calculateVelocity() {
        this.pruneOldPositions();
        if (this.positions.size() < 2) {
            return new PointF(0.0f, 0.0f);
        }
        PositionSnapshot first = (PositionSnapshot)CollectionsKt.first((List)this.positions);
        PositionSnapshot last = (PositionSnapshot)CollectionsKt.last((List)this.positions);
        float deltaTimeSeconds = (float)(last.getTimestamp() - first.getTimestamp()) / 1000.0f;
        if (deltaTimeSeconds == 0.0f) {
            return new PointF(0.0f, 0.0f);
        }
        float deltaX = last.getPoint().getX() - first.getPoint().getX();
        float deltaY = last.getPoint().getY() - first.getPoint().getY();
        float velocityX = deltaX / deltaTimeSeconds;
        float velocityY = deltaY / deltaTimeSeconds;
        return new PointF(velocityX, velocityY);
    }

    private final void pruneOldPositions() {
        long currentTime = System.currentTimeMillis();
        long cutoffTime = currentTime - this.timeFrameMillis;
        while (!((Collection)this.positions).isEmpty() && ((PositionSnapshot)CollectionsKt.first((List)this.positions)).getTimestamp() < cutoffTime) {
            this.positions.pollFirst();
        }
    }

    public final void clear() {
        this.positions.clear();
    }

    public ExpoVelocityTracker() {
        this(0L, 1, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0014"}, d2={"Lexpo/modules/devmenu/fab/ExpoVelocityTracker$PointF;", "", "x", "", "y", "<init>", "(FF)V", "getX", "()F", "getY", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "expo-dev-menu_release"})
    @StabilityInferred(parameters=1)
    public static final class PointF {
        private final float x;
        private final float y;
        public static final int $stable;

        public PointF(float x, float y) {
            this.x = x;
            this.y = y;
        }

        public final float getX() {
            return this.x;
        }

        public final float getY() {
            return this.y;
        }

        public final float component1() {
            return this.x;
        }

        public final float component2() {
            return this.y;
        }

        @NotNull
        public final PointF copy(float x, float y) {
            return new PointF(x, y);
        }

        public static /* synthetic */ PointF copy$default(PointF pointF, float f, float f2, int n, Object object) {
            if ((n & 1) != 0) {
                f = pointF.x;
            }
            if ((n & 2) != 0) {
                f2 = pointF.y;
            }
            return pointF.copy(f, f2);
        }

        @NotNull
        public String toString() {
            return "PointF(x=" + this.x + ", y=" + this.y + ")";
        }

        public int hashCode() {
            int result = Float.hashCode(this.x);
            result = result * 31 + Float.hashCode(this.y);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PointF)) {
                return false;
            }
            PointF pointF = (PointF)other;
            if (Float.compare(this.x, pointF.x) != 0) {
                return false;
            }
            return Float.compare(this.y, pointF.y) == 0;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lexpo/modules/devmenu/fab/ExpoVelocityTracker$PositionSnapshot;", "", "point", "Lexpo/modules/devmenu/fab/ExpoVelocityTracker$PointF;", "timestamp", "", "<init>", "(Lexpo/modules/devmenu/fab/ExpoVelocityTracker$PointF;J)V", "getPoint", "()Lexpo/modules/devmenu/fab/ExpoVelocityTracker$PointF;", "getTimestamp", "()J", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "expo-dev-menu_release"})
    private static final class PositionSnapshot {
        @NotNull
        private final PointF point;
        private final long timestamp;

        public PositionSnapshot(@NotNull PointF point, long timestamp) {
            Intrinsics.checkNotNullParameter((Object)point, (String)"point");
            this.point = point;
            this.timestamp = timestamp;
        }

        @NotNull
        public final PointF getPoint() {
            return this.point;
        }

        public final long getTimestamp() {
            return this.timestamp;
        }

        @NotNull
        public final PointF component1() {
            return this.point;
        }

        public final long component2() {
            return this.timestamp;
        }

        @NotNull
        public final PositionSnapshot copy(@NotNull PointF point, long timestamp) {
            Intrinsics.checkNotNullParameter((Object)point, (String)"point");
            return new PositionSnapshot(point, timestamp);
        }

        public static /* synthetic */ PositionSnapshot copy$default(PositionSnapshot positionSnapshot, PointF pointF, long l, int n, Object object) {
            if ((n & 1) != 0) {
                pointF = positionSnapshot.point;
            }
            if ((n & 2) != 0) {
                l = positionSnapshot.timestamp;
            }
            return positionSnapshot.copy(pointF, l);
        }

        @NotNull
        public String toString() {
            return "PositionSnapshot(point=" + this.point + ", timestamp=" + this.timestamp + ")";
        }

        public int hashCode() {
            int result = this.point.hashCode();
            result = result * 31 + Long.hashCode(this.timestamp);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PositionSnapshot)) {
                return false;
            }
            PositionSnapshot positionSnapshot = (PositionSnapshot)other;
            if (!Intrinsics.areEqual((Object)this.point, (Object)positionSnapshot.point)) {
                return false;
            }
            return this.timestamp == positionSnapshot.timestamp;
        }
    }
}

