/*
 * Decompiled with CFR 0.152.
 */
package expo.modules.devmenu.websockets;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import androidx.compose.runtime.internal.StabilityInferred;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.packagerconnection.NotificationOnlyHandler;
import expo.interfaces.devmenu.DevMenuManagerInterface;
import expo.interfaces.devmenu.ReactHostWrapper;
import expo.modules.devmenu.devtools.DevMenuDevToolsDelegate;
import expo.modules.devmenu.websockets.DevMenuCommandHandlersProvider;
import java.lang.ref.WeakReference;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000?\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000*\u0003\u000f\u0012\u0015\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u0018R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0010\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00050\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\u0004\u0018\u00010\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u0010\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u0010\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016\u00a8\u0006\u001b"}, d2={"Lexpo/modules/devmenu/websockets/DevMenuCommandHandlersProvider;", "", "manager", "Lexpo/interfaces/devmenu/DevMenuManagerInterface;", "reactHost", "Lexpo/interfaces/devmenu/ReactHostWrapper;", "<init>", "(Lexpo/interfaces/devmenu/DevMenuManagerInterface;Lexpo/interfaces/devmenu/ReactHostWrapper;)V", "_host", "Ljava/lang/ref/WeakReference;", "kotlin.jvm.PlatformType", "host", "getHost", "()Lexpo/interfaces/devmenu/ReactHostWrapper;", "onReload", "expo/modules/devmenu/websockets/DevMenuCommandHandlersProvider$onReload$1", "Lexpo/modules/devmenu/websockets/DevMenuCommandHandlersProvider$onReload$1;", "onDevMenu", "expo/modules/devmenu/websockets/DevMenuCommandHandlersProvider$onDevMenu$1", "Lexpo/modules/devmenu/websockets/DevMenuCommandHandlersProvider$onDevMenu$1;", "onDevCommand", "expo/modules/devmenu/websockets/DevMenuCommandHandlersProvider$onDevCommand$1", "Lexpo/modules/devmenu/websockets/DevMenuCommandHandlersProvider$onDevCommand$1;", "createCommandHandlers", "", "", "Lcom/facebook/react/packagerconnection/NotificationOnlyHandler;", "expo-dev-menu_release"})
@StabilityInferred(parameters=0)
public final class DevMenuCommandHandlersProvider {
    @NotNull
    private final DevMenuManagerInterface manager;
    @NotNull
    private final WeakReference<ReactHostWrapper> _host;
    @NotNull
    private final onReload.1 onReload;
    @NotNull
    private final onDevMenu.1 onDevMenu;
    @NotNull
    private final onDevCommand.1 onDevCommand;
    public static final int $stable = 8;

    public DevMenuCommandHandlersProvider(@NotNull DevMenuManagerInterface manager, @NotNull ReactHostWrapper reactHost) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)reactHost, (String)"reactHost");
        this.manager = manager;
        this._host = new WeakReference<ReactHostWrapper>(reactHost);
        this.onReload = new NotificationOnlyHandler(this){
            final /* synthetic */ DevMenuCommandHandlersProvider this$0;
            {
                this.this$0 = $receiver;
            }

            public void onNotification(Object params) {
                DevMenuCommandHandlersProvider.access$getManager$p(this.this$0).closeMenu();
                UiThreadUtil.runOnUiThread(() -> onReload.1.onNotification$lambda$0(this.this$0));
            }

            private static final void onNotification$lambda$0(DevMenuCommandHandlersProvider this$0) {
                block0: {
                    ReactHostWrapper reactHostWrapper = DevMenuCommandHandlersProvider.access$getHost(this$0);
                    if (reactHostWrapper == null || (reactHostWrapper = reactHostWrapper.getDevSupportManager()) == null) break block0;
                    reactHostWrapper.handleReloadJS();
                }
            }
        };
        this.onDevMenu = new NotificationOnlyHandler(this){
            final /* synthetic */ DevMenuCommandHandlersProvider this$0;
            {
                this.this$0 = $receiver;
            }

            public void onNotification(Object params) {
                ReactHostWrapper reactHostWrapper = DevMenuCommandHandlersProvider.access$getHost(this.this$0);
                if (reactHostWrapper == null || (reactHostWrapper = reactHostWrapper.getCurrentReactContext()) == null || (reactHostWrapper = reactHostWrapper.getCurrentActivity()) == null) {
                    return;
                }
                ReactHostWrapper activity = reactHostWrapper;
                DevMenuCommandHandlersProvider.access$getManager$p(this.this$0).toggleMenu((Activity)activity);
            }
        };
        this.onDevCommand = new NotificationOnlyHandler(this){
            final /* synthetic */ DevMenuCommandHandlersProvider this$0;
            {
                this.this$0 = $receiver;
            }

            public void onNotification(Object params) {
                block23: {
                    String command;
                    ReactHostWrapper reactHostWrapper = DevMenuCommandHandlersProvider.access$getHost(this.this$0);
                    if (reactHostWrapper == null) {
                        return;
                    }
                    ReactHostWrapper host = reactHostWrapper;
                    DevMenuDevToolsDelegate devDelegate = new DevMenuDevToolsDelegate(DevMenuCommandHandlersProvider.access$getManager$p(this.this$0), host);
                    if (!(params instanceof JSONObject)) break block23;
                    String string = ((JSONObject)params).optString("name");
                    if (string == null) {
                        return;
                    }
                    switch (command = string) {
                        case "reload": {
                            devDelegate.reload();
                            break;
                        }
                        case "toggleDevMenu": {
                            ReactContext reactContext = host.getCurrentReactContext();
                            if (reactContext == null || (reactContext = reactContext.getCurrentActivity()) == null) {
                                return;
                            }
                            ReactContext activity = reactContext;
                            DevMenuCommandHandlersProvider.access$getManager$p(this.this$0).toggleMenu((Activity)activity);
                            break;
                        }
                        case "toggleElementInspector": {
                            devDelegate.toggleElementInspector();
                            break;
                        }
                        case "togglePerformanceMonitor": {
                            ReactContext reactContext = host.getCurrentReactContext();
                            if (reactContext == null || (reactContext = reactContext.getCurrentActivity()) == null) {
                                return;
                            }
                            ReactContext activity = reactContext;
                            devDelegate.togglePerformanceMonitor((Context)activity);
                            break;
                        }
                        case "openJSInspector": {
                            devDelegate.openJSInspector();
                            break;
                        }
                        default: {
                            Log.w((String)"DevMenu", (String)("Unknown command: " + command));
                        }
                    }
                }
            }
        };
    }

    private final ReactHostWrapper getHost() {
        return (ReactHostWrapper)this._host.get();
    }

    @NotNull
    public final Map<String, NotificationOnlyHandler> createCommandHandlers() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"reload", (Object)((Object)this.onReload)), TuplesKt.to((Object)"devMenu", (Object)((Object)this.onDevMenu)), TuplesKt.to((Object)"sendDevCommand", (Object)((Object)this.onDevCommand))};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    public static final /* synthetic */ DevMenuManagerInterface access$getManager$p(DevMenuCommandHandlersProvider $this) {
        return $this.manager;
    }

    public static final /* synthetic */ ReactHostWrapper access$getHost(DevMenuCommandHandlersProvider $this) {
        return $this.getHost();
    }
}

