/*
 * Decompiled with CFR 0.152.
 */
package expo.modules.plugin;

import com.android.build.api.dsl.AndroidSourceSet;
import com.android.build.api.dsl.CommonExtension;
import com.android.build.api.variant.AndroidComponentsExtension;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.internal.dsl.ProductFlavor;
import com.android.build.gradle.internal.tasks.factory.TaskFactoryUtils;
import expo.modules.plugin.AutolinkingOptions;
import expo.modules.plugin.ExpoGradleExtension;
import expo.modules.plugin.GeneratePackagesListTask;
import expo.modules.plugin.ProjectExtensionKt;
import expo.modules.plugin.configuration.ExpoAutolinkingConfig;
import expo.modules.plugin.configuration.GradleProject;
import expo.modules.plugin.configuration.Publication;
import expo.modules.plugin.text.ColorsKt;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0007\u001a\u00020\u0002J\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t2\u0006\u0010\u0007\u001a\u00020\u0002J,\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0017\u001a\u00020\u0002H\u0002J\u0018\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u0002H\u0002J&\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00130\u001b2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0002J.\u0010\u001f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00130\u001bH\u0002\u00a8\u0006!"}, d2={"Lexpo/modules/plugin/ExpoAutolinkingPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "<init>", "()V", "apply", "", "project", "getPackageListDir", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "getPackageListFile", "Lorg/gradle/api/file/RegularFile;", "createGeneratePackagesListTask", "Lorg/gradle/api/tasks/TaskProvider;", "Lexpo/modules/plugin/GeneratePackagesListTask;", "options", "Lexpo/modules/plugin/AutolinkingOptions;", "hash", "", "projectRoot", "Ljava/io/File;", "findAppProject", "root", "copyAppDimensionsAndFlavorsToProject", "appProject", "syncFlavorDimensions", "", "consumerAndroid", "Lcom/android/build/gradle/BaseExtension;", "appAndroid", "copyMissingProductFlavors", "appDimensions", "expo-autolinking-plugin"})
@SourceDebugExtension(value={"SMAP\nExpoAutolinkingPlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExpoAutolinkingPlugin.kt\nexpo/modules/plugin/ExpoAutolinkingPlugin\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,169:1\n1#2:170\n3193#3,10:171\n1863#3,2:181\n295#3,2:183\n1755#3,3:185\n1557#3:190\n1628#3,3:191\n1863#3,2:194\n37#4,2:188\n*S KotlinDebug\n*F\n+ 1 ExpoAutolinkingPlugin.kt\nexpo/modules/plugin/ExpoAutolinkingPlugin\n*L\n34#1:171,10\n47#1:181,2\n100#1:183,2\n129#1:185,3\n154#1:190\n154#1:191,3\n156#1:194,2\n139#1:188,2\n*E\n"})
public class ExpoAutolinkingPlugin
implements Plugin<Project> {
    public void apply(@NotNull Project project) {
        Project appProject;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ExpoGradleExtension expoGradleExtension = (ExpoGradleExtension)project.getGradle().getExtensions().findByType(ExpoGradleExtension.class);
        if (expoGradleExtension == null) {
            throw new IllegalStateException("`ExpoGradleExtension` not found. Please, make sure that `useExpoModules` was called in `settings.gradle`.");
        }
        ExpoGradleExtension gradleExtension = expoGradleExtension;
        ExpoAutolinkingConfig config = gradleExtension.getConfig();
        project.getLogger().quiet("");
        project.getLogger().quiet("Using expo modules");
        Project project2 = project.getRootProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getRootProject(...)");
        Project project3 = appProject = this.findAppProject(project2);
        if (project3 != null) {
            Project it = project3;
            boolean bl = false;
            this.copyAppDimensionsAndFlavorsToProject(project, it);
        }
        Iterable $this$partition$iv = config.getAllProjects();
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            GradleProject project4 = (GradleProject)element$iv;
            boolean bl = false;
            if (project4.getUsePublication()) {
                first$iv.add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List prebuiltProjects = (List)pair.component1();
        List projects = (List)pair.component2();
        ProjectExtensionKt.withSubprojects(project, projects, (Function1<? super Project, Unit>)((Function1)arg_0 -> ExpoAutolinkingPlugin.apply$lambda$2(project, arg_0)));
        Iterable $this$forEach$iv = prebuiltProjects;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Publication publication;
            GradleProject prebuiltProject = (GradleProject)element$iv;
            boolean bl = false;
            if (prebuiltProject.getPublication() == null) {
                String string = "Required value was null.";
                throw new IllegalArgumentException(string.toString());
            }
            project.getDependencies().add("api", (Object)(publication.getGroupId() + ":" + publication.getArtifactId() + ":" + publication.getVersion()));
            project.getLogger().quiet("  - " + ColorsKt.withColor((Object)"[\ud83d\udce6]", (String)"\u001b[33m") + " " + ColorsKt.withColor((Object)prebuiltProject.getName(), (String)"\u001b[32m") + " (" + publication.getVersion() + ")");
        }
        project.getLogger().quiet("");
        TaskProvider<GeneratePackagesListTask> generatePackagesList = this.createGeneratePackagesListTask(project, gradleExtension.getOptions(), gradleExtension.getHash(), gradleExtension.getProjectRoot());
        TaskProvider taskProvider = project.getTasks().named("preBuild", Task.class);
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"named(...)");
        TaskProvider[] taskProviderArray = new TaskProvider[]{generatePackagesList};
        TaskFactoryUtils.dependsOn((TaskProvider)taskProvider, (TaskProvider[])taskProviderArray);
        ((AndroidComponentsExtension)project.getExtensions().getByType(AndroidComponentsExtension.class)).finalizeDsl(new Function1<?, Unit>(this, project){
            final /* synthetic */ ExpoAutolinkingPlugin this$0;
            final /* synthetic */ Project $project;
            {
                this.this$0 = $receiver;
                this.$project = $project;
            }

            public final void invoke(CommonExtension<?, ?, ?, ?, ?, ?> ext) {
                Intrinsics.checkNotNullParameter(ext, (String)"ext");
                ((AndroidSourceSet)ext.getSourceSets().getByName("main")).getJava().srcDir(this.this$0.getPackageListDir(this.$project));
            }
        });
    }

    @NotNull
    public final Provider<Directory> getPackageListDir(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Provider provider = project.getLayout().getBuildDirectory().dir("generated/expo/src/main/java");
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"dir(...)");
        return provider;
    }

    @NotNull
    public final Provider<RegularFile> getPackageListFile(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String[] stringArray = new String[]{StringsKt.replace$default((String)"expo.modules", (char)'.', (char)'/', (boolean)false, (int)4, null), "ExpoModulesPackageList.java"};
        String packageListRelativePath = ((Object)Paths.get("generated/expo/src/main/java", stringArray)).toString();
        Provider provider = project.getLayout().getBuildDirectory().file(packageListRelativePath);
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"file(...)");
        return provider;
    }

    @NotNull
    public final TaskProvider<GeneratePackagesListTask> createGeneratePackagesListTask(@NotNull Project project, @NotNull AutolinkingOptions options, @NotNull String hash, @NotNull File projectRoot) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        Intrinsics.checkNotNullParameter((Object)projectRoot, (String)"projectRoot");
        TaskProvider taskProvider = project.getTasks().register("generatePackagesList", GeneratePackagesListTask.class, arg_0 -> ExpoAutolinkingPlugin.createGeneratePackagesListTask$lambda$5(arg_0 -> ExpoAutolinkingPlugin.createGeneratePackagesListTask$lambda$4(hash, this, project, projectRoot, options, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"register(...)");
        return taskProvider;
    }

    private final Project findAppProject(Project root) {
        Object v1;
        block1: {
            Set set = root.getAllprojects();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getAllprojects(...)");
            Iterable $this$firstOrNull$iv = set;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Project it = (Project)element$iv;
                boolean bl = false;
                if (!it.getPlugins().hasPlugin("com.android.application")) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    private final void copyAppDimensionsAndFlavorsToProject(Project project, Project appProject) {
        Object object = appProject.getExtensions().findByName("android");
        BaseExtension baseExtension = object instanceof BaseExtension ? (BaseExtension)object : null;
        if (baseExtension == null) {
            ExpoAutolinkingPlugin $this$copyAppDimensionsAndFlavorsToProject_u24lambda_u247 = this;
            boolean bl = false;
            return;
        }
        BaseExtension appAndroid = baseExtension;
        Object object2 = project.getExtensions().findByName("android");
        BaseExtension baseExtension2 = object2 instanceof BaseExtension ? (BaseExtension)object2 : null;
        if (baseExtension2 == null) {
            ExpoAutolinkingPlugin $this$copyAppDimensionsAndFlavorsToProject_u24lambda_u248 = this;
            boolean bl = false;
            return;
        }
        BaseExtension consumerAndroid = baseExtension2;
        List<String> appDimensions = this.syncFlavorDimensions(project, consumerAndroid, appAndroid);
        this.copyMissingProductFlavors(project, consumerAndroid, appAndroid, appDimensions);
    }

    private final List<String> syncFlavorDimensions(Project project, BaseExtension consumerAndroid, BaseExtension appAndroid) {
        boolean dimensionsAdded;
        List consumerDimensions;
        List appDimensions;
        block7: {
            boolean bl;
            List list;
            List it = list = appAndroid.getFlavorDimensionList();
            boolean bl2 = false;
            List list2 = !((Collection)it).isEmpty() ? list : null;
            if (list2 == null) {
                return CollectionsKt.emptyList();
            }
            appDimensions = list2;
            consumerDimensions = CollectionsKt.toMutableList((Collection)consumerAndroid.getFlavorDimensionList());
            Iterable $this$any$iv = appDimensions;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl3;
                    String dimension = (String)element$iv;
                    boolean bl4 = false;
                    if (!consumerDimensions.contains(dimension)) {
                        consumerDimensions.add(dimension);
                        bl3 = true;
                    } else {
                        bl3 = false;
                    }
                    if (!bl3) continue;
                    bl = true;
                    break block7;
                }
                bl = dimensionsAdded = false;
            }
        }
        if (dimensionsAdded) {
            Collection $this$toTypedArray$iv = consumerDimensions;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            consumerAndroid.flavorDimensions(Arrays.copyOf(stringArray, stringArray.length));
            project.getLogger().quiet("  -> Copied/merged flavorDimensions: " + CollectionsKt.joinToString$default((Iterable)consumerDimensions, null, null, null, (int)0, null, null, (int)63, null));
        }
        return appDimensions;
    }

    /*
     * WARNING - void declaration
     */
    private final void copyMissingProductFlavors(Project project, BaseExtension consumerAndroid, BaseExtension appAndroid, List<String> appDimensions) {
        Object object;
        void $this$mapTo$iv$iv;
        NamedDomainObjectContainer appFlavors = appAndroid.getProductFlavors();
        NamedDomainObjectContainer consumerFlavors = consumerAndroid.getProductFlavors();
        Iterable $this$map$iv = (Iterable)consumerFlavors;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            object = (ProductFlavor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        Set existingFlavorNames = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterable $this$forEach$iv = (Iterable)appFlavors;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ProductFlavor appFlavor = (ProductFlavor)element$iv;
            boolean bl = false;
            if (existingFlavorNames.contains(appFlavor.getName())) continue;
            String string = appFlavor.getDimension();
            if (string == null) {
                string = (String)CollectionsKt.singleOrNull(appDimensions);
            }
            String dimension = string;
            Object $this$copyMissingProductFlavors_u24lambda_u2413_u24lambda_u2412 = object = consumerFlavors.create(appFlavor.getName());
            boolean bl2 = false;
            $this$copyMissingProductFlavors_u24lambda_u2413_u24lambda_u2412.setDimension(dimension);
            project.getLogger().quiet("  -> Created flavor '" + appFlavor.getName() + "' (dimension='" + dimension + "') in :" + project.getPath());
        }
    }

    private static final Unit apply$lambda$2(Project $project, Project subproject) {
        Intrinsics.checkNotNullParameter((Object)subproject, (String)"subproject");
        $project.evaluationDependsOn(subproject.getPath());
        $project.getDependencies().add("api", (Object)subproject);
        $project.getLogger().quiet("  - " + ColorsKt.withColor((Object)subproject.getName(), (String)"\u001b[32m") + " (" + subproject.getVersion() + ")");
        return Unit.INSTANCE;
    }

    private static final Unit createGeneratePackagesListTask$lambda$4(String $hash, ExpoAutolinkingPlugin this$0, Project $project, File $projectRoot, AutolinkingOptions $options, GeneratePackagesListTask it) {
        it.getHash().set((Object)$hash);
        it.getNamespace().set((Object)"expo.modules");
        it.getOutputFile().set(this$0.getPackageListFile($project));
        it.setWorkingDir($projectRoot);
        it.getOptions().set((Object)$options.toJson());
        return Unit.INSTANCE;
    }

    private static final void createGeneratePackagesListTask$lambda$5(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

