/*
 * Decompiled with CFR 0.152.
 */
package expo.modules.plugin.gradle;

import expo.modules.plugin.configuration.AWSMavenCredentials;
import expo.modules.plugin.configuration.BasicMavenCredentials;
import expo.modules.plugin.configuration.HttpHeaderMavenCredentials;
import expo.modules.plugin.configuration.MavenCredentials;
import expo.modules.plugin.utils.Env;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.gradle.api.artifacts.repositories.AuthenticationContainer;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.artifacts.repositories.PasswordCredentials;
import org.gradle.api.credentials.AwsCredentials;
import org.gradle.api.credentials.HttpHeaderCredentials;
import org.gradle.internal.authentication.AbstractAuthentication;
import org.gradle.internal.authentication.DefaultBasicAuthentication;
import org.gradle.internal.authentication.DefaultDigestAuthentication;
import org.gradle.internal.authentication.DefaultHttpHeaderAuthentication;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0016\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u0000\u001a\u0016\u0010\u0005\u001a\u00020\u0001*\u00020\u00022\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0000\u001a\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004H\u0002\"\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"applyAuthentication", "", "Lorg/gradle/api/artifacts/repositories/MavenArtifactRepository;", "authenticationType", "", "applyCredentials", "mavenCredentials", "Lexpo/modules/plugin/configuration/MavenCredentials;", "ENV_REGEX", "Lkotlin/text/Regex;", "resolveEnvVar", "input", "expo-autolinking-settings-plugin"})
@SourceDebugExtension(value={"SMAP\nMavenArtifactRepositoryExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenArtifactRepositoryExtension.kt\nexpo/modules/plugin/gradle/MavenArtifactRepositoryExtensionKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,76:1\n1#2:77\n*E\n"})
public final class MavenArtifactRepositoryExtensionKt {
    @NotNull
    private static final Regex ENV_REGEX = new Regex("System\\.getenv\\(['\"]([A-Za-z0-9_]+)['\"]\\)");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final void applyAuthentication(@NotNull MavenArtifactRepository $this$applyAuthentication, @Nullable String authenticationType) {
        AbstractAuthentication abstractAuthentication;
        AuthenticationContainer authenticationContainer;
        block8: {
            block7: {
                Intrinsics.checkNotNullParameter((Object)$this$applyAuthentication, (String)"<this>");
                if (authenticationType == null) {
                    return;
                }
                authenticationContainer = $this$applyAuthentication.getAuthentication();
                String string = authenticationType;
                switch (string.hashCode()) {
                    case -1331913276: {
                        if (string.equals("digest")) break;
                        throw new IllegalArgumentException("Unknown authentication type: " + authenticationType);
                    }
                    case -1221270899: {
                        if (!string.equals("header")) {
                            throw new IllegalArgumentException("Unknown authentication type: " + authenticationType);
                        }
                        break block7;
                    }
                    case 93508654: {
                        if (!string.equals("basic")) throw new IllegalArgumentException("Unknown authentication type: " + authenticationType);
                        abstractAuthentication = (AbstractAuthentication)new DefaultBasicAuthentication("basic");
                        break block8;
                    }
                }
                abstractAuthentication = (AbstractAuthentication)new DefaultDigestAuthentication("digest");
                break block8;
            }
            abstractAuthentication = (AbstractAuthentication)new DefaultHttpHeaderAuthentication("header");
            break block8;
            throw new IllegalArgumentException("Unknown authentication type: " + authenticationType);
        }
        authenticationContainer.add((Object)abstractAuthentication);
    }

    public static final void applyCredentials(@NotNull MavenArtifactRepository $this$applyCredentials, @Nullable MavenCredentials mavenCredentials) {
        Intrinsics.checkNotNullParameter((Object)$this$applyCredentials, (String)"<this>");
        if (mavenCredentials == null) {
            return;
        }
        MavenCredentials mavenCredentials2 = mavenCredentials;
        if (mavenCredentials2 instanceof BasicMavenCredentials) {
            MavenCredentials mavenCredentials3 = mavenCredentials;
            String username = ((BasicMavenCredentials)mavenCredentials3).component1();
            String password = ((BasicMavenCredentials)mavenCredentials3).component2();
            $this$applyCredentials.credentials(arg_0 -> MavenArtifactRepositoryExtensionKt.applyCredentials$lambda$1(arg_0 -> MavenArtifactRepositoryExtensionKt.applyCredentials$lambda$0(username, password, arg_0), arg_0));
        } else if (mavenCredentials2 instanceof HttpHeaderMavenCredentials) {
            MavenCredentials mavenCredentials4 = mavenCredentials;
            String name = ((HttpHeaderMavenCredentials)mavenCredentials4).component1();
            String value = ((HttpHeaderMavenCredentials)mavenCredentials4).component2();
            $this$applyCredentials.credentials(HttpHeaderCredentials.class, arg_0 -> MavenArtifactRepositoryExtensionKt.applyCredentials$lambda$3(arg_0 -> MavenArtifactRepositoryExtensionKt.applyCredentials$lambda$2(name, value, arg_0), arg_0));
        } else if (mavenCredentials2 instanceof AWSMavenCredentials) {
            MavenCredentials mavenCredentials5 = mavenCredentials;
            String accessKey = ((AWSMavenCredentials)mavenCredentials5).component1();
            String secretKey = ((AWSMavenCredentials)mavenCredentials5).component2();
            String sessionToken = ((AWSMavenCredentials)mavenCredentials5).component3();
            $this$applyCredentials.credentials(AwsCredentials.class, arg_0 -> MavenArtifactRepositoryExtensionKt.applyCredentials$lambda$6(arg_0 -> MavenArtifactRepositoryExtensionKt.applyCredentials$lambda$5(accessKey, secretKey, sessionToken, arg_0), arg_0));
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private static final String resolveEnvVar(String input) {
        return ENV_REGEX.replace((CharSequence)input, MavenArtifactRepositoryExtensionKt::resolveEnvVar$lambda$7);
    }

    private static final Unit applyCredentials$lambda$0(String $username, String $password, PasswordCredentials credentials) {
        credentials.setUsername(MavenArtifactRepositoryExtensionKt.resolveEnvVar($username));
        credentials.setPassword(MavenArtifactRepositoryExtensionKt.resolveEnvVar($password));
        return Unit.INSTANCE;
    }

    private static final void applyCredentials$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit applyCredentials$lambda$2(String $name, String $value, HttpHeaderCredentials credentials) {
        credentials.setName(MavenArtifactRepositoryExtensionKt.resolveEnvVar($name));
        credentials.setValue(MavenArtifactRepositoryExtensionKt.resolveEnvVar($value));
        return Unit.INSTANCE;
    }

    private static final void applyCredentials$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit applyCredentials$lambda$5(String $accessKey, String $secretKey, String $sessionToken, AwsCredentials credentials) {
        String string;
        credentials.setAccessKey(MavenArtifactRepositoryExtensionKt.resolveEnvVar($accessKey));
        credentials.setSecretKey(MavenArtifactRepositoryExtensionKt.resolveEnvVar($secretKey));
        AwsCredentials awsCredentials = credentials;
        String string2 = $sessionToken;
        if (string2 != null) {
            void it;
            String string3 = string2;
            AwsCredentials awsCredentials2 = awsCredentials;
            boolean bl = false;
            string = MavenArtifactRepositoryExtensionKt.resolveEnvVar((String)it);
            awsCredentials = awsCredentials2;
        } else {
            string = null;
        }
        awsCredentials.setSessionToken(string);
        return Unit.INSTANCE;
    }

    private static final void applyCredentials$lambda$6(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final CharSequence resolveEnvVar$lambda$7(MatchResult match) {
        Intrinsics.checkNotNullParameter((Object)match, (String)"match");
        String name = (String)match.getGroupValues().get(1);
        String string = Env.INSTANCE.getProcessEnv(name);
        return string != null ? (CharSequence)string : (CharSequence)match.getValue();
    }
}

