/*
 * Decompiled with CFR 0.152.
 */
package expo.modules.fetch;

import android.util.Log;
import expo.modules.core.logging.LoggerUtilsKt;
import expo.modules.fetch.FetchRedirectException;
import expo.modules.fetch.FetchRequestCanceledException;
import expo.modules.fetch.NativeRequestRedirect;
import expo.modules.fetch.NativeResponse;
import expo.modules.fetch.NativeResponseInit;
import expo.modules.fetch.ResponseSink;
import expo.modules.fetch.ResponseState;
import expo.modules.kotlin.AppContext;
import expo.modules.kotlin.sharedobjects.SharedObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 F2\u00020\u00012\u00020\u0002:\u0001FB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010+\u001a\u00020,H\u0016J\u0006\u0010-\u001a\u00020,J\b\u0010.\u001a\u0004\u0018\u00010/J\u0006\u00100\u001a\u00020,J\u0006\u00101\u001a\u00020,J(\u00102\u001a\u00020,2\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u000e042\u0012\u00105\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020,0\u0016J\u0018\u00106\u001a\u00020,2\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:H\u0016J\u0018\u0010;\u001a\u00020,2\u0006\u00107\u001a\u0002082\u0006\u0010<\u001a\u00020=H\u0016J!\u0010>\u001a\u00020\u00172\u0012\u0010?\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0@\"\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010AJ\u0010\u0010B\u001a\u00020\u00192\u0006\u0010<\u001a\u00020=H\u0002J\u0010\u0010C\u001a\u00020,2\u0006\u0010D\u001a\u00020EH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR&\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e8B@BX\u0082\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R$\u0010\u0014\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00170\u0016j\u0002`\u00180\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u001a\u001a\u0004\u0018\u00010\u00192\b\u0010\r\u001a\u0004\u0018\u00010\u0019@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR.\u0010\u001f\u001a\n\u0018\u00010\u001dj\u0004\u0018\u0001`\u001e2\u000e\u0010\r\u001a\n\u0018\u00010\u001dj\u0004\u0018\u0001`\u001e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u001c\u0010\"\u001a\u0004\u0018\u00010#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u0011\u0010(\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b)\u0010*\u00a8\u0006G"}, d2={"Lexpo/modules/fetch/NativeResponse;", "Lexpo/modules/kotlin/sharedobjects/SharedObject;", "Lokhttp3/Callback;", "appContext", "Lexpo/modules/kotlin/AppContext;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lexpo/modules/kotlin/AppContext;Lkotlinx/coroutines/CoroutineScope;)V", "sink", "Lexpo/modules/fetch/ResponseSink;", "getSink", "()Lexpo/modules/fetch/ResponseSink;", "value", "Lexpo/modules/fetch/ResponseState;", "state", "getState", "()Lexpo/modules/fetch/ResponseState;", "setState", "(Lexpo/modules/fetch/ResponseState;)V", "stateChangeOnceListeners", "", "Lkotlin/Function1;", "", "Lexpo/modules/fetch/StateChangeListener;", "Lexpo/modules/fetch/NativeResponseInit;", "responseInit", "getResponseInit", "()Lexpo/modules/fetch/NativeResponseInit;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "error", "getError", "()Ljava/lang/Exception;", "redirectMode", "Lexpo/modules/fetch/NativeRequestRedirect;", "getRedirectMode", "()Lexpo/modules/fetch/NativeRequestRedirect;", "setRedirectMode", "(Lexpo/modules/fetch/NativeRequestRedirect;)V", "bodyUsed", "getBodyUsed", "()Z", "deallocate", "", "onStarted", "startStreaming", "", "cancelStreaming", "emitRequestCanceled", "waitForStates", "states", "", "callback", "onFailure", "call", "Lokhttp3/Call;", "e", "Ljava/io/IOException;", "onResponse", "response", "Lokhttp3/Response;", "isInvalidState", "validStates", "", "([Lexpo/modules/fetch/ResponseState;)Z", "createResponseInit", "pumpResponseBodyStream", "stream", "Lokio/BufferedSource;", "Companion", "expo_release"})
@SourceDebugExtension(value={"SMAP\nNativeResponse.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NativeResponse.kt\nexpo/modules/fetch/NativeResponse\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,221:1\n1#2:222\n1563#3:223\n1634#3,3:224\n*S KotlinDebug\n*F\n+ 1 NativeResponse.kt\nexpo/modules/fetch/NativeResponse\n*L\n171#1:223\n171#1:224,3\n*E\n"})
public final class NativeResponse
extends SharedObject
implements Callback {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final ResponseSink sink;
    @NotNull
    private ResponseState state;
    @NotNull
    private final List<Function1<ResponseState, Boolean>> stateChangeOnceListeners;
    @Nullable
    private NativeResponseInit responseInit;
    @Nullable
    private Exception error;
    @Nullable
    private NativeRequestRedirect redirectMode;
    private static final String TAG = NativeResponse.class.getSimpleName();

    public NativeResponse(@NotNull AppContext appContext, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)appContext, (String)"appContext");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        super(appContext);
        this.coroutineScope = coroutineScope;
        this.sink = new ResponseSink();
        this.state = ResponseState.INITIALIZED;
        this.stateChangeOnceListeners = new ArrayList();
    }

    @NotNull
    public final ResponseSink getSink() {
        return this.sink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ResponseState getState() {
        ResponseState responseState;
        NativeResponse nativeResponse = this;
        synchronized (nativeResponse) {
            boolean bl = false;
            responseState = this.state;
        }
        return responseState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setState(ResponseState value) {
        NativeResponse nativeResponse = this;
        synchronized (nativeResponse) {
            boolean bl = false;
            this.state = value;
            Unit unit = Unit.INSTANCE;
        }
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, value, null){
            int label;
            final /* synthetic */ NativeResponse this$0;
            final /* synthetic */ ResponseState $value;
            {
                this.this$0 = $receiver;
                this.$value = $value;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        CollectionsKt.removeAll((List)NativeResponse.access$getStateChangeOnceListeners$p(this.this$0), arg_0 -> state.3.invokeSuspend$lambda$0(this.$value, arg_0));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final boolean invokeSuspend$lambda$0(ResponseState $value, Function1 it) {
                return (Boolean)it.invoke((Object)((Object)$value));
            }
        }), (int)3, null);
    }

    @Nullable
    public final NativeResponseInit getResponseInit() {
        return this.responseInit;
    }

    @Nullable
    public final Exception getError() {
        return this.error;
    }

    @Nullable
    public final NativeRequestRedirect getRedirectMode() {
        return this.redirectMode;
    }

    public final void setRedirectMode(@Nullable NativeRequestRedirect nativeRequestRedirect) {
        this.redirectMode = nativeRequestRedirect;
    }

    public final boolean getBodyUsed() {
        return this.sink.getBodyUsed();
    }

    public void deallocate() {
        this.sink.finalize();
        super.deallocate();
    }

    public final void onStarted() {
        ResponseState[] responseStateArray = new ResponseState[]{ResponseState.INITIALIZED};
        if (this.isInvalidState(responseStateArray)) {
            return;
        }
        this.setState(ResponseState.STARTED);
    }

    @Nullable
    public final byte[] startStreaming() {
        ResponseState[] responseStateArray = new ResponseState[]{ResponseState.RESPONSE_RECEIVED, ResponseState.BODY_COMPLETED};
        if (this.isInvalidState(responseStateArray)) {
            return null;
        }
        if (this.getState() == ResponseState.RESPONSE_RECEIVED) {
            this.setState(ResponseState.BODY_STREAMING_STARTED);
            queuedData = this.sink.finalize();
            Object[] objectArray = new Object[]{queuedData};
            this.emit("didReceiveResponseData", objectArray);
        } else if (this.getState() == ResponseState.BODY_COMPLETED) {
            queuedData = this.sink.finalize();
            return queuedData;
        }
        return null;
    }

    public final void cancelStreaming() {
        ResponseState[] responseStateArray = new ResponseState[]{ResponseState.BODY_STREAMING_STARTED};
        if (this.isInvalidState(responseStateArray)) {
            return;
        }
        this.setState(ResponseState.BODY_STREAMING_CANCELED);
    }

    public final void emitRequestCanceled() {
        FetchRequestCanceledException error = new FetchRequestCanceledException();
        this.error = (Exception)((Object)error);
        if (this.getState() == ResponseState.BODY_STREAMING_STARTED) {
            Object[] objectArray = new Object[]{LoggerUtilsKt.localizedMessageWithCauseLocalizedMessage((Throwable)((Throwable)((Object)error)))};
            this.emit("didFailWithError", objectArray);
        }
        this.setState(ResponseState.ERROR_RECEIVED);
    }

    public final void waitForStates(@NotNull List<? extends ResponseState> states, @NotNull Function1<? super ResponseState, Unit> callback) {
        Intrinsics.checkNotNullParameter(states, (String)"states");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        if (states.contains((Object)this.getState())) {
            callback.invoke((Object)this.getState());
            return;
        }
        this.stateChangeOnceListeners.add((Function1<ResponseState, Boolean>)((Function1)arg_0 -> NativeResponse.waitForStates$lambda$2(states, callback, arg_0)));
    }

    public void onFailure(@NotNull Call call, @NotNull IOException e) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (Intrinsics.areEqual((Object)e.getMessage(), (Object)"Canceled")) {
            return;
        }
        Object[] objectArray = new ResponseState[]{ResponseState.STARTED, ResponseState.RESPONSE_RECEIVED, ResponseState.BODY_STREAMING_STARTED, ResponseState.BODY_STREAMING_CANCELED};
        if (this.isInvalidState((ResponseState[])objectArray)) {
            return;
        }
        if (this.getState() == ResponseState.BODY_STREAMING_STARTED) {
            objectArray = new Object[]{LoggerUtilsKt.localizedMessageWithCauseLocalizedMessage((Throwable)e)};
            this.emit("didFailWithError", objectArray);
        }
        this.error = e;
        this.setState(ResponseState.ERROR_RECEIVED);
        this.emit("readyForJSFinalization", new Object[0]);
    }

    public void onResponse(@NotNull Call call, @NotNull Response response) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        if (response.isRedirect() && this.redirectMode == NativeRequestRedirect.ERROR) {
            response.close();
            FetchRedirectException error = new FetchRedirectException();
            this.error = (Exception)((Object)error);
            if (this.getState() == ResponseState.BODY_STREAMING_STARTED) {
                Object[] objectArray = new Object[]{LoggerUtilsKt.localizedMessageWithCauseLocalizedMessage((Throwable)((Throwable)((Object)error)))};
                this.emit("didFailWithError", objectArray);
            }
            this.setState(ResponseState.ERROR_RECEIVED);
            this.emit("readyForJSFinalization", new Object[0]);
            return;
        }
        this.responseInit = this.createResponseInit(response);
        this.setState(ResponseState.RESPONSE_RECEIVED);
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(response, this, null){
            int label;
            final /* synthetic */ Response $response;
            final /* synthetic */ NativeResponse this$0;
            {
                this.$response = $response;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        ResponseBody responseBody = this.$response.body();
                        if (responseBody == null || (responseBody = responseBody.source()) == null) {
                            return Unit.INSTANCE;
                        }
                        ResponseBody stream = responseBody;
                        NativeResponse.access$pumpResponseBodyStream(this.this$0, (BufferedSource)stream);
                        this.$response.close();
                        if (NativeResponse.access$getState(this.this$0) == ResponseState.BODY_STREAMING_STARTED) {
                            this.this$0.emit("didComplete", new Object[0]);
                        }
                        NativeResponse.access$setState(this.this$0, ResponseState.BODY_COMPLETED);
                        this.this$0.emit("readyForJSFinalization", new Object[0]);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    private final boolean isInvalidState(ResponseState ... validStates) {
        if (ArraysKt.contains((Object[])validStates, (Object)((Object)this.getState()))) {
            return false;
        }
        String validStatesString = ArraysKt.joinToString$default((Object[])validStates, (CharSequence)",", null, null, (int)0, null, NativeResponse::isInvalidState$lambda$3, (int)30, null);
        Log.w((String)TAG, (String)("Invalid state - currentState[" + this.getState().getIntValue() + "] validStates[" + validStatesString + "]"));
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final NativeResponseInit createResponseInit(Response response) {
        void $this$mapTo$iv$iv;
        int status = response.code();
        String statusText = response.message();
        Iterable $this$map$iv = (Iterable)response.headers();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void header;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)header.getFirst(), (Object)header.getSecond()));
        }
        List headers = (List)destination$iv$iv;
        boolean redirected = response.isRedirect();
        String url = response.request().url().toString();
        return new NativeResponseInit(headers, status, statusText, url, redirected);
    }

    private final void pumpResponseBodyStream(BufferedSource stream) {
        try {
            while (!stream.exhausted()) {
                Object[] objectArray = new ResponseState[]{ResponseState.RESPONSE_RECEIVED, ResponseState.BODY_STREAMING_STARTED, ResponseState.BODY_STREAMING_CANCELED};
                if (!this.isInvalidState((ResponseState[])objectArray)) {
                    if (this.getState() == ResponseState.RESPONSE_RECEIVED) {
                        this.sink.appendBufferBody$expo_release(stream.getBuffer().readByteArray());
                        continue;
                    }
                    if (this.getState() == ResponseState.BODY_STREAMING_STARTED) {
                        objectArray = new Object[]{(ResponseState)stream.getBuffer().readByteArray()};
                        this.emit("didReceiveResponseData", objectArray);
                        continue;
                    }
                }
                break;
            }
        }
        catch (IOException e) {
            this.error = e;
            if (this.getState() == ResponseState.BODY_STREAMING_STARTED) {
                Object[] objectArray = new Object[]{LoggerUtilsKt.localizedMessageWithCauseLocalizedMessage((Throwable)e)};
                this.emit("didFailWithError", objectArray);
            }
            this.setState(ResponseState.ERROR_RECEIVED);
        }
    }

    private static final boolean waitForStates$lambda$2(List $states, Function1 $callback, ResponseState newState) {
        Intrinsics.checkNotNullParameter((Object)((Object)newState), (String)"newState");
        if ($states.contains((Object)newState)) {
            $callback.invoke((Object)newState);
            return true;
        }
        return false;
    }

    private static final CharSequence isInvalidState$lambda$3(ResponseState it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return String.valueOf(it.getIntValue());
    }

    public static final /* synthetic */ List access$getStateChangeOnceListeners$p(NativeResponse $this) {
        return $this.stateChangeOnceListeners;
    }

    public static final /* synthetic */ void access$pumpResponseBodyStream(NativeResponse $this, BufferedSource stream) {
        $this.pumpResponseBodyStream(stream);
    }

    public static final /* synthetic */ ResponseState access$getState(NativeResponse $this) {
        return $this.getState();
    }

    public static final /* synthetic */ void access$setState(NativeResponse $this, ResponseState value) {
        $this.setState(value);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lexpo/modules/fetch/NativeResponse$Companion;", "", "<init>", "()V", "TAG", "", "kotlin.jvm.PlatformType", "expo_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

