/*
 * Decompiled with CFR 0.152.
 */
package expo.modules.fetch;

import android.content.Context;
import android.content.res.AssetManager;
import expo.modules.fetch.FetchAndroidContextLostException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.net.URLConnection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\fH\u0002J\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\fR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lexpo/modules/fetch/OkHttpFileUrlInterceptor;", "Lokhttp3/Interceptor;", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "Ljava/lang/ref/WeakReference;", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "restoreFileUrl", "", "url", "Lokhttp3/HttpUrl;", "createFileNotFoundResponse", "request", "Lokhttp3/Request;", "createMediaType", "Lokhttp3/MediaType;", "fileName", "createAssetResponseBody", "Lokhttp3/ResponseBody;", "Companion", "expo_release"})
public final class OkHttpFileUrlInterceptor
implements Interceptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final WeakReference<Context> context;

    public OkHttpFileUrlInterceptor(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = new WeakReference<Context>(context);
    }

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Request request = chain.request();
        String url = this.restoreFileUrl(request.url());
        if (!StringsKt.startsWith$default((String)url, (String)"file://", (boolean)false, (int)2, null)) {
            return chain.proceed(request);
        }
        if (StringsKt.startsWith$default((String)url, (String)"file:///android_asset/", (boolean)false, (int)2, null)) {
            String fileName = StringsKt.removePrefix((String)url, (CharSequence)"file:///android_asset/");
            Context context = (Context)this.context.get();
            if (context == null) {
                throw new FetchAndroidContextLostException();
            }
            Context context2 = context;
            try {
                ResponseBody responseBody = this.createAssetResponseBody(context2, fileName);
                return new Response.Builder().request(request).protocol(Protocol.HTTP_1_1).code(200).message("OK").body(responseBody).build();
            }
            catch (IOException iOException) {
                return this.createFileNotFoundResponse(request);
            }
        }
        String string = url.substring(7);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String filePath = string;
        File file = new File(filePath);
        if (!file.exists()) {
            return this.createFileNotFoundResponse(request);
        }
        BufferedSource bufferedSource = Okio.buffer((Source)Okio.source((File)file));
        String string2 = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        ResponseBody responseBody = ResponseBody.Companion.create(bufferedSource, this.createMediaType(string2), file.length());
        return new Response.Builder().request(request).protocol(Protocol.HTTP_1_1).code(200).message("OK").body(responseBody).build();
    }

    private final String restoreFileUrl(HttpUrl url) {
        String urlString = url.toString();
        return StringsKt.replaceFirst$default((String)urlString, (String)"http://filesystem.local", (String)"file://", (boolean)false, (int)4, null);
    }

    private final Response createFileNotFoundResponse(Request request) {
        return new Response.Builder().request(request).protocol(Protocol.HTTP_1_1).code(404).message("File not found").body(ResponseBody.Companion.create("File not found", MediaType.Companion.get("text/plain"))).build();
    }

    private final MediaType createMediaType(String fileName) {
        String mimeType;
        MediaType mediaType;
        String defaultType = "application/octet-stream";
        String string = URLConnection.guessContentTypeFromName(fileName);
        if (string == null) {
            string = defaultType;
        }
        if ((mediaType = MediaType.Companion.parse(mimeType = string)) == null) {
            mediaType = MediaType.Companion.get(defaultType);
        }
        return mediaType;
    }

    @NotNull
    public final ResponseBody createAssetResponseBody(@NotNull Context context, @NotNull String fileName) throws IOException {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        AssetManager assetManager = context.getAssets();
        InputStream inputStream = assetManager.open(fileName);
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"open(...)");
        InputStream inputStream2 = inputStream;
        return ResponseBody.Companion.create$default((ResponseBody.Companion)ResponseBody.Companion, (BufferedSource)Okio.buffer((Source)Okio.source((InputStream)inputStream2)), (MediaType)this.createMediaType(fileName), (long)0L, (int)2, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005\u00a8\u0006\u0007"}, d2={"Lexpo/modules/fetch/OkHttpFileUrlInterceptor$Companion;", "", "<init>", "()V", "handleFileUrl", "Ljava/net/URL;", "url", "expo_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final URL handleFileUrl(@NotNull URL url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            return Intrinsics.areEqual((Object)url.getProtocol(), (Object)"file") ? new URL("http://filesystem.local" + url.getPath()) : url;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

