/*
 * Decompiled with CFR 0.152.
 */
package com.th3rdwave.safeareacontext;

import com.facebook.react.bridge.Dynamic;
import com.facebook.react.bridge.ReadableType;
import com.facebook.react.uimanager.LayoutShadowNode;
import com.facebook.react.uimanager.NativeViewHierarchyOptimizer;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.ViewProps;
import com.facebook.react.uimanager.annotations.ReactPropGroup;
import com.th3rdwave.safeareacontext.EdgeInsets;
import com.th3rdwave.safeareacontext.SafeAreaViewEdgeModes;
import com.th3rdwave.safeareacontext.SafeAreaViewEdges;
import com.th3rdwave.safeareacontext.SafeAreaViewLocalData;
import com.th3rdwave.safeareacontext.SafeAreaViewMode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000b\u001a\u00020\fH\u0002J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000eH\u0002J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0017J\u0018\u0010!\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020 H\u0017R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/th3rdwave/safeareacontext/SafeAreaViewShadowNode;", "Lcom/facebook/react/uimanager/LayoutShadowNode;", "<init>", "()V", "mLocalData", "Lcom/th3rdwave/safeareacontext/SafeAreaViewLocalData;", "mPaddings", "", "mMargins", "mNeedsUpdate", "", "updateInsets", "", "getEdgeValue", "", "edgeMode", "Lcom/th3rdwave/safeareacontext/SafeAreaViewEdgeModes;", "insetValue", "edgeValue", "resetInsets", "mode", "Lcom/th3rdwave/safeareacontext/SafeAreaViewMode;", "onBeforeLayout", "nativeViewHierarchyOptimizer", "Lcom/facebook/react/uimanager/NativeViewHierarchyOptimizer;", "setLocalData", "data", "", "setPaddings", "index", "", "padding", "Lcom/facebook/react/bridge/Dynamic;", "setMargins", "margin", "react-native-safe-area-context_release"})
public final class SafeAreaViewShadowNode
extends LayoutShadowNode {
    @Nullable
    private SafeAreaViewLocalData mLocalData;
    @NotNull
    private final float[] mPaddings = new float[ViewProps.PADDING_MARGIN_SPACING_TYPES.length];
    @NotNull
    private final float[] mMargins = new float[ViewProps.PADDING_MARGIN_SPACING_TYPES.length];
    private boolean mNeedsUpdate;

    public SafeAreaViewShadowNode() {
        int n = ViewProps.PADDING_MARGIN_SPACING_TYPES.length;
        for (int i = 0; i < n; ++i) {
            this.mPaddings[i] = Float.NaN;
            this.mMargins[i] = Float.NaN;
        }
    }

    private final void updateInsets() {
        float leftEdge;
        float bottomEdge;
        float rightEdge;
        float topEdge;
        float horizontalEdges;
        float verticalEdges;
        SafeAreaViewLocalData safeAreaViewLocalData = this.mLocalData;
        if (safeAreaViewLocalData == null) {
            return;
        }
        SafeAreaViewLocalData localData = safeAreaViewLocalData;
        float top = 0.0f;
        float right = 0.0f;
        float bottom = 0.0f;
        float left = 0.0f;
        float[] meta = localData.getMode() == SafeAreaViewMode.PADDING ? this.mPaddings : this.mMargins;
        float allEdges = meta[8];
        if (!Float.isNaN(allEdges)) {
            top = allEdges;
            right = allEdges;
            bottom = allEdges;
            left = allEdges;
        }
        if (!Float.isNaN(verticalEdges = meta[7])) {
            top = verticalEdges;
            bottom = verticalEdges;
        }
        if (!Float.isNaN(horizontalEdges = meta[6])) {
            right = horizontalEdges;
            left = horizontalEdges;
        }
        if (!Float.isNaN(topEdge = meta[1])) {
            top = topEdge;
        }
        if (!Float.isNaN(rightEdge = meta[2])) {
            right = rightEdge;
        }
        if (!Float.isNaN(bottomEdge = meta[3])) {
            bottom = bottomEdge;
        }
        if (!Float.isNaN(leftEdge = meta[0])) {
            left = leftEdge;
        }
        top = PixelUtil.toPixelFromDIP((float)top);
        right = PixelUtil.toPixelFromDIP((float)right);
        bottom = PixelUtil.toPixelFromDIP((float)bottom);
        left = PixelUtil.toPixelFromDIP((float)left);
        SafeAreaViewEdges edges = localData.getEdges();
        EdgeInsets insets = localData.getInsets();
        if (localData.getMode() == SafeAreaViewMode.PADDING) {
            super.setPadding(1, this.getEdgeValue(edges.getTop(), insets.getTop(), top));
            super.setPadding(2, this.getEdgeValue(edges.getRight(), insets.getRight(), right));
            super.setPadding(3, this.getEdgeValue(edges.getBottom(), insets.getBottom(), bottom));
            super.setPadding(0, this.getEdgeValue(edges.getLeft(), insets.getLeft(), left));
        } else {
            super.setMargin(1, this.getEdgeValue(edges.getTop(), insets.getTop(), top));
            super.setMargin(2, this.getEdgeValue(edges.getRight(), insets.getRight(), right));
            super.setMargin(3, this.getEdgeValue(edges.getBottom(), insets.getBottom(), bottom));
            super.setMargin(0, this.getEdgeValue(edges.getLeft(), insets.getLeft(), left));
        }
    }

    private final float getEdgeValue(SafeAreaViewEdgeModes edgeMode, float insetValue, float edgeValue) {
        if (edgeMode == SafeAreaViewEdgeModes.OFF) {
            return edgeValue;
        }
        if (edgeMode == SafeAreaViewEdgeModes.MAXIMUM) {
            return Math.max(insetValue, edgeValue);
        }
        return insetValue + edgeValue;
    }

    private final void resetInsets(SafeAreaViewMode mode) {
        if (mode == SafeAreaViewMode.PADDING) {
            super.setPadding(1, this.mPaddings[1]);
            super.setPadding(2, this.mPaddings[2]);
            super.setPadding(3, this.mPaddings[3]);
            super.setPadding(0, this.mPaddings[0]);
        } else {
            super.setMargin(1, this.mMargins[1]);
            super.setMargin(2, this.mMargins[2]);
            super.setMargin(3, this.mMargins[3]);
            super.setMargin(0, this.mMargins[0]);
        }
        this.markUpdated();
    }

    public void onBeforeLayout(@NotNull NativeViewHierarchyOptimizer nativeViewHierarchyOptimizer) {
        Intrinsics.checkNotNullParameter((Object)nativeViewHierarchyOptimizer, (String)"nativeViewHierarchyOptimizer");
        if (this.mNeedsUpdate) {
            this.mNeedsUpdate = false;
            this.updateInsets();
        }
    }

    public void setLocalData(@NotNull Object data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (!(data instanceof SafeAreaViewLocalData)) {
            return;
        }
        SafeAreaViewLocalData localData = this.mLocalData;
        if (localData != null && localData.getMode() != ((SafeAreaViewLocalData)data).getMode()) {
            this.resetInsets(localData.getMode());
        }
        this.mLocalData = (SafeAreaViewLocalData)data;
        this.mNeedsUpdate = false;
        this.updateInsets();
    }

    @ReactPropGroup(names={"padding", "paddingVertical", "paddingHorizontal", "paddingStart", "paddingEnd", "paddingTop", "paddingBottom", "paddingLeft", "paddingRight"})
    public void setPaddings(int index, @NotNull Dynamic padding) {
        Intrinsics.checkNotNullParameter((Object)padding, (String)"padding");
        int spacingType = ViewProps.PADDING_MARGIN_SPACING_TYPES[index];
        this.mPaddings[spacingType] = padding.getType() == ReadableType.Number ? (float)padding.asDouble() : Float.NaN;
        super.setPaddings(index, padding);
        this.mNeedsUpdate = true;
    }

    @ReactPropGroup(names={"margin", "marginVertical", "marginHorizontal", "marginStart", "marginEnd", "marginTop", "marginBottom", "marginLeft", "marginRight"})
    public void setMargins(int index, @NotNull Dynamic margin) {
        Intrinsics.checkNotNullParameter((Object)margin, (String)"margin");
        int spacingType = ViewProps.PADDING_MARGIN_SPACING_TYPES[index];
        this.mMargins[spacingType] = margin.getType() == ReadableType.Number ? (float)margin.asDouble() : Float.NaN;
        super.setMargins(index, margin);
        this.mNeedsUpdate = true;
    }
}

