/*
 * Decompiled with CFR 0.152.
 */
package com.th3rdwave.safeareacontext;

import android.app.Activity;
import android.view.View;
import android.view.ViewGroup;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.module.annotations.ReactModule;
import com.th3rdwave.safeareacontext.EdgeInsets;
import com.th3rdwave.safeareacontext.NativeSafeAreaContextSpec;
import com.th3rdwave.safeareacontext.Rect;
import com.th3rdwave.safeareacontext.SafeAreaUtilsKt;
import com.th3rdwave.safeareacontext.SerializationUtilsKt;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ReactModule(name="RNCSafeAreaContext")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0007\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\n0\tH\u0016J\u0016\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n\u0018\u00010\tH\u0002\u00a8\u0006\r"}, d2={"Lcom/th3rdwave/safeareacontext/SafeAreaContextModule;", "Lcom/th3rdwave/safeareacontext/NativeSafeAreaContextSpec;", "reactContext", "Lcom/facebook/react/bridge/ReactApplicationContext;", "<init>", "(Lcom/facebook/react/bridge/ReactApplicationContext;)V", "getName", "", "getTypedExportedConstants", "", "", "getInitialWindowMetrics", "Companion", "react-native-safe-area-context_release"})
public final class SafeAreaContextModule
extends NativeSafeAreaContextSpec {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME = "RNCSafeAreaContext";

    public SafeAreaContextModule(@Nullable ReactApplicationContext reactContext) {
        super(reactContext);
    }

    @Override
    @NotNull
    public String getName() {
        return NAME;
    }

    @Override
    @NotNull
    public Map<String, Object> getTypedExportedConstants() {
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)"initialWindowMetrics", this.getInitialWindowMetrics()));
    }

    private final Map<String, Object> getInitialWindowMetrics() {
        Map map;
        Activity activity = this.getReactApplicationContext().getCurrentActivity();
        ViewGroup decorView = (ViewGroup)(activity != null && (activity = activity.getWindow()) != null ? activity.getDecorView() : null);
        ViewGroup viewGroup = decorView;
        if (viewGroup == null || (viewGroup = viewGroup.findViewById(0x1020002)) == null) {
            return null;
        }
        ViewGroup contentView = viewGroup;
        EdgeInsets insets = SafeAreaUtilsKt.getSafeAreaInsets((View)decorView);
        Rect frame = SafeAreaUtilsKt.getFrame(decorView, (View)contentView);
        if (insets == null || frame == null) {
            map = null;
        } else {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"insets", SerializationUtilsKt.edgeInsetsToJavaMap(insets)), TuplesKt.to((Object)"frame", SerializationUtilsKt.rectToJavaMap(frame))};
            map = MapsKt.mapOf((Pair[])pairArray);
        }
        return map;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/th3rdwave/safeareacontext/SafeAreaContextModule$Companion;", "", "<init>", "()V", "NAME", "", "react-native-safe-area-context_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

