/*
 * Decompiled with CFR 0.152.
 */
package com.th3rdwave.safeareacontext;

import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowInsets;
import androidx.annotation.RequiresApi;
import com.th3rdwave.safeareacontext.EdgeInsets;
import com.th3rdwave.safeareacontext.Rect;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0003\u001a\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0003\u001a\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u00012\u0006\u0010\b\u001a\u00020\u0003\u001a\u0018\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0002\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u0003\u00a8\u0006\f"}, d2={"getRootWindowInsetsCompatR", "Lcom/th3rdwave/safeareacontext/EdgeInsets;", "rootView", "Landroid/view/View;", "getRootWindowInsetsCompatM", "getRootWindowInsetsCompatBase", "getRootWindowInsetsCompat", "getSafeAreaInsets", "view", "getFrame", "Lcom/th3rdwave/safeareacontext/Rect;", "Landroid/view/ViewGroup;", "react-native-safe-area-context_release"})
public final class SafeAreaUtilsKt {
    @RequiresApi(value=30)
    private static final EdgeInsets getRootWindowInsetsCompatR(View rootView) {
        WindowInsets windowInsets = rootView.getRootWindowInsets();
        if (windowInsets == null || (windowInsets = windowInsets.getInsets(WindowInsets.Type.statusBars() | WindowInsets.Type.displayCutout() | WindowInsets.Type.navigationBars() | WindowInsets.Type.captionBar())) == null) {
            return null;
        }
        WindowInsets insets = windowInsets;
        return new EdgeInsets(insets.top, insets.right, insets.bottom, insets.left);
    }

    @RequiresApi(value=23)
    private static final EdgeInsets getRootWindowInsetsCompatM(View rootView) {
        WindowInsets windowInsets = rootView.getRootWindowInsets();
        if (windowInsets == null) {
            return null;
        }
        WindowInsets insets = windowInsets;
        return new EdgeInsets(insets.getSystemWindowInsetTop(), insets.getSystemWindowInsetRight(), Math.min(insets.getSystemWindowInsetBottom(), insets.getStableInsetBottom()), insets.getSystemWindowInsetLeft());
    }

    private static final EdgeInsets getRootWindowInsetsCompatBase(View rootView) {
        android.graphics.Rect visibleRect = new android.graphics.Rect();
        rootView.getWindowVisibleDisplayFrame(visibleRect);
        return new EdgeInsets(visibleRect.top, rootView.getWidth() - visibleRect.right, rootView.getHeight() - visibleRect.bottom, visibleRect.left);
    }

    private static final EdgeInsets getRootWindowInsetsCompat(View rootView) {
        return Build.VERSION.SDK_INT >= 30 ? SafeAreaUtilsKt.getRootWindowInsetsCompatR(rootView) : (Build.VERSION.SDK_INT >= 23 ? SafeAreaUtilsKt.getRootWindowInsetsCompatM(rootView) : SafeAreaUtilsKt.getRootWindowInsetsCompatBase(rootView));
    }

    @Nullable
    public static final EdgeInsets getSafeAreaInsets(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (view.getHeight() == 0) {
            return null;
        }
        View rootView = view.getRootView();
        Intrinsics.checkNotNull((Object)rootView);
        EdgeInsets edgeInsets = SafeAreaUtilsKt.getRootWindowInsetsCompat(rootView);
        if (edgeInsets == null) {
            return null;
        }
        EdgeInsets windowInsets = edgeInsets;
        float windowWidth = rootView.getWidth();
        float windowHeight = rootView.getHeight();
        android.graphics.Rect visibleRect = new android.graphics.Rect();
        view.getGlobalVisibleRect(visibleRect);
        return new EdgeInsets(Math.max(windowInsets.getTop() - (float)visibleRect.top, 0.0f), Math.max(Math.min((float)(visibleRect.left + view.getWidth()) - windowWidth, 0.0f) + windowInsets.getRight(), 0.0f), Math.max(Math.min((float)(visibleRect.top + view.getHeight()) - windowHeight, 0.0f) + windowInsets.getBottom(), 0.0f), Math.max(windowInsets.getLeft() - (float)visibleRect.left, 0.0f));
    }

    @Nullable
    public static final Rect getFrame(@NotNull ViewGroup rootView, @NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)rootView, (String)"rootView");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (view.getParent() == null) {
            return null;
        }
        android.graphics.Rect offset = new android.graphics.Rect();
        view.getDrawingRect(offset);
        try {
            rootView.offsetDescendantRectToMyCoords(view, offset);
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
            return null;
        }
        return new Rect(offset.left, offset.top, view.getWidth(), view.getHeight());
    }
}

