/*
 * Decompiled with CFR 0.152.
 */
package com.th3rdwave.safeareacontext;

import android.content.Context;
import android.util.Log;
import android.view.View;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.uimanager.StateWrapper;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.views.view.ReactViewGroup;
import com.th3rdwave.safeareacontext.EdgeInsets;
import com.th3rdwave.safeareacontext.SafeAreaProvider;
import com.th3rdwave.safeareacontext.SafeAreaUtilsKt;
import com.th3rdwave.safeareacontext.SafeAreaViewEdgeModes;
import com.th3rdwave.safeareacontext.SafeAreaViewEdges;
import com.th3rdwave.safeareacontext.SafeAreaViewLocalData;
import com.th3rdwave.safeareacontext.SafeAreaViewMode;
import com.th3rdwave.safeareacontext.SerializationUtilsKt;
import com.th3rdwave.safeareacontext.UIManagerHelperCompatKt;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002B\u0011\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010J\u0010\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0010J\b\u0010\u0015\u001a\u00020\u0013H\u0002J\b\u0010\u0016\u001a\u00020\u0013H\u0002J\u000e\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\bJ\u000e\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\fJ\b\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u000eH\u0002J\b\u0010\u001e\u001a\u00020\u0013H\u0014J\b\u0010\u001f\u001a\u00020\u0013H\u0014J\b\u0010 \u001a\u00020\u001cH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/th3rdwave/safeareacontext/SafeAreaView;", "Lcom/facebook/react/views/view/ReactViewGroup;", "Landroid/view/ViewTreeObserver$OnPreDrawListener;", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "mMode", "Lcom/th3rdwave/safeareacontext/SafeAreaViewMode;", "mInsets", "Lcom/th3rdwave/safeareacontext/EdgeInsets;", "mEdges", "Lcom/th3rdwave/safeareacontext/SafeAreaViewEdges;", "mProviderView", "Landroid/view/View;", "mStateWrapper", "Lcom/facebook/react/uimanager/StateWrapper;", "getStateWrapper", "setStateWrapper", "", "stateWrapper", "updateInsets", "waitForReactLayout", "setMode", "mode", "setEdges", "edges", "maybeUpdateInsets", "", "findProvider", "onAttachedToWindow", "onDetachedFromWindow", "onPreDraw", "react-native-safe-area-context_release"})
public final class SafeAreaView
extends ReactViewGroup
implements ViewTreeObserver.OnPreDrawListener {
    @NotNull
    private SafeAreaViewMode mMode = SafeAreaViewMode.PADDING;
    @Nullable
    private EdgeInsets mInsets;
    @Nullable
    private SafeAreaViewEdges mEdges;
    @Nullable
    private View mProviderView;
    @Nullable
    private StateWrapper mStateWrapper;

    public SafeAreaView(@Nullable Context context) {
        super(context);
    }

    @Nullable
    public final StateWrapper getStateWrapper() {
        return this.mStateWrapper;
    }

    public final void setStateWrapper(@Nullable StateWrapper stateWrapper) {
        this.mStateWrapper = stateWrapper;
    }

    private final void updateInsets() {
        EdgeInsets insets = this.mInsets;
        if (insets != null) {
            StateWrapper stateWrapper;
            SafeAreaViewEdges edges;
            SafeAreaViewEdges safeAreaViewEdges = this.mEdges;
            if (safeAreaViewEdges == null) {
                safeAreaViewEdges = edges = new SafeAreaViewEdges(SafeAreaViewEdgeModes.ADDITIVE, SafeAreaViewEdgeModes.ADDITIVE, SafeAreaViewEdgeModes.ADDITIVE, SafeAreaViewEdgeModes.ADDITIVE);
            }
            if ((stateWrapper = this.getStateWrapper()) != null) {
                WritableMap writableMap = Arguments.createMap();
                Intrinsics.checkNotNullExpressionValue((Object)writableMap, (String)"createMap(...)");
                WritableMap map = writableMap;
                map.putMap("insets", (ReadableMap)SerializationUtilsKt.edgeInsetsToJsMap(insets));
                stateWrapper.updateState(map);
            } else {
                SafeAreaViewLocalData localData = new SafeAreaViewLocalData(insets, this.mMode, edges);
                ReactContext reactContext = UIManagerHelperCompatKt.getReactContext((View)this);
                UIManagerModule uiManager = (UIManagerModule)reactContext.getNativeModule(UIManagerModule.class);
                if (uiManager != null) {
                    uiManager.setViewLocalData(this.getId(), (Object)localData);
                    reactContext.runOnNativeModulesQueueThread(() -> SafeAreaView.updateInsets$lambda$0(uiManager));
                    this.waitForReactLayout();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void waitForReactLayout() {
        long waitTime;
        Ref.BooleanRef done = new Ref.BooleanRef();
        ReentrantLock lock = new ReentrantLock();
        Condition condition = lock.newCondition();
        long startTime = System.nanoTime();
        UIManagerHelperCompatKt.getReactContext((View)this).runOnNativeModulesQueueThread(() -> SafeAreaView.waitForReactLayout$lambda$2(lock, done, condition));
        Lock lock2 = lock;
        lock2.lock();
        try {
            boolean bl = false;
            for (waitTime = 0L; !done.element && waitTime < 500000000L; waitTime += System.nanoTime() - startTime) {
                try {
                    condition.awaitNanos(500000000L);
                    continue;
                }
                catch (InterruptedException ex) {
                    done.element = true;
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock2.unlock();
        }
        if (waitTime >= 500000000L) {
            Log.w((String)"SafeAreaView", (String)"Timed out waiting for layout.");
        }
    }

    public final void setMode(@NotNull SafeAreaViewMode mode) {
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        this.mMode = mode;
        this.updateInsets();
    }

    public final void setEdges(@NotNull SafeAreaViewEdges edges) {
        Intrinsics.checkNotNullParameter((Object)edges, (String)"edges");
        this.mEdges = edges;
        this.updateInsets();
    }

    private final boolean maybeUpdateInsets() {
        View view = this.mProviderView;
        if (view == null) {
            return false;
        }
        View providerView = view;
        EdgeInsets edgeInsets = SafeAreaUtilsKt.getSafeAreaInsets(providerView);
        if (edgeInsets == null) {
            return false;
        }
        EdgeInsets edgeInsets2 = edgeInsets;
        if (!Intrinsics.areEqual((Object)this.mInsets, (Object)edgeInsets2)) {
            this.mInsets = edgeInsets2;
            this.updateInsets();
            return true;
        }
        return false;
    }

    private final View findProvider() {
        for (ViewParent current = this.getParent(); current != null; current = current.getParent()) {
            if (!(current instanceof SafeAreaProvider)) continue;
            return (View)current;
        }
        return (View)this;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mProviderView = this.findProvider();
        View view = this.mProviderView;
        if (view != null && (view = view.getViewTreeObserver()) != null) {
            view.addOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
        }
        this.maybeUpdateInsets();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        View view = this.mProviderView;
        if (view != null && (view = view.getViewTreeObserver()) != null) {
            view.removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
        }
        this.mProviderView = null;
    }

    public boolean onPreDraw() {
        boolean didUpdate = this.maybeUpdateInsets();
        if (didUpdate) {
            this.requestLayout();
        }
        return !didUpdate;
    }

    private static final void updateInsets$lambda$0(UIManagerModule $uiManager) {
        $uiManager.getUIImplementation().dispatchViewUpdates(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void waitForReactLayout$lambda$2(ReentrantLock $lock, Ref.BooleanRef $done, Condition $condition) {
        Lock lock = $lock;
        lock.lock();
        try {
            boolean bl = false;
            if (!$done.element) {
                $done.element = true;
                $condition.signal();
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }
}

