/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.viewmanagers;

import android.content.Context;
import android.view.View;
import androidx.annotation.Nullable;
import com.facebook.react.bridge.ColorPropConverter;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.uimanager.BaseViewManager;
import com.facebook.react.uimanager.BaseViewManagerDelegate;
import com.facebook.react.uimanager.LayoutShadowNode;
import com.facebook.react.viewmanagers.RNSSearchBarManagerInterface;

public class RNSSearchBarManagerDelegate<T extends View, U extends BaseViewManager<T, ? extends LayoutShadowNode>>
extends BaseViewManagerDelegate<T, U> {
    public RNSSearchBarManagerDelegate(U viewManager) {
        super(viewManager);
    }

    public void setProperty(T view, String propName, @Nullable Object value) {
        switch (propName) {
            case "hideWhenScrolling": {
                ((RNSSearchBarManagerInterface)this.mViewManager).setHideWhenScrolling(view, value == null ? true : (Boolean)value);
                break;
            }
            case "autoCapitalize": {
                ((RNSSearchBarManagerInterface)this.mViewManager).setAutoCapitalize(view, (String)value);
                break;
            }
            case "placeholder": {
                ((RNSSearchBarManagerInterface)this.mViewManager).setPlaceholder(view, value == null ? null : (String)value);
                break;
            }
            case "placement": {
                ((RNSSearchBarManagerInterface)this.mViewManager).setPlacement(view, (String)value);
                break;
            }
            case "allowToolbarIntegration": {
                ((RNSSearchBarManagerInterface)this.mViewManager).setAllowToolbarIntegration(view, value == null ? true : (Boolean)value);
                break;
            }
            case "obscureBackground": {
                ((RNSSearchBarManagerInterface)this.mViewManager).setObscureBackground(view, value == null ? false : (Boolean)value);
                break;
            }
            case "hideNavigationBar": {
                ((RNSSearchBarManagerInterface)this.mViewManager).setHideNavigationBar(view, value == null ? false : (Boolean)value);
                break;
            }
            case "cancelButtonText": {
                ((RNSSearchBarManagerInterface)this.mViewManager).setCancelButtonText(view, value == null ? null : (String)value);
                break;
            }
            case "barTintColor": {
                ((RNSSearchBarManagerInterface)this.mViewManager).setBarTintColor(view, ColorPropConverter.getColor((Object)value, (Context)view.getContext()));
                break;
            }
            case "tintColor": {
                ((RNSSearchBarManagerInterface)this.mViewManager).setTintColor(view, ColorPropConverter.getColor((Object)value, (Context)view.getContext()));
                break;
            }
            case "textColor": {
                ((RNSSearchBarManagerInterface)this.mViewManager).setTextColor(view, ColorPropConverter.getColor((Object)value, (Context)view.getContext()));
                break;
            }
            case "disableBackButtonOverride": {
                ((RNSSearchBarManagerInterface)this.mViewManager).setDisableBackButtonOverride(view, value == null ? false : (Boolean)value);
                break;
            }
            case "inputType": {
                ((RNSSearchBarManagerInterface)this.mViewManager).setInputType(view, value == null ? null : (String)value);
                break;
            }
            case "hintTextColor": {
                ((RNSSearchBarManagerInterface)this.mViewManager).setHintTextColor(view, ColorPropConverter.getColor((Object)value, (Context)view.getContext()));
                break;
            }
            case "headerIconColor": {
                ((RNSSearchBarManagerInterface)this.mViewManager).setHeaderIconColor(view, ColorPropConverter.getColor((Object)value, (Context)view.getContext()));
                break;
            }
            case "shouldShowHintSearchIcon": {
                ((RNSSearchBarManagerInterface)this.mViewManager).setShouldShowHintSearchIcon(view, value == null ? true : (Boolean)value);
                break;
            }
            default: {
                super.setProperty(view, propName, value);
            }
        }
    }

    public void receiveCommand(T view, String commandName, ReadableArray args) {
        switch (commandName) {
            case "blur": {
                ((RNSSearchBarManagerInterface)this.mViewManager).blur(view);
                break;
            }
            case "focus": {
                ((RNSSearchBarManagerInterface)this.mViewManager).focus(view);
                break;
            }
            case "clearText": {
                ((RNSSearchBarManagerInterface)this.mViewManager).clearText(view);
                break;
            }
            case "toggleCancelButton": {
                ((RNSSearchBarManagerInterface)this.mViewManager).toggleCancelButton(view, args.getBoolean(0));
                break;
            }
            case "setText": {
                ((RNSSearchBarManagerInterface)this.mViewManager).setText(view, args.getString(0));
                break;
            }
            case "cancelSearch": {
                ((RNSSearchBarManagerInterface)this.mViewManager).cancelSearch(view);
            }
        }
    }
}

