/*
 * Decompiled with CFR 0.152.
 */
package com.swmansion.rnscreens;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.view.Choreographer;
import android.view.View;
import android.view.Window;
import android.view.WindowInsets;
import android.view.WindowManager;
import androidx.appcompat.widget.Toolbar;
import androidx.core.graphics.Insets;
import androidx.core.view.WindowInsetsCompat;
import com.facebook.react.modules.core.ReactChoreographer;
import com.facebook.react.uimanager.ThemedReactContext;
import com.swmansion.rnscreens.ScreenStackHeaderConfig;
import com.swmansion.rnscreens.utils.InsetsKtKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u000b\b\u0017\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0014\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0019H\u0016J0\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u001eH\u0014J\u0006\u0010\"\u001a\u00020\u0017J(\u0010#\u001a\u00020\u00172\u0006\u0010$\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020\u001eH\u0002J\b\u0010(\u001a\u00020\u0017H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/swmansion/rnscreens/CustomToolbar;", "Landroidx/appcompat/widget/Toolbar;", "context", "Landroid/content/Context;", "config", "Lcom/swmansion/rnscreens/ScreenStackHeaderConfig;", "<init>", "(Landroid/content/Context;Lcom/swmansion/rnscreens/ScreenStackHeaderConfig;)V", "getConfig", "()Lcom/swmansion/rnscreens/ScreenStackHeaderConfig;", "shouldAvoidDisplayCutout", "", "getShouldAvoidDisplayCutout", "()Z", "shouldApplyTopInset", "getShouldApplyTopInset", "lastInsets", "Landroidx/core/graphics/Insets;", "isForceShadowStateUpdateOnLayoutRequested", "isLayoutEnqueued", "layoutCallback", "Landroid/view/Choreographer$FrameCallback;", "requestLayout", "", "onApplyWindowInsets", "Landroid/view/WindowInsets;", "insets", "onLayout", "hasSizeChanged", "l", "", "t", "r", "b", "updateContentInsets", "applyExactPadding", "left", "top", "right", "bottom", "requestForceShadowStateUpdateOnLayout", "react-native-screens_release"})
@SuppressLint(value={"ViewConstructor"})
public class CustomToolbar
extends Toolbar {
    @NotNull
    private final ScreenStackHeaderConfig config;
    @NotNull
    private Insets lastInsets;
    private boolean isForceShadowStateUpdateOnLayoutRequested;
    private boolean isLayoutEnqueued;
    @NotNull
    private final Choreographer.FrameCallback layoutCallback;

    public CustomToolbar(@NotNull Context context, @NotNull ScreenStackHeaderConfig config) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)config), (String)"config");
        super(context);
        this.config = config;
        Insets insets = Insets.NONE;
        Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"NONE");
        this.lastInsets = insets;
        this.layoutCallback = new Choreographer.FrameCallback(this){
            final /* synthetic */ CustomToolbar this$0;
            {
                this.this$0 = $receiver;
            }

            public void doFrame(long frameTimeNanos) {
                CustomToolbar.access$setLayoutEnqueued$p(this.this$0, false);
                this.this$0.measure(View.MeasureSpec.makeMeasureSpec((int)this.this$0.getWidth(), (int)Integer.MIN_VALUE), View.MeasureSpec.makeMeasureSpec((int)this.this$0.getHeight(), (int)Integer.MIN_VALUE));
                this.this$0.layout(this.this$0.getLeft(), this.this$0.getTop(), this.this$0.getRight(), this.this$0.getBottom());
            }
        };
    }

    @NotNull
    public final ScreenStackHeaderConfig getConfig() {
        return this.config;
    }

    private final boolean getShouldAvoidDisplayCutout() {
        return this.config.isTopInsetEnabled();
    }

    private final boolean getShouldApplyTopInset() {
        return this.config.isTopInsetEnabled();
    }

    public void requestLayout() {
        WindowManager.LayoutParams layoutParams;
        Window window;
        Integer softInputMode;
        super.requestLayout();
        Context context = this.getContext();
        Intrinsics.checkNotNull((Object)context, (String)"null cannot be cast to non-null type com.facebook.react.uimanager.ThemedReactContext");
        Activity activity = ((ThemedReactContext)context).getCurrentActivity();
        Integer n = softInputMode = activity != null && (window = activity.getWindow()) != null && (layoutParams = window.getAttributes()) != null ? Integer.valueOf(layoutParams.softInputMode) : null;
        if (Build.VERSION.SDK_INT <= 29) {
            Integer n2 = softInputMode;
            int n3 = 32;
            if (n2 != null && n2 == n3 && !this.isLayoutEnqueued && this.layoutCallback != null) {
                this.isLayoutEnqueued = true;
                ReactChoreographer.Companion.getInstance().postFrameCallback(ReactChoreographer.CallbackType.NATIVE_ANIMATED_MODULE, this.layoutCallback);
            }
        }
    }

    @Nullable
    public WindowInsets onApplyWindowInsets(@Nullable WindowInsets insets) {
        WindowInsets unhandledInsets = super.onApplyWindowInsets(insets);
        WindowInsets rootWindowInsets = this.getRootWindowInsets();
        Insets cutoutInsets = InsetsKtKt.resolveInsetsOrZero$default((View)this, WindowInsetsCompat.Type.displayCutout(), rootWindowInsets, false, 4, null);
        Insets systemBarInsets = InsetsKtKt.resolveInsetsOrZero$default((View)this, WindowInsetsCompat.Type.systemBars(), rootWindowInsets, false, 4, null);
        Insets statusBarInsetsStable = InsetsKtKt.resolveInsetsOrZero((View)this, WindowInsetsCompat.Type.systemBars(), rootWindowInsets, true);
        Insets insets2 = Insets.of((int)(cutoutInsets.left + systemBarInsets.left), (int)0, (int)(cutoutInsets.right + systemBarInsets.right), (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)insets2, (String)"of(...)");
        Insets horizontalInsets = insets2;
        Insets insets3 = Insets.of((int)0, (int)Math.max(cutoutInsets.top, this.getShouldApplyTopInset() ? statusBarInsetsStable.top : 0), (int)0, (int)Math.max(cutoutInsets.bottom, 0));
        Intrinsics.checkNotNullExpressionValue((Object)insets3, (String)"of(...)");
        Insets verticalInsets = insets3;
        Insets insets4 = Insets.add((Insets)horizontalInsets, (Insets)verticalInsets);
        Intrinsics.checkNotNullExpressionValue((Object)insets4, (String)"add(...)");
        Insets newInsets = insets4;
        if (!Intrinsics.areEqual((Object)this.lastInsets, (Object)newInsets)) {
            this.lastInsets = newInsets;
            this.applyExactPadding(this.lastInsets.left, this.lastInsets.top, this.lastInsets.right, this.lastInsets.bottom);
        }
        return unhandledInsets;
    }

    protected void onLayout(boolean hasSizeChanged, int l, int t, int r, int b) {
        super.onLayout(hasSizeChanged, l, t, r, b);
        this.config.onNativeToolbarLayout(this, hasSizeChanged || this.isForceShadowStateUpdateOnLayoutRequested);
        this.isForceShadowStateUpdateOnLayoutRequested = false;
    }

    public final void updateContentInsets() {
        this.setContentInsetStartWithNavigation(this.config.getPreferredContentInsetStartWithNavigation());
        this.setContentInsetsRelative(this.config.getPreferredContentInsetStart(), this.config.getPreferredContentInsetEnd());
    }

    private final void applyExactPadding(int left, int top, int right, int bottom) {
        this.requestForceShadowStateUpdateOnLayout();
        this.setPadding(left, top, right, bottom);
    }

    private final void requestForceShadowStateUpdateOnLayout() {
        this.isForceShadowStateUpdateOnLayoutRequested = this.getShouldAvoidDisplayCutout();
    }

    public static final /* synthetic */ void access$setLayoutEnqueued$p(CustomToolbar $this, boolean bl) {
        $this.isLayoutEnqueued = bl;
    }
}

