/*
 * Decompiled with CFR 0.152.
 */
package com.swmansion.rnscreens;

import android.util.Log;
import android.view.View;
import androidx.core.view.OnApplyWindowInsetsListener;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.ReactApplicationContext;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0013H\u0016J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\b\u0010\u001a\u001a\u00020\u0017H\u0016J\b\u0010\u001b\u001a\u00020\u0017H\u0016J\b\u0010\u001c\u001a\u00020\u0017H\u0016J\u000e\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u0001J\u000e\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u0001J\u000e\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\nJ\u0006\u0010\"\u001a\u00020\u0017J\n\u0010#\u001a\u0004\u0018\u00010\nH\u0002R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00010\u0006j\b\u0012\u0004\u0012\u00020\u0001`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006$"}, d2={"Lcom/swmansion/rnscreens/InsetsObserverProxy;", "Landroidx/core/view/OnApplyWindowInsetsListener;", "Lcom/facebook/react/bridge/LifecycleEventListener;", "<init>", "()V", "listeners", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "eventSourceView", "Ljava/lang/ref/WeakReference;", "Landroid/view/View;", "hasBeenRegistered", "", "isObservingContextLifetime", "shouldForwardInsetsToView", "allowRegistration", "getAllowRegistration", "()Z", "onApplyWindowInsets", "Landroidx/core/view/WindowInsetsCompat;", "v", "insets", "registerWithContext", "", "context", "Lcom/facebook/react/bridge/ReactApplicationContext;", "onHostResume", "onHostPause", "onHostDestroy", "addOnApplyWindowInsetsListener", "listener", "removeOnApplyWindowInsetsListener", "registerOnView", "view", "unregister", "getObservedView", "react-native-screens_release"})
@SourceDebugExtension(value={"SMAP\nInsetsObserverProxy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InsetsObserverProxy.kt\ncom/swmansion/rnscreens/InsetsObserverProxy\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,105:1\n1869#2,2:106\n1#3:108\n*S KotlinDebug\n*F\n+ 1 InsetsObserverProxy.kt\ncom/swmansion/rnscreens/InsetsObserverProxy\n*L\n42#1:106,2\n*E\n"})
public final class InsetsObserverProxy
implements OnApplyWindowInsetsListener,
LifecycleEventListener {
    @NotNull
    public static final InsetsObserverProxy INSTANCE = new InsetsObserverProxy();
    @NotNull
    private static final HashSet<OnApplyWindowInsetsListener> listeners = new HashSet();
    @NotNull
    private static WeakReference<View> eventSourceView = new WeakReference<Object>(null);
    private static boolean hasBeenRegistered;
    private static boolean isObservingContextLifetime;
    private static boolean shouldForwardInsetsToView;

    private InsetsObserverProxy() {
    }

    private final boolean getAllowRegistration() {
        return !hasBeenRegistered || eventSourceView.get() == null;
    }

    @NotNull
    public WindowInsetsCompat onApplyWindowInsets(@NotNull View v, @NotNull WindowInsetsCompat insets) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        Intrinsics.checkNotNullParameter((Object)insets, (String)"insets");
        WindowInsetsCompat rollingInsets = null;
        WindowInsetsCompat windowInsetsCompat = shouldForwardInsetsToView ? ViewCompat.onApplyWindowInsets((View)v, (WindowInsetsCompat)insets) : insets;
        Intrinsics.checkNotNull((Object)windowInsetsCompat);
        rollingInsets = windowInsetsCompat;
        Iterable $this$forEach$iv = listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OnApplyWindowInsetsListener it = (OnApplyWindowInsetsListener)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it.onApplyWindowInsets(v, insets), (String)"onApplyWindowInsets(...)");
        }
        return rollingInsets;
    }

    public final void registerWithContext(@NotNull ReactApplicationContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (isObservingContextLifetime) {
            Log.w((String)"[RNScreens]", (String)"InsetObserverProxy registers on new context while it has not been invalidated on the old one. Please report this as issue at https://github.com/software-mansion/react-native-screens/issues");
        }
        isObservingContextLifetime = true;
        context.addLifecycleEventListener((LifecycleEventListener)this);
    }

    public void onHostResume() {
    }

    public void onHostPause() {
    }

    public void onHostDestroy() {
        View observedView = this.getObservedView();
        if (hasBeenRegistered && observedView != null) {
            ViewCompat.setOnApplyWindowInsetsListener((View)observedView, null);
            hasBeenRegistered = false;
            eventSourceView.clear();
        }
        isObservingContextLifetime = false;
    }

    public final void addOnApplyWindowInsetsListener(@NotNull OnApplyWindowInsetsListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        listeners.add(listener2);
    }

    public final void removeOnApplyWindowInsetsListener(@NotNull OnApplyWindowInsetsListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        listeners.remove(listener2);
    }

    public final boolean registerOnView(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (this.getAllowRegistration()) {
            ViewCompat.setOnApplyWindowInsetsListener((View)view, (OnApplyWindowInsetsListener)this);
            eventSourceView = new WeakReference<View>(view);
            hasBeenRegistered = true;
            return true;
        }
        return false;
    }

    public final void unregister() {
        block1: {
            View view;
            Object object = this.getObservedView();
            if (object == null) break block1;
            View it = view = object;
            boolean bl = false;
            object = hasBeenRegistered ? view : null;
            if (object != null) {
                it = object;
                boolean bl2 = false;
                ViewCompat.setOnApplyWindowInsetsListener((View)it, null);
            }
        }
    }

    private final View getObservedView() {
        return (View)eventSourceView.get();
    }

    static {
        shouldForwardInsetsToView = true;
    }
}

