/*
 * Decompiled with CFR 0.152.
 */
package com.swmansion.rnscreens;

import android.content.Context;
import android.content.ContextWrapper;
import android.view.Choreographer;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.inputmethod.InputMethodManager;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import com.facebook.react.ReactRootView;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.modules.core.ReactChoreographer;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.UIManagerHelper;
import com.facebook.react.uimanager.events.Event;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.swmansion.rnscreens.Screen;
import com.swmansion.rnscreens.ScreenFragment;
import com.swmansion.rnscreens.ScreenFragmentWrapper;
import com.swmansion.rnscreens.events.ScreenDismissedEvent;
import com.swmansion.rnscreens.gamma.common.FragmentProviding;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0016\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J0\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0017H\u0014J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u0014H\u0016J\u0006\u0010!\u001a\u00020\u0014J\u0010\u0010\"\u001a\u00020\b2\u0006\u0010#\u001a\u00020$H\u0014J\u0016\u0010%\u001a\u00020\u00142\u0006\u0010#\u001a\u00020$2\u0006\u0010&\u001a\u00020\u0017J\u0010\u0010'\u001a\u00020\u00142\u0006\u0010&\u001a\u00020\u0017H\u0016J\b\u0010(\u001a\u00020\u0014H\u0016J\u000e\u0010,\u001a\u00020$2\u0006\u0010&\u001a\u00020\u0017J\u000e\u0010-\u001a\u00020\b2\u0006\u0010&\u001a\u00020\u0017J\u0010\u00101\u001a\u00020\u00142\u0006\u00102\u001a\u00020\u000bH\u0002J\u0010\u00103\u001a\u00020\u000b2\u0006\u00104\u001a\u000205H\u0002J\b\u00106\u001a\u00020\u0014H\u0002J\b\u00107\u001a\u000208H\u0004J\u0018\u00109\u001a\u00020\u00142\u0006\u0010:\u001a\u0002082\u0006\u0010;\u001a\u00020<H\u0002J\u0006\u0010=\u001a\u00020\u0014J\u0006\u0010>\u001a\u00020\u0014J\u0006\u0010?\u001a\u00020\u0014J\u0018\u0010@\u001a\u00020\u00142\u0006\u0010:\u001a\u0002082\u0006\u0010;\u001a\u00020<H\u0002J\u0012\u0010A\u001a\u0004\u0018\u00010B2\u0006\u0010C\u001a\u00020\bH\u0002J\u0012\u0010D\u001a\u00020\r2\b\u0010C\u001a\u0004\u0018\u00010\bH\u0016J\b\u0010E\u001a\u00020\u0014H\u0014J\u0010\u0010F\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010G\u001a\u00020\u0014H\u0014J\u0018\u0010H\u001a\u00020\u00142\u0006\u0010I\u001a\u00020\u00172\u0006\u0010J\u001a\u00020\u0017H\u0014J\b\u0010K\u001a\u00020\u0014H\u0002J\b\u0010L\u001a\u00020\u0014H\u0004J\u0006\u0010M\u001a\u00020\u0014J\b\u0010N\u001a\u00020\u0014H\u0016J\b\u0010O\u001a\u00020\u0014H\u0014R \u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\t8\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u0004\u0018\u00010\u000b8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0011\u0010)\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u0016\u0010.\u001a\u0004\u0018\u00010$8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100\u00a8\u0006P"}, d2={"Lcom/swmansion/rnscreens/ScreenContainer;", "Landroid/view/ViewGroup;", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "screenWrappers", "Ljava/util/ArrayList;", "Lcom/swmansion/rnscreens/ScreenFragmentWrapper;", "Lkotlin/collections/ArrayList;", "fragmentManager", "Landroidx/fragment/app/FragmentManager;", "isAttached", "", "needsUpdate", "isLayoutEnqueued", "layoutCallback", "Landroid/view/Choreographer$FrameCallback;", "parentScreenWrapper", "onLayout", "", "changed", "l", "", "t", "r", "b", "removeView", "view", "Landroid/view/View;", "requestLayout", "isNested", "()Z", "onChildUpdate", "adapt", "screen", "Lcom/swmansion/rnscreens/Screen;", "addScreen", "index", "removeScreenAt", "removeAllScreens", "screenCount", "getScreenCount", "()I", "getScreenAt", "getScreenFragmentWrapperAt", "topScreen", "getTopScreen", "()Lcom/swmansion/rnscreens/Screen;", "setFragmentManager", "fm", "findFragmentManagerForReactRootView", "rootView", "Lcom/facebook/react/ReactRootView;", "setupFragmentManager", "createTransaction", "Landroidx/fragment/app/FragmentTransaction;", "attachScreen", "transaction", "fragment", "Landroidx/fragment/app/Fragment;", "attachBelowTop", "detachBelowTop", "notifyTopDetached", "detachScreen", "getActivityState", "Lcom/swmansion/rnscreens/Screen$ActivityState;", "screenFragmentWrapper", "hasScreen", "onAttachedToWindow", "removeMyFragments", "onDetachedFromWindow", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "onScreenChanged", "performUpdatesNow", "performUpdates", "onUpdate", "notifyContainerUpdate", "react-native-screens_release"})
@SourceDebugExtension(value={"SMAP\nScreenContainer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScreenContainer.kt\ncom/swmansion/rnscreens/ScreenContainer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,431:1\n295#2,2:432\n1#3:434\n37#4:435\n36#4,3:436\n*S KotlinDebug\n*F\n+ 1 ScreenContainer.kt\ncom/swmansion/rnscreens/ScreenContainer\n*L\n134#1:432,2\n389#1:435\n389#1:436,3\n*E\n"})
public class ScreenContainer
extends ViewGroup {
    @JvmField
    @NotNull
    protected final ArrayList<ScreenFragmentWrapper> screenWrappers = new ArrayList();
    @JvmField
    @Nullable
    protected FragmentManager fragmentManager;
    private boolean isAttached;
    private boolean needsUpdate;
    private boolean isLayoutEnqueued;
    @NotNull
    private final Choreographer.FrameCallback layoutCallback = new Choreographer.FrameCallback(this){
        final /* synthetic */ ScreenContainer this$0;
        {
            this.this$0 = $receiver;
        }

        public void doFrame(long frameTimeNanos) {
            ScreenContainer.access$setLayoutEnqueued$p(this.this$0, false);
            this.this$0.measure(View.MeasureSpec.makeMeasureSpec((int)this.this$0.getWidth(), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)this.this$0.getHeight(), (int)0x40000000));
            this.this$0.layout(this.this$0.getLeft(), this.this$0.getTop(), this.this$0.getRight(), this.this$0.getBottom());
        }
    };
    @Nullable
    private ScreenFragmentWrapper parentScreenWrapper;

    public ScreenContainer(@Nullable Context context) {
        super(context);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int size = this.getChildCount();
        for (int i = 0; i < size; ++i) {
            this.getChildAt(i).layout(0, 0, this.getWidth(), this.getHeight());
        }
    }

    public void removeView(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (view == this.getFocusedChild()) {
            Object object = this.getContext().getSystemService("input_method");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.view.inputmethod.InputMethodManager");
            ((InputMethodManager)object).hideSoftInputFromWindow(this.getWindowToken(), 2);
        }
        super.removeView(view);
    }

    public void requestLayout() {
        super.requestLayout();
        if (!this.isLayoutEnqueued && this.layoutCallback != null) {
            this.isLayoutEnqueued = true;
            ReactChoreographer.Companion.getInstance().postFrameCallback(ReactChoreographer.CallbackType.NATIVE_ANIMATED_MODULE, this.layoutCallback);
        }
    }

    public final boolean isNested() {
        return this.parentScreenWrapper != null;
    }

    public final void onChildUpdate() {
        this.performUpdatesNow();
    }

    @NotNull
    protected ScreenFragmentWrapper adapt(@NotNull Screen screen) {
        Intrinsics.checkNotNullParameter((Object)screen, (String)"screen");
        return new ScreenFragment(screen);
    }

    public final void addScreen(@NotNull Screen screen, int index) {
        Intrinsics.checkNotNullParameter((Object)screen, (String)"screen");
        ScreenFragmentWrapper fragment = this.adapt(screen);
        screen.setFragmentWrapper(fragment);
        this.screenWrappers.add(index, fragment);
        screen.setContainer(this);
        this.onScreenChanged();
    }

    public void removeScreenAt(int index) {
        this.screenWrappers.get(index).getScreen().setContainer(null);
        this.screenWrappers.remove(index);
        this.onScreenChanged();
    }

    public void removeAllScreens() {
        Iterator<ScreenFragmentWrapper> iterator = this.screenWrappers.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<ScreenFragmentWrapper> iterator2 = iterator;
        while (iterator2.hasNext()) {
            ScreenFragmentWrapper screenFragment;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            screenFragment.getScreen().setContainer(null);
        }
        this.screenWrappers.clear();
        this.onScreenChanged();
    }

    public final int getScreenCount() {
        return this.screenWrappers.size();
    }

    @NotNull
    public final Screen getScreenAt(int index) {
        return this.screenWrappers.get(index).getScreen();
    }

    @NotNull
    public final ScreenFragmentWrapper getScreenFragmentWrapperAt(int index) {
        ScreenFragmentWrapper screenFragmentWrapper = this.screenWrappers.get(index);
        Intrinsics.checkNotNullExpressionValue((Object)screenFragmentWrapper, (String)"get(...)");
        return screenFragmentWrapper;
    }

    @Nullable
    public Screen getTopScreen() {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = this.screenWrappers;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ScreenFragmentWrapper it = (ScreenFragmentWrapper)element$iv;
                boolean bl = false;
                if (!(this.getActivityState(it) == Screen.ActivityState.ON_TOP)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        ScreenFragmentWrapper screenFragmentWrapper = v0;
        return screenFragmentWrapper != null ? screenFragmentWrapper.getScreen() : null;
    }

    private final void setFragmentManager(FragmentManager fm) {
        this.fragmentManager = fm;
        this.performUpdatesNow();
    }

    private final FragmentManager findFragmentManagerForReactRootView(ReactRootView rootView) {
        FragmentManager fragmentManager;
        Context context = rootView.getContext();
        while (!(context instanceof FragmentActivity) && context instanceof ContextWrapper) {
            context = ((ContextWrapper)context).getBaseContext();
        }
        if (!(context instanceof FragmentActivity)) {
            boolean $i$a$-check-ScreenContainer$findFragmentManagerForReactRootView$22 = false;
            String $i$a$-check-ScreenContainer$findFragmentManagerForReactRootView$22 = "In order to use RNScreens components your app's activity need to extend ReactActivity";
            throw new IllegalStateException($i$a$-check-ScreenContainer$findFragmentManagerForReactRootView$22.toString());
        }
        if (((FragmentActivity)context).getSupportFragmentManager().getFragments().isEmpty()) {
            FragmentManager fragmentManager2 = ((FragmentActivity)context).getSupportFragmentManager();
            Intrinsics.checkNotNull((Object)fragmentManager2);
            fragmentManager = fragmentManager2;
        } else {
            FragmentManager fragmentManager3;
            try {
                fragmentManager3 = FragmentManager.findFragment((View)((View)rootView)).getChildFragmentManager();
                Intrinsics.checkNotNull((Object)fragmentManager3);
            }
            catch (IllegalStateException ex) {
                FragmentManager fragmentManager4 = ((FragmentActivity)context).getSupportFragmentManager();
                Intrinsics.checkNotNull((Object)fragmentManager4);
                fragmentManager3 = fragmentManager4;
            }
            fragmentManager = fragmentManager3;
        }
        return fragmentManager;
    }

    private final void setupFragmentManager() {
        ScreenContainer parent = null;
        parent = this;
        while (!(parent instanceof ReactRootView) && !(parent instanceof FragmentProviding) && ((ViewParent)parent).getParent() != null) {
            Intrinsics.checkNotNullExpressionValue((Object)((ViewParent)parent).getParent(), (String)"getParent(...)");
        }
        if (parent instanceof Screen) {
            Unit unit;
            ScreenFragmentWrapper screenFragmentWrapper = ((Screen)((Object)parent)).getFragmentWrapper();
            if (screenFragmentWrapper != null) {
                ScreenFragmentWrapper fragmentWrapper = screenFragmentWrapper;
                boolean bl = false;
                this.parentScreenWrapper = fragmentWrapper;
                fragmentWrapper.addChildScreenContainer(this);
                FragmentManager fragmentManager = fragmentWrapper.getFragment().getChildFragmentManager();
                Intrinsics.checkNotNullExpressionValue((Object)fragmentManager, (String)"getChildFragmentManager(...)");
                this.setFragmentManager(fragmentManager);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit == null) {
                boolean $i$a$-checkNotNull-ScreenContainer$setupFragmentManager$32 = false;
                String $i$a$-checkNotNull-ScreenContainer$setupFragmentManager$32 = "Parent Screen does not have its Fragment attached";
                throw new IllegalStateException($i$a$-checkNotNull-ScreenContainer$setupFragmentManager$32.toString());
            }
        } else if (parent instanceof FragmentProviding) {
            Fragment fragment = ((FragmentProviding)((Object)parent)).getAssociatedFragment();
            if (fragment == null) {
                boolean bl = false;
                String string = "[RNScreens] Parent " + (Object)((Object)parent) + " returned nullish fragment";
                throw new IllegalStateException(string.toString());
            }
            FragmentManager $i$a$-checkNotNull-ScreenContainer$setupFragmentManager$32 = fragment.getChildFragmentManager();
            Intrinsics.checkNotNullExpressionValue((Object)$i$a$-checkNotNull-ScreenContainer$setupFragmentManager$32, (String)"getChildFragmentManager(...)");
            FragmentManager fragmentManager = $i$a$-checkNotNull-ScreenContainer$setupFragmentManager$32;
            this.setFragmentManager(fragmentManager);
        } else {
            if (!(parent instanceof ReactRootView)) {
                boolean bl = false;
                String string = "ScreenContainer is not attached under ReactRootView";
                throw new IllegalStateException(string.toString());
            }
            this.setFragmentManager(this.findFragmentManagerForReactRootView((ReactRootView)parent));
        }
    }

    @NotNull
    protected final FragmentTransaction createTransaction() {
        FragmentManager fragmentManager = this.fragmentManager;
        if (fragmentManager == null) {
            boolean bl = false;
            String string = "fragment manager is null when creating transaction";
            throw new IllegalArgumentException(string.toString());
        }
        FragmentTransaction fragmentTransaction = fragmentManager.beginTransaction().setReorderingAllowed(true);
        Intrinsics.checkNotNullExpressionValue((Object)fragmentTransaction, (String)"setReorderingAllowed(...)");
        return fragmentTransaction;
    }

    private final void attachScreen(FragmentTransaction transaction, Fragment fragment) {
        transaction.add(this.getId(), fragment);
    }

    public final void attachBelowTop() {
        if (this.screenWrappers.size() < 2) {
            throw new RuntimeException("[RNScreens] Unable to run transition for less than 2 screens.");
        }
        FragmentTransaction transaction = this.createTransaction();
        Screen screen = this.getTopScreen();
        Intrinsics.checkNotNull((Object)screen, (String)"null cannot be cast to non-null type com.swmansion.rnscreens.Screen");
        Screen top = screen;
        Fragment fragment = top.getFragment();
        Intrinsics.checkNotNull((Object)fragment, (String)"null cannot be cast to non-null type androidx.fragment.app.Fragment");
        this.detachScreen(transaction, fragment);
        this.attachScreen(transaction, this.screenWrappers.get(this.screenWrappers.size() - 2).getFragment());
        Fragment fragment2 = top.getFragment();
        Intrinsics.checkNotNull((Object)fragment2, (String)"null cannot be cast to non-null type androidx.fragment.app.Fragment");
        this.attachScreen(transaction, fragment2);
        transaction.commitNowAllowingStateLoss();
    }

    public final void detachBelowTop() {
        if (this.screenWrappers.size() < 2) {
            throw new RuntimeException("[RNScreens] Unable to run transition for less than 2 screens.");
        }
        FragmentTransaction transaction = this.createTransaction();
        this.detachScreen(transaction, this.screenWrappers.get(this.screenWrappers.size() - 2).getFragment());
        transaction.commitNowAllowingStateLoss();
    }

    public final void notifyTopDetached() {
        Screen screen = this.getTopScreen();
        Intrinsics.checkNotNull((Object)screen, (String)"null cannot be cast to non-null type com.swmansion.rnscreens.Screen");
        Screen top = screen;
        if (this.getContext() instanceof ReactContext) {
            int surfaceId = UIManagerHelper.getSurfaceId((Context)this.getContext());
            Context context = this.getContext();
            Intrinsics.checkNotNull((Object)context, (String)"null cannot be cast to non-null type com.facebook.react.bridge.ReactContext");
            EventDispatcher eventDispatcher = UIManagerHelper.getEventDispatcherForReactTag((ReactContext)((ReactContext)context), (int)top.getId());
            if (eventDispatcher != null) {
                eventDispatcher.dispatchEvent((Event)new ScreenDismissedEvent(surfaceId, top.getId()));
            }
        }
    }

    private final void detachScreen(FragmentTransaction transaction, Fragment fragment) {
        transaction.remove(fragment);
    }

    private final Screen.ActivityState getActivityState(ScreenFragmentWrapper screenFragmentWrapper) {
        return screenFragmentWrapper.getScreen().getActivityState();
    }

    public boolean hasScreen(@Nullable ScreenFragmentWrapper screenFragmentWrapper) {
        return CollectionsKt.contains((Iterable)this.screenWrappers, (Object)screenFragmentWrapper);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.isAttached = true;
        this.setupFragmentManager();
    }

    private final void removeMyFragments(FragmentManager fragmentManager) {
        FragmentTransaction fragmentTransaction = fragmentManager.beginTransaction();
        Intrinsics.checkNotNullExpressionValue((Object)fragmentTransaction, (String)"beginTransaction(...)");
        FragmentTransaction transaction = fragmentTransaction;
        boolean hasFragments = false;
        for (Fragment fragment : fragmentManager.getFragments()) {
            if (!(fragment instanceof ScreenFragment) || ((ScreenFragment)fragment).getScreen().getContainer() != this) continue;
            transaction.remove(fragment);
            hasFragments = true;
        }
        if (hasFragments) {
            transaction.commitNowAllowingStateLoss();
        }
    }

    protected void onDetachedFromWindow() {
        FragmentManager fragmentManager = this.fragmentManager;
        if (fragmentManager != null) {
            FragmentManager it = fragmentManager;
            boolean bl = false;
            if (!it.isDestroyed()) {
                this.removeMyFragments(it);
                it.executePendingTransactions();
            }
        }
        ScreenFragmentWrapper screenFragmentWrapper = this.parentScreenWrapper;
        if (screenFragmentWrapper != null) {
            screenFragmentWrapper.removeChildScreenContainer(this);
        }
        this.parentScreenWrapper = null;
        super.onDetachedFromWindow();
        this.isAttached = false;
        for (int i = this.getChildCount() - 1; -1 < i; --i) {
            this.removeViewAt(i);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            this.getChildAt(i).measure(widthMeasureSpec, heightMeasureSpec);
        }
    }

    private final void onScreenChanged() {
        this.needsUpdate = true;
        Context context = this.getContext();
        Intrinsics.checkNotNull((Object)context, (String)"null cannot be cast to non-null type com.facebook.react.uimanager.ThemedReactContext");
        ((ThemedReactContext)context).getReactApplicationContext().runOnUiQueueThread(() -> ScreenContainer.onScreenChanged$lambda$8(this));
    }

    protected final void performUpdatesNow() {
        this.needsUpdate = true;
        this.performUpdates();
    }

    public final void performUpdates() {
        block4: {
            block3: {
                if (!this.needsUpdate || !this.isAttached || this.fragmentManager == null) break block3;
                FragmentManager fragmentManager = this.fragmentManager;
                boolean bl = fragmentManager != null ? fragmentManager.isDestroyed() : false;
                if (!bl) break block4;
            }
            return;
        }
        this.needsUpdate = false;
        this.onUpdate();
        this.notifyContainerUpdate();
    }

    public void onUpdate() {
        FragmentTransaction it = this.createTransaction();
        boolean bl = false;
        FragmentManager fragmentManager = this.fragmentManager;
        if (fragmentManager == null) {
            boolean $i$a$-requireNotNull-ScreenContainer$onUpdate$1$orphaned$22 = false;
            String $i$a$-requireNotNull-ScreenContainer$onUpdate$1$orphaned$22 = "fragment manager is null when performing update in ScreenContainer";
            throw new IllegalArgumentException($i$a$-requireNotNull-ScreenContainer$onUpdate$1$orphaned$22.toString());
        }
        Collection collection = fragmentManager.getFragments();
        Set orphaned = new HashSet(collection);
        Iterator<ScreenFragmentWrapper> iterator = this.screenWrappers.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<ScreenFragmentWrapper> iterator2 = iterator;
        while (iterator2.hasNext()) {
            ScreenFragmentWrapper fragmentWrapper;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            if (this.getActivityState(fragmentWrapper) == Screen.ActivityState.INACTIVE && fragmentWrapper.getFragment().isAdded()) {
                this.detachScreen(it, fragmentWrapper.getFragment());
            }
            orphaned.remove(fragmentWrapper.getFragment());
        }
        if (!((Collection)orphaned).isEmpty()) {
            Collection $this$toTypedArray$iv = orphaned;
            int $i$f$toTypedArray = 0;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            for (Fragment fragment : thisCollection$iv.toArray(new Fragment[0])) {
                if (!(fragment instanceof ScreenFragment) || ((ScreenFragment)fragment).getScreen().getContainer() != null) continue;
                this.detachScreen(it, fragment);
            }
        }
        boolean transitioning = this.getTopScreen() == null;
        boolean addedBefore = false;
        ArrayList<ScreenFragmentWrapper> pendingFront = new ArrayList<ScreenFragmentWrapper>();
        Iterator<ScreenFragmentWrapper> iterator3 = this.screenWrappers.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator3, (String)"iterator(...)");
        Iterator<ScreenFragmentWrapper> iterator4 = iterator3;
        while (iterator4.hasNext()) {
            ScreenFragmentWrapper fragmentWrapper;
            Intrinsics.checkNotNullExpressionValue((Object)iterator4.next(), (String)"next(...)");
            Screen.ActivityState activityState = this.getActivityState(fragmentWrapper);
            if (activityState != Screen.ActivityState.INACTIVE && !fragmentWrapper.getFragment().isAdded()) {
                addedBefore = true;
                this.attachScreen(it, fragmentWrapper.getFragment());
            } else if (activityState != Screen.ActivityState.INACTIVE && addedBefore) {
                this.detachScreen(it, fragmentWrapper.getFragment());
                pendingFront.add(fragmentWrapper);
            }
            fragmentWrapper.getScreen().setTransitioning(transitioning);
        }
        Iterator iterator5 = pendingFront.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator5, (String)"iterator(...)");
        iterator4 = iterator5;
        while (iterator4.hasNext()) {
            ScreenFragmentWrapper screenFragment;
            Intrinsics.checkNotNullExpressionValue((Object)iterator4.next(), (String)"next(...)");
            this.attachScreen(it, screenFragment.getFragment());
        }
        it.commitNowAllowingStateLoss();
    }

    protected void notifyContainerUpdate() {
        block0: {
            Object object = this.getTopScreen();
            if (object == null || (object = ((Screen)object).getFragmentWrapper()) == null) break block0;
            object.onContainerUpdate();
        }
    }

    private static final void onScreenChanged$lambda$8(ScreenContainer this$0) {
        this$0.performUpdates();
    }

    public static final /* synthetic */ void access$setLayoutEnqueued$p(ScreenContainer $this, boolean bl) {
        $this.isLayoutEnqueued = bl;
    }
}

