/*
 * Decompiled with CFR 0.152.
 */
package com.swmansion.rnscreens;

import android.animation.ArgbEvaluator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.app.Activity;
import android.graphics.Color;
import android.os.Build;
import android.view.View;
import android.view.ViewParent;
import android.view.Window;
import androidx.core.graphics.Insets;
import androidx.core.view.OnApplyWindowInsetsListener;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowCompat;
import androidx.core.view.WindowInsetsCompat;
import androidx.core.view.WindowInsetsControllerCompat;
import com.facebook.react.bridge.GuardedRunnable;
import com.facebook.react.bridge.JSExceptionHandler;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.UiThreadUtil;
import com.swmansion.rnscreens.InsetsObserverProxy;
import com.swmansion.rnscreens.Screen;
import com.swmansion.rnscreens.ScreenContainer;
import com.swmansion.rnscreens.ScreenWindowTraits;
import com.swmansion.rnscreens.utils.EdgeToEdgeDetector;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000I\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006*\u0001\f\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0010J\r\u0010\u0011\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0012J\r\u0010\u0013\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0014J\u001f\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0000\u00a2\u0006\u0002\b\u001aJ)\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0001\u00a2\u0006\u0002\b\u001eJ)\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0000\u00a2\u0006\u0002\b J)\u0010!\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0001\u00a2\u0006\u0002\b\"J\u001f\u0010#\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0000\u00a2\u0006\u0002\b$J\u001f\u0010%\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0001\u00a2\u0006\u0002\b&J\u001f\u0010'\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0001\u00a2\u0006\u0002\b(J\u001f\u0010)\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0000\u00a2\u0006\u0002\b*J)\u0010+\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0000\u00a2\u0006\u0002\b,J\u001a\u0010-\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010.\u001a\u00020/H\u0002J\u001a\u00100\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010.\u001a\u00020/H\u0002J\u001c\u00101\u001a\u0004\u0018\u00010\u00172\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010.\u001a\u00020/H\u0002J\u0018\u00102\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010.\u001a\u00020/H\u0002J\u0010\u00103\u001a\u00020\u00052\u0006\u00104\u001a\u00020\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\nR\u0010\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\r\u00a8\u00065"}, d2={"Lcom/swmansion/rnscreens/ScreenWindowTraits;", "", "<init>", "()V", "didSetOrientation", "", "didSetStatusBarAppearance", "didSetNavigationBarAppearance", "defaultStatusBarColor", "", "Ljava/lang/Integer;", "windowInsetsListener", "com/swmansion/rnscreens/ScreenWindowTraits$windowInsetsListener$1", "Lcom/swmansion/rnscreens/ScreenWindowTraits$windowInsetsListener$1;", "applyDidSetOrientation", "", "applyDidSetOrientation$react_native_screens_release", "applyDidSetStatusBarAppearance", "applyDidSetStatusBarAppearance$react_native_screens_release", "applyDidSetNavigationBarAppearance", "applyDidSetNavigationBarAppearance$react_native_screens_release", "setOrientation", "screen", "Lcom/swmansion/rnscreens/Screen;", "activity", "Landroid/app/Activity;", "setOrientation$react_native_screens_release", "setColor", "context", "Lcom/facebook/react/bridge/ReactContext;", "setColor$react_native_screens_release", "setStyle", "setStyle$react_native_screens_release", "setTranslucent", "setTranslucent$react_native_screens_release", "setHidden", "setHidden$react_native_screens_release", "setNavigationBarColor", "setNavigationBarColor$react_native_screens_release", "setNavigationBarTranslucent", "setNavigationBarTranslucent$react_native_screens_release", "setNavigationBarHidden", "setNavigationBarHidden$react_native_screens_release", "trySetWindowTraits", "trySetWindowTraits$react_native_screens_release", "findScreenForTrait", "trait", "Lcom/swmansion/rnscreens/Screen$WindowTraits;", "findParentWithTraitSet", "childScreenWithTraitSet", "checkTraitForScreen", "isColorLight", "color", "react-native-screens_release"})
public final class ScreenWindowTraits {
    @NotNull
    public static final ScreenWindowTraits INSTANCE = new ScreenWindowTraits();
    private static boolean didSetOrientation;
    private static boolean didSetStatusBarAppearance;
    private static boolean didSetNavigationBarAppearance;
    @Nullable
    private static Integer defaultStatusBarColor;
    @NotNull
    private static windowInsetsListener.1 windowInsetsListener;

    private ScreenWindowTraits() {
    }

    public final void applyDidSetOrientation$react_native_screens_release() {
        didSetOrientation = true;
    }

    public final void applyDidSetStatusBarAppearance$react_native_screens_release() {
        didSetStatusBarAppearance = true;
    }

    public final void applyDidSetNavigationBarAppearance$react_native_screens_release() {
        didSetNavigationBarAppearance = true;
    }

    public final void setOrientation$react_native_screens_release(@NotNull Screen screen, @Nullable Activity activity) {
        Intrinsics.checkNotNullParameter((Object)screen, (String)"screen");
        if (activity == null) {
            return;
        }
        Screen screenForOrientation = this.findScreenForTrait(screen, Screen.WindowTraits.ORIENTATION);
        Object object = screenForOrientation;
        int orientation = object != null && (object = ((Screen)object).getScreenOrientation()) != null ? (Integer)object : -1;
        activity.setRequestedOrientation(orientation);
    }

    @Deprecated(message="For apps targeting SDK 35 or above this prop has no effect because edge-to-edge is enabled by default and the status bar is always translucent.")
    public final void setColor$react_native_screens_release(@NotNull Screen screen, @Nullable Activity activity, @Nullable ReactContext context) {
        Intrinsics.checkNotNullParameter((Object)screen, (String)"screen");
        if (activity == null || context == null) {
            return;
        }
        if (defaultStatusBarColor == null) {
            defaultStatusBarColor = activity.getWindow().getStatusBarColor();
        }
        Screen screenForColor = this.findScreenForTrait(screen, Screen.WindowTraits.COLOR);
        Screen screenForAnimated = this.findScreenForTrait(screen, Screen.WindowTraits.ANIMATED);
        Object object = screenForColor;
        if (object == null || (object = ((Screen)object).getStatusBarColor()) == null) {
            object = defaultStatusBarColor;
        }
        Object color = object;
        Object object2 = screenForAnimated;
        boolean animated = object2 != null && (object2 = ((Screen)object2).isStatusBarAnimated()) != null ? (Boolean)object2 : false;
        JSExceptionHandler jSExceptionHandler = context.getExceptionHandler();
        UiThreadUtil.runOnUiThread((Runnable)((Runnable)new GuardedRunnable(activity, (Integer)color, animated, jSExceptionHandler){
            final /* synthetic */ Activity $activity;
            final /* synthetic */ Integer $color;
            final /* synthetic */ boolean $animated;
            {
                this.$activity = $activity;
                this.$color = $color;
                this.$animated = $animated;
                Intrinsics.checkNotNull((Object)$super_call_param$1);
                super($super_call_param$1);
            }

            public void runGuarded() {
                Window window = this.$activity.getWindow();
                int curColor = window.getStatusBarColor();
                Object[] objectArray = new Object[]{curColor, this.$color};
                ValueAnimator colorAnimation = ValueAnimator.ofObject((TypeEvaluator)((TypeEvaluator)new ArgbEvaluator()), (Object[])objectArray);
                colorAnimation.addUpdateListener(arg_0 -> setColor.1.runGuarded$lambda$0(window, arg_0));
                if (this.$animated) {
                    colorAnimation.setDuration(300L).setStartDelay(0L);
                } else {
                    colorAnimation.setDuration(0L).setStartDelay(300L);
                }
                colorAnimation.start();
            }

            private static final void runGuarded$lambda$0(Window $window, ValueAnimator animator) {
                Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
                Object object = animator.getAnimatedValue();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
                $window.setStatusBarColor(((Integer)object).intValue());
            }
        }));
    }

    public final void setStyle$react_native_screens_release(@NotNull Screen screen, @Nullable Activity activity, @Nullable ReactContext context) {
        Intrinsics.checkNotNullParameter((Object)screen, (String)"screen");
        if (activity == null || context == null || Build.VERSION.SDK_INT < 23) {
            return;
        }
        Screen screenForStyle = this.findScreenForTrait(screen, Screen.WindowTraits.STYLE);
        Object object = screenForStyle;
        if (object == null || (object = ((Screen)object).getStatusBarStyle()) == null) {
            object = "light";
        }
        Object style = object;
        UiThreadUtil.runOnUiThread(() -> ScreenWindowTraits.setStyle$lambda$0(activity, (String)style));
    }

    @Deprecated(message="For apps targeting SDK 35 or above this prop has no effect because edge-to-edge is enabled by default and the status bar is always translucent.")
    public final void setTranslucent$react_native_screens_release(@NotNull Screen screen, @Nullable Activity activity, @Nullable ReactContext context) {
        Intrinsics.checkNotNullParameter((Object)screen, (String)"screen");
        if (activity == null || context == null || EdgeToEdgeDetector.INSTANCE.getENABLED()) {
            return;
        }
        Screen screenForTranslucent = this.findScreenForTrait(screen, Screen.WindowTraits.TRANSLUCENT);
        Object object = screenForTranslucent;
        boolean translucent = object != null && (object = ((Screen)object).isStatusBarTranslucent()) != null ? (Boolean)object : false;
        JSExceptionHandler jSExceptionHandler = context.getExceptionHandler();
        UiThreadUtil.runOnUiThread((Runnable)((Runnable)new GuardedRunnable(activity, translucent, jSExceptionHandler){
            final /* synthetic */ Activity $activity;
            final /* synthetic */ boolean $translucent;
            {
                this.$activity = $activity;
                this.$translucent = $translucent;
                Intrinsics.checkNotNull((Object)$super_call_param$1);
                super($super_call_param$1);
            }

            public void runGuarded() {
                View view = this.$activity.getWindow().getDecorView();
                Intrinsics.checkNotNullExpressionValue((Object)view, (String)"getDecorView(...)");
                View decorView = view;
                if (this.$translucent) {
                    InsetsObserverProxy.INSTANCE.registerOnView(decorView);
                    InsetsObserverProxy.INSTANCE.addOnApplyWindowInsetsListener(ScreenWindowTraits.access$getWindowInsetsListener$p());
                } else {
                    InsetsObserverProxy.INSTANCE.removeOnApplyWindowInsetsListener(ScreenWindowTraits.access$getWindowInsetsListener$p());
                }
                ViewCompat.requestApplyInsets((View)decorView);
            }
        }));
    }

    public final void setHidden$react_native_screens_release(@NotNull Screen screen, @Nullable Activity activity) {
        Intrinsics.checkNotNullParameter((Object)screen, (String)"screen");
        if (activity == null) {
            return;
        }
        Screen screenForHidden = this.findScreenForTrait(screen, Screen.WindowTraits.HIDDEN);
        Object object = screenForHidden;
        boolean hidden = object != null && (object = ((Screen)object).isStatusBarHidden()) != null ? (Boolean)object : false;
        Window window = activity.getWindow();
        WindowInsetsControllerCompat controller = new WindowInsetsControllerCompat(window, window.getDecorView());
        UiThreadUtil.runOnUiThread(() -> ScreenWindowTraits.setHidden$lambda$1(hidden, controller));
    }

    @Deprecated(message="For all apps targeting Android SDK 35 or above edge-to-edge is enabled by default. ")
    public final void setNavigationBarColor$react_native_screens_release(@NotNull Screen screen, @Nullable Activity activity) {
        Intrinsics.checkNotNullParameter((Object)screen, (String)"screen");
        if (activity == null) {
            return;
        }
        Window window = activity.getWindow();
        Screen screenForNavBarColor = this.findScreenForTrait(screen, Screen.WindowTraits.NAVIGATION_BAR_COLOR);
        Object object = screenForNavBarColor;
        int color = object != null && (object = ((Screen)object).getNavigationBarColor()) != null ? ((Integer)object).intValue() : window.getNavigationBarColor();
        UiThreadUtil.runOnUiThread(() -> ScreenWindowTraits.setNavigationBarColor$lambda$2(window, color));
        window.setNavigationBarColor(color);
    }

    @Deprecated(message="For all apps targeting Android SDK 35 or above edge-to-edge is enabled by default. ")
    public final void setNavigationBarTranslucent$react_native_screens_release(@NotNull Screen screen, @Nullable Activity activity) {
        Intrinsics.checkNotNullParameter((Object)screen, (String)"screen");
        if (activity == null || EdgeToEdgeDetector.INSTANCE.getENABLED()) {
            return;
        }
        Window window = activity.getWindow();
        Screen screenForNavBarTranslucent = this.findScreenForTrait(screen, Screen.WindowTraits.NAVIGATION_BAR_TRANSLUCENT);
        Object object = screenForNavBarTranslucent;
        if (object == null || (object = ((Screen)object).isNavigationBarTranslucent()) == null) {
            return;
        }
        boolean translucent = (Boolean)object;
        WindowCompat.setDecorFitsSystemWindows((Window)window, (!translucent ? 1 : 0) != 0);
    }

    public final void setNavigationBarHidden$react_native_screens_release(@NotNull Screen screen, @Nullable Activity activity) {
        boolean hidden;
        Intrinsics.checkNotNullParameter((Object)screen, (String)"screen");
        if (activity == null) {
            return;
        }
        Window window = activity.getWindow();
        Screen screenForNavBarHidden = this.findScreenForTrait(screen, Screen.WindowTraits.NAVIGATION_BAR_HIDDEN);
        Object object = screenForNavBarHidden;
        boolean bl = object != null && (object = ((Screen)object).isNavigationBarHidden()) != null ? (Boolean)object : (hidden = false);
        if (hidden) {
            WindowInsetsControllerCompat controller = new WindowInsetsControllerCompat(window, window.getDecorView());
            boolean bl2 = false;
            controller.hide(WindowInsetsCompat.Type.navigationBars());
            controller.setSystemBarsBehavior(2);
        } else {
            new WindowInsetsControllerCompat(window, window.getDecorView()).show(WindowInsetsCompat.Type.navigationBars());
        }
    }

    public final void trySetWindowTraits$react_native_screens_release(@NotNull Screen screen, @Nullable Activity activity, @Nullable ReactContext context) {
        Intrinsics.checkNotNullParameter((Object)screen, (String)"screen");
        if (didSetOrientation) {
            this.setOrientation$react_native_screens_release(screen, activity);
        }
        if (didSetStatusBarAppearance) {
            this.setColor$react_native_screens_release(screen, activity, context);
            this.setStyle$react_native_screens_release(screen, activity, context);
            this.setTranslucent$react_native_screens_release(screen, activity, context);
            this.setHidden$react_native_screens_release(screen, activity);
        }
        if (didSetNavigationBarAppearance) {
            this.setNavigationBarColor$react_native_screens_release(screen, activity);
            this.setNavigationBarTranslucent$react_native_screens_release(screen, activity);
            this.setNavigationBarHidden$react_native_screens_release(screen, activity);
        }
    }

    private final Screen findScreenForTrait(Screen screen, Screen.WindowTraits trait) {
        Screen childWithTrait = this.childScreenWithTraitSet(screen, trait);
        if (childWithTrait != null) {
            return childWithTrait;
        }
        return this.checkTraitForScreen(screen, trait) ? screen : this.findParentWithTraitSet(screen, trait);
    }

    private final Screen findParentWithTraitSet(Screen screen, Screen.WindowTraits trait) {
        for (ViewParent parent = (ViewParent)screen.getContainer(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof Screen) || !this.checkTraitForScreen((Screen)parent, trait)) continue;
            return (Screen)parent;
        }
        return null;
    }

    private final Screen childScreenWithTraitSet(Screen screen, Screen.WindowTraits trait) {
        block2: {
            Object object = screen;
            if (object == null || (object = ((Screen)object).getFragmentWrapper()) == null) break block2;
            Object it = object;
            boolean bl = false;
            for (ScreenContainer sc : it.getChildScreenContainers()) {
                Screen topScreen = sc.getTopScreen();
                Screen child = INSTANCE.childScreenWithTraitSet(topScreen, trait);
                if (child != null) {
                    return child;
                }
                if (topScreen == null || !INSTANCE.checkTraitForScreen(topScreen, trait)) continue;
                return topScreen;
            }
        }
        return null;
    }

    private final boolean checkTraitForScreen(Screen screen, Screen.WindowTraits trait) {
        return switch (WhenMappings.$EnumSwitchMapping$0[trait.ordinal()]) {
            case 1 -> {
                if (screen.getScreenOrientation() != null) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (screen.getStatusBarColor() != null) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                if (screen.getStatusBarStyle() != null) {
                    yield true;
                }
                yield false;
            }
            case 4 -> {
                if (screen.isStatusBarTranslucent() != null) {
                    yield true;
                }
                yield false;
            }
            case 5 -> {
                if (screen.isStatusBarHidden() != null) {
                    yield true;
                }
                yield false;
            }
            case 6 -> {
                if (screen.isStatusBarAnimated() != null) {
                    yield true;
                }
                yield false;
            }
            case 7 -> {
                if (screen.getNavigationBarColor() != null) {
                    yield true;
                }
                yield false;
            }
            case 8 -> {
                if (screen.isNavigationBarTranslucent() != null) {
                    yield true;
                }
                yield false;
            }
            case 9 -> {
                if (screen.isNavigationBarHidden() != null) {
                    yield true;
                }
                yield false;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final boolean isColorLight(int color) {
        double darkness = 1.0 - (0.299 * (double)Color.red((int)color) + 0.587 * (double)Color.green((int)color) + 0.114 * (double)Color.blue((int)color)) / (double)255;
        return darkness < 0.5;
    }

    private static final void setStyle$lambda$0(Activity $activity, String $style) {
        View view = $activity.getWindow().getDecorView();
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"getDecorView(...)");
        View decorView = view;
        Window window = $activity.getWindow();
        WindowInsetsControllerCompat controller = new WindowInsetsControllerCompat(window, decorView);
        controller.setAppearanceLightStatusBars(Intrinsics.areEqual((Object)$style, (Object)"dark"));
    }

    private static final void setHidden$lambda$1(boolean $hidden, WindowInsetsControllerCompat $controller) {
        if ($hidden) {
            $controller.hide(WindowInsetsCompat.Type.statusBars());
        } else {
            $controller.show(WindowInsetsCompat.Type.statusBars());
        }
    }

    private static final void setNavigationBarColor$lambda$2(Window $window, int $color) {
        new WindowInsetsControllerCompat($window, $window.getDecorView()).setAppearanceLightNavigationBars(INSTANCE.isColorLight($color));
    }

    public static final /* synthetic */ windowInsetsListener.1 access$getWindowInsetsListener$p() {
        return windowInsetsListener;
    }

    static {
        windowInsetsListener = new OnApplyWindowInsetsListener(){

            public WindowInsetsCompat onApplyWindowInsets(View v, WindowInsetsCompat insets) {
                Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                Intrinsics.checkNotNullParameter((Object)insets, (String)"insets");
                WindowInsetsCompat windowInsetsCompat = ViewCompat.onApplyWindowInsets((View)v, (WindowInsetsCompat)insets);
                Intrinsics.checkNotNullExpressionValue((Object)windowInsetsCompat, (String)"onApplyWindowInsets(...)");
                WindowInsetsCompat defaultInsets = windowInsetsCompat;
                if (Build.VERSION.SDK_INT >= 30) {
                    Insets insets2 = defaultInsets.getInsets(WindowInsetsCompat.Type.statusBars());
                    Intrinsics.checkNotNullExpressionValue((Object)insets2, (String)"getInsets(...)");
                    Insets windowInsets = insets2;
                    WindowInsetsCompat windowInsetsCompat2 = new WindowInsetsCompat.Builder().setInsets(WindowInsetsCompat.Type.statusBars(), Insets.of((int)windowInsets.left, (int)0, (int)windowInsets.right, (int)windowInsets.bottom)).build();
                    Intrinsics.checkNotNullExpressionValue((Object)windowInsetsCompat2, (String)"build(...)");
                    return windowInsetsCompat2;
                }
                WindowInsetsCompat windowInsetsCompat3 = defaultInsets.replaceSystemWindowInsets(defaultInsets.getSystemWindowInsetLeft(), 0, defaultInsets.getSystemWindowInsetRight(), defaultInsets.getSystemWindowInsetBottom());
                Intrinsics.checkNotNullExpressionValue((Object)windowInsetsCompat3, (String)"replaceSystemWindowInsets(...)");
                return windowInsetsCompat3;
            }
        };
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Screen.WindowTraits.values().length];
            try {
                nArray[Screen.WindowTraits.ORIENTATION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Screen.WindowTraits.COLOR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Screen.WindowTraits.STYLE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Screen.WindowTraits.TRANSLUCENT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Screen.WindowTraits.HIDDEN.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Screen.WindowTraits.ANIMATED.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Screen.WindowTraits.NAVIGATION_BAR_COLOR.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Screen.WindowTraits.NAVIGATION_BAR_TRANSLUCENT.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Screen.WindowTraits.NAVIGATION_BAR_HIDDEN.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

