/*
 * Decompiled with CFR 0.152.
 */
package com.swmansion.rnscreens;

import android.content.Context;
import android.util.Log;
import android.view.View;
import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.react.bridge.JavaScriptContextHolder;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.UIManager;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.fabric.FabricUIManager;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.uimanager.UIManagerHelper;
import com.facebook.react.uimanager.events.Event;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.swmansion.rnscreens.NativeProxy;
import com.swmansion.rnscreens.NativeScreensModuleSpec;
import com.swmansion.rnscreens.ScreenFragment;
import com.swmansion.rnscreens.ScreenStack;
import com.swmansion.rnscreens.ScreenStackFragmentWrapper;
import com.swmansion.rnscreens.events.ScreenTransitionProgressEvent;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ReactModule(name="RNSModule")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u0000  2\u00020\u0001:\u0001 B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0011\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0082 J\t\u0010\u0010\u001a\u00020\rH\u0082 J\b\u0010\u0011\u001a\u00020\rH\u0016J\b\u0010\u0012\u001a\u00020\rH\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0017\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0007H\u0003\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001bH\u0003J\u001f\u0010\u001c\u001a\u00020\r2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001d\u001a\u00020\u001eH\u0003\u00a2\u0006\u0002\u0010\u001fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/swmansion/rnscreens/ScreensModule;", "Lcom/swmansion/rnscreens/NativeScreensModuleSpec;", "reactContext", "Lcom/facebook/react/bridge/ReactApplicationContext;", "<init>", "(Lcom/facebook/react/bridge/ReactApplicationContext;)V", "topScreenId", "", "isActiveTransition", "Ljava/util/concurrent/atomic/AtomicBoolean;", "proxy", "Lcom/swmansion/rnscreens/NativeProxy;", "nativeInstall", "", "jsiPtr", "", "nativeUninstall", "invalidate", "initialize", "getName", "", "startTransition", "", "reactTag", "(Ljava/lang/Integer;)[I", "updateTransition", "progress", "", "finishTransition", "canceled", "", "(Ljava/lang/Integer;Z)V", "Companion", "react-native-screens_release"})
public final class ScreensModule
extends NativeScreensModuleSpec {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ReactApplicationContext reactContext;
    private int topScreenId;
    @NotNull
    private final AtomicBoolean isActiveTransition;
    @Nullable
    private NativeProxy proxy;
    @NotNull
    public static final String NAME = "RNSModule";

    public ScreensModule(@NotNull ReactApplicationContext reactContext) {
        Intrinsics.checkNotNullParameter((Object)reactContext, (String)"reactContext");
        super(reactContext);
        this.reactContext = reactContext;
        this.topScreenId = -1;
        this.isActiveTransition = new AtomicBoolean(false);
        try {
            System.loadLibrary("rnscreens");
            JavaScriptContextHolder jsContext = this.getReactApplicationContext().getJavaScriptContextHolder();
            if (jsContext != null) {
                this.nativeInstall(jsContext.get());
            } else {
                Log.e((String)"[RNScreens]", (String)"Could not install JSI bindings.");
            }
        }
        catch (UnsatisfiedLinkError exception) {
            Log.w((String)"[RNScreens]", (String)"Could not load RNScreens module.");
        }
    }

    private final native void nativeInstall(long var1);

    private final native void nativeUninstall();

    public void invalidate() {
        super.invalidate();
        NativeProxy nativeProxy = this.proxy;
        if (nativeProxy != null) {
            nativeProxy.invalidateNative();
        }
        this.nativeUninstall();
    }

    /*
     * WARNING - void declaration
     */
    public void initialize() {
        void $this$initialize_u24lambda_u240;
        NativeProxy nativeProxy;
        super.initialize();
        UIManager uIManager = UIManagerHelper.getUIManager((ReactContext)((ReactContext)this.reactContext), (int)2);
        Intrinsics.checkNotNull((Object)uIManager, (String)"null cannot be cast to non-null type com.facebook.react.fabric.FabricUIManager");
        FabricUIManager fabricUIManager = (FabricUIManager)uIManager;
        NativeProxy nativeProxy2 = nativeProxy = new NativeProxy();
        ScreensModule screensModule = this;
        boolean bl = false;
        $this$initialize_u24lambda_u240.nativeAddMutationsListener(fabricUIManager);
        screensModule.proxy = nativeProxy;
    }

    @Override
    @NotNull
    public String getName() {
        return NAME;
    }

    @DoNotStrip
    private final int[] startTransition(Integer reactTag) {
        ArrayList<ScreenStackFragmentWrapper> fragments;
        int screensCount;
        View stack;
        UIManager uiManager;
        UiThreadUtil.assertOnUiThread();
        if (this.isActiveTransition.get() || reactTag == null) {
            int[] nArray = new int[]{-1, -1};
            return nArray;
        }
        this.topScreenId = -1;
        int[] nArray = new int[]{-1, -1};
        int[] result = nArray;
        UIManager uIManager = uiManager = UIManagerHelper.getUIManagerForReactTag((ReactContext)((ReactContext)this.reactContext), (int)reactTag);
        View view = stack = uIManager != null ? uIManager.resolveView(reactTag.intValue()) : null;
        if (stack instanceof ScreenStack && (screensCount = (fragments = ((ScreenStack)stack).getFragments()).size()) > 1) {
            this.isActiveTransition.set(true);
            ((ScreenStack)stack).attachBelowTop();
            result[0] = this.topScreenId = fragments.get(screensCount - 1).getScreen().getId();
            result[1] = fragments.get(screensCount - 2).getScreen().getId();
        }
        return result;
    }

    @DoNotStrip
    private final void updateTransition(double progress) {
        UiThreadUtil.assertOnUiThread();
        if (this.topScreenId == -1) {
            return;
        }
        float progressFloat = (float)progress;
        short coalescingKey = ScreenFragment.Companion.getCoalescingKey(progressFloat);
        EventDispatcher eventDispatcher = UIManagerHelper.getEventDispatcherForReactTag((ReactContext)((ReactContext)this.reactContext), (int)this.topScreenId);
        if (eventDispatcher != null) {
            eventDispatcher.dispatchEvent((Event)new ScreenTransitionProgressEvent(UIManagerHelper.getSurfaceId((Context)((Context)this.reactContext)), this.topScreenId, progressFloat, true, true, coalescingKey));
        }
    }

    @DoNotStrip
    private final void finishTransition(Integer reactTag, boolean canceled) {
        View stack;
        UIManager uiManager;
        UiThreadUtil.assertOnUiThread();
        if (!this.isActiveTransition.get() || reactTag == null) {
            Log.e((String)"[RNScreens]", (String)"Unable to call `finishTransition` method before transition start.");
            return;
        }
        UIManager uIManager = uiManager = UIManagerHelper.getUIManagerForReactTag((ReactContext)((ReactContext)this.reactContext), (int)reactTag);
        View view = stack = uIManager != null ? uIManager.resolveView(reactTag.intValue()) : null;
        if (stack instanceof ScreenStack) {
            if (canceled) {
                ((ScreenStack)stack).detachBelowTop();
            } else {
                ((ScreenStack)stack).notifyTopDetached();
            }
            this.isActiveTransition.set(false);
        }
        this.topScreenId = -1;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/swmansion/rnscreens/ScreensModule$Companion;", "", "<init>", "()V", "NAME", "", "react-native-screens_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

