/*
 * Decompiled with CFR 0.152.
 */
package com.swmansion.rnscreens.bottomsheet;

import android.app.Activity;
import android.content.res.Resources;
import android.graphics.Rect;
import android.os.Build;
import android.view.View;
import android.view.WindowInsets;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import androidx.core.graphics.Insets;
import androidx.core.view.OnApplyWindowInsetsListener;
import androidx.core.view.WindowInsetsCompat;
import androidx.fragment.app.Fragment;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleEventObserver;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import com.facebook.react.uimanager.ThemedReactContext;
import com.google.android.material.bottomsheet.BottomSheetBehavior;
import com.swmansion.rnscreens.InsetsObserverProxy;
import com.swmansion.rnscreens.KeyboardDidHide;
import com.swmansion.rnscreens.KeyboardNotVisible;
import com.swmansion.rnscreens.KeyboardState;
import com.swmansion.rnscreens.KeyboardVisible;
import com.swmansion.rnscreens.Screen;
import com.swmansion.rnscreens.ScreenContainer;
import com.swmansion.rnscreens.ScreenContentWrapper;
import com.swmansion.rnscreens.ScreenFooter;
import com.swmansion.rnscreens.ScreenStackFragment;
import com.swmansion.rnscreens.bottomsheet.BottomSheetBehaviorExtKt;
import com.swmansion.rnscreens.bottomsheet.SheetUtils;
import com.swmansion.rnscreens.bottomsheet.SheetUtilsKt;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 =2\u00020\u00012\u00020\u0002:\u0003;<=B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\"\u001a\u00020#H\u0002J\u0018\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020%H\u0002J\b\u0010+\u001a\u00020%H\u0002J\b\u0010,\u001a\u00020%H\u0002J\u0010\u0010-\u001a\u00020%2\u0006\u0010.\u001a\u00020\u000eH\u0002J5\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00040\u001b2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u00040\u001b2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u00101\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b2J\u0018\u00103\u001a\u0002042\u0006\u00105\u001a\u00020#2\u0006\u00106\u001a\u000204H\u0016J\u0010\u00107\u001a\u00020\n2\u0006\u00108\u001a\u00020\u000eH\u0002J\u000f\u00109\u001a\u0004\u0018\u00010\u000eH\u0002\u00a2\u0006\u0002\u0010:R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R$\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0011R\u0012\u0010\u0016\u001a\u00060\u0017R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0018\u001a\u00060\u0019R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u00a8\u0006>"}, d2={"Lcom/swmansion/rnscreens/bottomsheet/SheetDelegate;", "Landroidx/lifecycle/LifecycleEventObserver;", "Landroidx/core/view/OnApplyWindowInsetsListener;", "screen", "Lcom/swmansion/rnscreens/Screen;", "<init>", "(Lcom/swmansion/rnscreens/Screen;)V", "getScreen", "()Lcom/swmansion/rnscreens/Screen;", "isKeyboardVisible", "", "keyboardState", "Lcom/swmansion/rnscreens/KeyboardState;", "value", "", "lastStableDetentIndex", "getLastStableDetentIndex", "()I", "lastStableState", "getLastStableState$annotations", "()V", "getLastStableState", "sheetStateObserver", "Lcom/swmansion/rnscreens/bottomsheet/SheetDelegate$SheetStateObserver;", "keyboardHandlerCallback", "Lcom/swmansion/rnscreens/bottomsheet/SheetDelegate$KeyboardHandler;", "sheetBehavior", "Lcom/google/android/material/bottomsheet/BottomSheetBehavior;", "getSheetBehavior", "()Lcom/google/android/material/bottomsheet/BottomSheetBehavior;", "stackFragment", "Lcom/swmansion/rnscreens/ScreenStackFragment;", "getStackFragment", "()Lcom/swmansion/rnscreens/ScreenStackFragment;", "requireDecorView", "Landroid/view/View;", "onStateChanged", "", "source", "Landroidx/lifecycle/LifecycleOwner;", "event", "Landroidx/lifecycle/Lifecycle$Event;", "handleHostFragmentOnStart", "handleHostFragmentOnResume", "handleHostFragmentOnPause", "onSheetStateChanged", "newState", "configureBottomSheetBehaviour", "behavior", "selectedDetentIndex", "configureBottomSheetBehaviour$react_native_screens_release", "onApplyWindowInsets", "Landroidx/core/view/WindowInsetsCompat;", "v", "insets", "shouldDismissSheetInState", "state", "tryResolveContainerHeight", "()Ljava/lang/Integer;", "KeyboardHandler", "SheetStateObserver", "Companion", "react-native-screens_release"})
@SourceDebugExtension(value={"SMAP\nSheetDelegate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SheetDelegate.kt\ncom/swmansion/rnscreens/bottomsheet/SheetDelegate\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,370:1\n1#2:371\n*E\n"})
public final class SheetDelegate
implements LifecycleEventObserver,
OnApplyWindowInsetsListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Screen screen;
    private boolean isKeyboardVisible;
    @NotNull
    private KeyboardState keyboardState;
    private int lastStableDetentIndex;
    private int lastStableState;
    @NotNull
    private final SheetStateObserver sheetStateObserver;
    @NotNull
    private final KeyboardHandler keyboardHandlerCallback;
    @NotNull
    public static final String TAG = "SheetDelegate";

    public SheetDelegate(@NotNull Screen screen) {
        Intrinsics.checkNotNullParameter((Object)screen, (String)"screen");
        this.screen = screen;
        this.keyboardState = KeyboardNotVisible.INSTANCE;
        this.lastStableDetentIndex = this.screen.getSheetInitialDetentIndex();
        this.lastStableState = SheetUtils.INSTANCE.sheetStateFromDetentIndex(this.screen.getSheetInitialDetentIndex(), ((Collection)this.screen.getSheetDetents()).size());
        this.sheetStateObserver = new SheetStateObserver();
        this.keyboardHandlerCallback = new KeyboardHandler();
        boolean bl = this.screen.getFragment() instanceof ScreenStackFragment;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-SheetDelegate$22 = false;
            String $i$a$-assert-SheetDelegate$22 = "[RNScreens] Sheets are supported only in native stack";
            throw new AssertionError((Object)$i$a$-assert-SheetDelegate$22);
        }
        Fragment fragment = this.screen.getFragment();
        Intrinsics.checkNotNull((Object)fragment);
        fragment.getLifecycle().addObserver((LifecycleObserver)this);
        BottomSheetBehavior<Screen> bottomSheetBehavior = this.getSheetBehavior();
        if (bottomSheetBehavior == null) {
            boolean bl2 = false;
            String string = "[RNScreens] Sheet delegate accepts screen with initialized sheet behaviour only.";
            throw new IllegalStateException(string.toString());
        }
        bottomSheetBehavior.addBottomSheetCallback((BottomSheetBehavior.BottomSheetCallback)this.sheetStateObserver);
    }

    @NotNull
    public final Screen getScreen() {
        return this.screen;
    }

    public final int getLastStableDetentIndex() {
        return this.lastStableDetentIndex;
    }

    public final int getLastStableState() {
        return this.lastStableState;
    }

    public static /* synthetic */ void getLastStableState$annotations() {
    }

    private final BottomSheetBehavior<Screen> getSheetBehavior() {
        return this.screen.getSheetBehavior();
    }

    private final ScreenStackFragment getStackFragment() {
        Fragment fragment = this.screen.getFragment();
        Intrinsics.checkNotNull((Object)fragment, (String)"null cannot be cast to non-null type com.swmansion.rnscreens.ScreenStackFragment");
        return (ScreenStackFragment)fragment;
    }

    private final View requireDecorView() {
        Activity activity = this.screen.getReactContext().getCurrentActivity();
        if (activity == null) {
            boolean bl = false;
            String string = "[RNScreens] Attempt to access activity on detached context";
            throw new IllegalStateException(string.toString());
        }
        View view = activity.getWindow().getDecorView();
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"getDecorView(...)");
        return view;
    }

    public void onStateChanged(@NotNull LifecycleOwner source, @NotNull Lifecycle.Event event) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        switch (WhenMappings.$EnumSwitchMapping$0[event.ordinal()]) {
            case 1: {
                this.handleHostFragmentOnStart();
                break;
            }
            case 2: {
                this.handleHostFragmentOnResume();
                break;
            }
            case 3: {
                this.handleHostFragmentOnPause();
                break;
            }
        }
    }

    private final void handleHostFragmentOnStart() {
        InsetsObserverProxy.INSTANCE.registerOnView(this.requireDecorView());
    }

    private final void handleHostFragmentOnResume() {
        InsetsObserverProxy.INSTANCE.addOnApplyWindowInsetsListener(this);
    }

    private final void handleHostFragmentOnPause() {
        InsetsObserverProxy.INSTANCE.removeOnApplyWindowInsetsListener(this);
    }

    private final void onSheetStateChanged(int newState) {
        boolean isStable = SheetUtils.INSTANCE.isStateStable(newState);
        if (isStable) {
            this.lastStableState = newState;
            this.lastStableDetentIndex = SheetUtils.INSTANCE.detentIndexFromSheetState(newState, ((Collection)this.screen.getSheetDetents()).size());
        }
        this.screen.onSheetDetentChanged$react_native_screens_release(this.lastStableDetentIndex, isStable);
        if (this.shouldDismissSheetInState(newState)) {
            this.getStackFragment().dismissSelf$react_native_screens_release();
        }
    }

    @NotNull
    public final BottomSheetBehavior<Screen> configureBottomSheetBehaviour$react_native_screens_release(@NotNull BottomSheetBehavior<Screen> behavior, @NotNull KeyboardState keyboardState, int selectedDetentIndex) {
        BottomSheetBehavior bottomSheetBehavior;
        block22: {
            block24: {
                Object object;
                Integer containerHeight;
                block23: {
                    block21: {
                        Intrinsics.checkNotNullParameter(behavior, (String)"behavior");
                        Intrinsics.checkNotNullParameter((Object)keyboardState, (String)"keyboardState");
                        containerHeight = this.tryResolveContainerHeight();
                        if (!(containerHeight != null)) {
                            boolean $i$a$-check-SheetDelegate$configureBottomSheetBehaviour$22 = false;
                            String $i$a$-check-SheetDelegate$configureBottomSheetBehaviour$22 = "[RNScreens] Failed to find window height during bottom sheet behaviour configuration";
                            throw new IllegalStateException($i$a$-check-SheetDelegate$configureBottomSheetBehaviour$22.toString());
                        }
                        BottomSheetBehavior $this$configureBottomSheetBehaviour_u24lambda_u244 = object = behavior;
                        boolean bl = false;
                        $this$configureBottomSheetBehaviour_u24lambda_u244.setHideable(true);
                        $this$configureBottomSheetBehaviour_u24lambda_u244.setDraggable(true);
                        behavior.addBottomSheetCallback((BottomSheetBehavior.BottomSheetCallback)this.sheetStateObserver);
                        ScreenFooter screenFooter = this.screen.getFooter();
                        if (screenFooter != null) {
                            screenFooter.registerWithSheetBehavior(behavior);
                        }
                        object = keyboardState;
                        if (!(object instanceof KeyboardNotVisible)) break block21;
                        switch (((Collection)this.screen.getSheetDetents()).size()) {
                            case 1: {
                                Integer n;
                                BottomSheetBehavior bottomSheetBehavior2;
                                BottomSheetBehavior $this$configureBottomSheetBehaviour_u24lambda_u247 = bottomSheetBehavior2 = behavior;
                                boolean bl2 = false;
                                if (SheetUtilsKt.isSheetFitToContents(this.screen)) {
                                    ScreenContentWrapper screenContentWrapper = this.screen.getContentWrapper();
                                    if (screenContentWrapper != null) {
                                        ScreenContentWrapper contentWrapper = screenContentWrapper;
                                        boolean bl3 = false;
                                        Integer n2 = contentWrapper.getHeight();
                                        int it = ((Number)n2).intValue();
                                        boolean bl4 = false;
                                        n = SheetUtilsKt.isLaidOutOrHasCachedLayout((View)contentWrapper) ? n2 : null;
                                    } else {
                                        n = null;
                                    }
                                } else {
                                    n = (int)(((Number)CollectionsKt.first(this.screen.getSheetDetents())).doubleValue() * (double)containerHeight.intValue());
                                }
                                Integer height = n;
                                BottomSheetBehaviorExtKt.useSingleDetent$default($this$configureBottomSheetBehaviour_u24lambda_u247, height, false, 2, null);
                                bottomSheetBehavior = bottomSheetBehavior2;
                                break block22;
                            }
                            case 2: {
                                bottomSheetBehavior = BottomSheetBehaviorExtKt.useTwoDetents(behavior, SheetUtils.INSTANCE.sheetStateFromDetentIndex(selectedDetentIndex, ((Collection)this.screen.getSheetDetents()).size()), (int)(((Number)this.screen.getSheetDetents().get(0)).doubleValue() * (double)containerHeight.intValue()), (int)(((Number)this.screen.getSheetDetents().get(1)).doubleValue() * (double)containerHeight.intValue()));
                                break block22;
                            }
                            case 3: {
                                bottomSheetBehavior = BottomSheetBehaviorExtKt.useThreeDetents(behavior, SheetUtils.INSTANCE.sheetStateFromDetentIndex(selectedDetentIndex, ((Collection)this.screen.getSheetDetents()).size()), (int)(((Number)this.screen.getSheetDetents().get(0)).doubleValue() * (double)containerHeight.intValue()), Float.valueOf((float)(((Number)this.screen.getSheetDetents().get(1)).doubleValue() / ((Number)this.screen.getSheetDetents().get(2)).doubleValue())), (int)((1.0 - ((Number)this.screen.getSheetDetents().get(2)).doubleValue()) * (double)containerHeight.intValue()));
                                break block22;
                            }
                            default: {
                                throw new IllegalStateException("[RNScreens] Invalid detent count " + ((Collection)this.screen.getSheetDetents()).size() + ". Expected at most 3.");
                            }
                        }
                    }
                    if (!(object instanceof KeyboardVisible)) break block23;
                    switch (((Collection)this.screen.getSheetDetents()).size()) {
                        case 1: {
                            BottomSheetBehavior bottomSheetBehavior3;
                            BottomSheetBehavior $this$configureBottomSheetBehaviour_u24lambda_u248 = bottomSheetBehavior3 = behavior;
                            boolean bl = false;
                            $this$configureBottomSheetBehaviour_u24lambda_u248.addBottomSheetCallback((BottomSheetBehavior.BottomSheetCallback)this.keyboardHandlerCallback);
                            bottomSheetBehavior = bottomSheetBehavior3;
                            break block22;
                        }
                        case 2: {
                            BottomSheetBehavior bottomSheetBehavior4;
                            BottomSheetBehavior $this$configureBottomSheetBehaviour_u24lambda_u249 = bottomSheetBehavior4 = behavior;
                            boolean bl = false;
                            BottomSheetBehaviorExtKt.useTwoDetents$default($this$configureBottomSheetBehaviour_u24lambda_u249, 3, null, null, 6, null);
                            $this$configureBottomSheetBehaviour_u24lambda_u249.addBottomSheetCallback((BottomSheetBehavior.BottomSheetCallback)this.keyboardHandlerCallback);
                            bottomSheetBehavior = bottomSheetBehavior4;
                            break block22;
                        }
                        case 3: {
                            BottomSheetBehavior bottomSheetBehavior5;
                            BottomSheetBehavior $this$configureBottomSheetBehaviour_u24lambda_u2410 = bottomSheetBehavior5 = behavior;
                            boolean bl = false;
                            BottomSheetBehaviorExtKt.useThreeDetents$default($this$configureBottomSheetBehaviour_u24lambda_u2410, 3, null, null, null, 14, null);
                            $this$configureBottomSheetBehaviour_u24lambda_u2410.addBottomSheetCallback((BottomSheetBehavior.BottomSheetCallback)this.keyboardHandlerCallback);
                            bottomSheetBehavior = bottomSheetBehavior5;
                            break block22;
                        }
                        default: {
                            throw new IllegalStateException("[RNScreens] Invalid detent count " + ((Collection)this.screen.getSheetDetents()).size() + ". Expected at most 3.");
                        }
                    }
                }
                if (!(object instanceof KeyboardDidHide)) break block24;
                behavior.removeBottomSheetCallback((BottomSheetBehavior.BottomSheetCallback)this.keyboardHandlerCallback);
                switch (((Collection)this.screen.getSheetDetents()).size()) {
                    case 1: {
                        bottomSheetBehavior = BottomSheetBehaviorExtKt.useSingleDetent(behavior, (int)(((Number)CollectionsKt.first(this.screen.getSheetDetents())).doubleValue() * (double)containerHeight.intValue()), false);
                        break block22;
                    }
                    case 2: {
                        bottomSheetBehavior = BottomSheetBehaviorExtKt.useTwoDetents$default(behavior, null, (int)(((Number)this.screen.getSheetDetents().get(0)).doubleValue() * (double)containerHeight.intValue()), (int)(((Number)this.screen.getSheetDetents().get(1)).doubleValue() * (double)containerHeight.intValue()), 1, null);
                        break block22;
                    }
                    case 3: {
                        bottomSheetBehavior = BottomSheetBehaviorExtKt.useThreeDetents$default(behavior, null, (int)(((Number)this.screen.getSheetDetents().get(0)).doubleValue() * (double)containerHeight.intValue()), Float.valueOf((float)(((Number)this.screen.getSheetDetents().get(1)).doubleValue() / ((Number)this.screen.getSheetDetents().get(2)).doubleValue())), (int)((1.0 - ((Number)this.screen.getSheetDetents().get(2)).doubleValue()) * (double)containerHeight.intValue()), 1, null);
                        break block22;
                    }
                    default: {
                        throw new IllegalStateException("[RNScreens] Invalid detent count " + ((Collection)this.screen.getSheetDetents()).size() + ". Expected at most 3.");
                    }
                }
            }
            throw new NoWhenBranchMatchedException();
        }
        return bottomSheetBehavior;
    }

    public static /* synthetic */ BottomSheetBehavior configureBottomSheetBehaviour$react_native_screens_release$default(SheetDelegate sheetDelegate, BottomSheetBehavior bottomSheetBehavior, KeyboardState keyboardState, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            keyboardState = KeyboardNotVisible.INSTANCE;
        }
        if ((n2 & 4) != 0) {
            n = sheetDelegate.lastStableDetentIndex;
        }
        return sheetDelegate.configureBottomSheetBehaviour$react_native_screens_release((BottomSheetBehavior<Screen>)bottomSheetBehavior, keyboardState, n);
    }

    @NotNull
    public WindowInsetsCompat onApplyWindowInsets(@NotNull View v, @NotNull WindowInsetsCompat insets) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        Intrinsics.checkNotNullParameter((Object)insets, (String)"insets");
        boolean isImeVisible = insets.isVisible(WindowInsetsCompat.Type.ime());
        Insets insets2 = insets.getInsets(WindowInsetsCompat.Type.ime());
        Intrinsics.checkNotNullExpressionValue((Object)insets2, (String)"getInsets(...)");
        Insets imeInset = insets2;
        if (isImeVisible) {
            this.isKeyboardVisible = true;
            this.keyboardState = new KeyboardVisible(imeInset.bottom);
            BottomSheetBehavior<Screen> bottomSheetBehavior = this.getSheetBehavior();
            if (bottomSheetBehavior != null) {
                BottomSheetBehavior<Screen> it = bottomSheetBehavior;
                boolean bl = false;
                SheetDelegate.configureBottomSheetBehaviour$react_native_screens_release$default(this, it, this.keyboardState, 0, 4, null);
            }
            Insets insets3 = insets.getInsets(WindowInsetsCompat.Type.navigationBars());
            Intrinsics.checkNotNullExpressionValue((Object)insets3, (String)"getInsets(...)");
            Insets prevInsets = insets3;
            WindowInsetsCompat windowInsetsCompat = new WindowInsetsCompat.Builder(insets).setInsets(WindowInsetsCompat.Type.navigationBars(), Insets.of((int)prevInsets.left, (int)prevInsets.top, (int)prevInsets.right, (int)0)).build();
            Intrinsics.checkNotNullExpressionValue((Object)windowInsetsCompat, (String)"build(...)");
            return windowInsetsCompat;
        }
        BottomSheetBehavior<Screen> bottomSheetBehavior = this.getSheetBehavior();
        if (bottomSheetBehavior != null) {
            BottomSheetBehavior<Screen> it = bottomSheetBehavior;
            boolean bl = false;
            if (this.isKeyboardVisible) {
                SheetDelegate.configureBottomSheetBehaviour$react_native_screens_release$default(this, it, KeyboardDidHide.INSTANCE, 0, 4, null);
            } else if (!Intrinsics.areEqual((Object)this.keyboardState, (Object)KeyboardNotVisible.INSTANCE)) {
                SheetDelegate.configureBottomSheetBehaviour$react_native_screens_release$default(this, it, KeyboardNotVisible.INSTANCE, 0, 4, null);
            }
        }
        this.keyboardState = KeyboardNotVisible.INSTANCE;
        this.isKeyboardVisible = false;
        Insets insets4 = insets.getInsets(WindowInsetsCompat.Type.navigationBars());
        Intrinsics.checkNotNullExpressionValue((Object)insets4, (String)"getInsets(...)");
        Insets prevInsets = insets4;
        WindowInsetsCompat windowInsetsCompat = new WindowInsetsCompat.Builder(insets).setInsets(WindowInsetsCompat.Type.navigationBars(), Insets.of((int)prevInsets.left, (int)prevInsets.top, (int)prevInsets.right, (int)0)).build();
        Intrinsics.checkNotNullExpressionValue((Object)windowInsetsCompat, (String)"build(...)");
        return windowInsetsCompat;
    }

    private final boolean shouldDismissSheetInState(int state) {
        return state == 5;
    }

    private final Integer tryResolveContainerHeight() {
        Object object;
        ScreenContainer screenContainer = this.screen.getContainer();
        if (screenContainer != null) {
            ScreenContainer it = screenContainer;
            boolean bl = false;
            return it.getHeight();
        }
        ThemedReactContext context = this.screen.getReactContext();
        Resources resources = context.getResources();
        if (resources != null && (object = resources.getDisplayMetrics()) != null) {
            int it = object.heightPixels;
            boolean bl = false;
            return it;
        }
        if (Build.VERSION.SDK_INT >= 30) {
            Rect rect;
            object = context.getSystemService("window");
            WindowManager windowManager = resources = object instanceof WindowManager ? (WindowManager)object : null;
            if (resources != null && (object = resources.getCurrentWindowMetrics()) != null && (rect = object.getBounds()) != null) {
                int it = rect.height();
                boolean bl = false;
                return it;
            }
        }
        return null;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/swmansion/rnscreens/bottomsheet/SheetDelegate$Companion;", "", "<init>", "()V", "TAG", "", "react-native-screens_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/swmansion/rnscreens/bottomsheet/SheetDelegate$KeyboardHandler;", "Lcom/google/android/material/bottomsheet/BottomSheetBehavior$BottomSheetCallback;", "<init>", "(Lcom/swmansion/rnscreens/bottomsheet/SheetDelegate;)V", "onStateChanged", "", "bottomSheet", "Landroid/view/View;", "newState", "", "onSlide", "slideOffset", "", "react-native-screens_release"})
    private final class KeyboardHandler
    extends BottomSheetBehavior.BottomSheetCallback {
        public void onStateChanged(@NotNull View bottomSheet, int newState) {
            boolean isImeVisible;
            Intrinsics.checkNotNullParameter((Object)bottomSheet, (String)"bottomSheet");
            if (newState == 4 && (isImeVisible = WindowInsetsCompat.toWindowInsetsCompat((WindowInsets)bottomSheet.getRootWindowInsets()).isVisible(WindowInsetsCompat.Type.ime()))) {
                bottomSheet.requestFocus();
                InputMethodManager imm = (InputMethodManager)SheetDelegate.this.getScreen().getReactContext().getSystemService(InputMethodManager.class);
                imm.hideSoftInputFromWindow(bottomSheet.getWindowToken(), 0);
            }
        }

        public void onSlide(@NotNull View bottomSheet, float slideOffset) {
            Intrinsics.checkNotNullParameter((Object)bottomSheet, (String)"bottomSheet");
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/swmansion/rnscreens/bottomsheet/SheetDelegate$SheetStateObserver;", "Lcom/google/android/material/bottomsheet/BottomSheetBehavior$BottomSheetCallback;", "<init>", "(Lcom/swmansion/rnscreens/bottomsheet/SheetDelegate;)V", "onStateChanged", "", "bottomSheet", "Landroid/view/View;", "newState", "", "onSlide", "slideOffset", "", "react-native-screens_release"})
    private final class SheetStateObserver
    extends BottomSheetBehavior.BottomSheetCallback {
        public void onStateChanged(@NotNull View bottomSheet, int newState) {
            Intrinsics.checkNotNullParameter((Object)bottomSheet, (String)"bottomSheet");
            SheetDelegate.this.onSheetStateChanged(newState);
        }

        public void onSlide(@NotNull View bottomSheet, float slideOffset) {
            Intrinsics.checkNotNullParameter((Object)bottomSheet, (String)"bottomSheet");
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Lifecycle.Event.values().length];
            try {
                nArray[Lifecycle.Event.ON_START.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Lifecycle.Event.ON_RESUME.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Lifecycle.Event.ON_PAUSE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

