/*
 * Decompiled with CFR 0.152.
 */
package com.swmansion.rnscreens.events;

import android.view.View;
import com.facebook.react.uimanager.UIManagerHelper;
import com.facebook.react.uimanager.events.Event;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.swmansion.rnscreens.Screen;
import com.swmansion.rnscreens.ScreenFragment;
import com.swmansion.rnscreens.events.ScreenAppearEvent;
import com.swmansion.rnscreens.events.ScreenDisappearEvent;
import com.swmansion.rnscreens.events.ScreenDismissedEvent;
import com.swmansion.rnscreens.events.ScreenTransitionProgressEvent;
import com.swmansion.rnscreens.events.ScreenWillAppearEvent;
import com.swmansion.rnscreens.events.ScreenWillDisappearEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0002\u0010\u0012J\r\u0010\u0013\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0002\u0010\u0012J\r\u0010\u0014\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0002\u0010\u0012J\r\u0010\u0015\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0002\u0010\u0012J\r\u0010\u0016\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0002\u0010\u0012J\u001e\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\b\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lcom/swmansion/rnscreens/events/ScreenEventEmitter;", "", "screen", "Lcom/swmansion/rnscreens/Screen;", "<init>", "(Lcom/swmansion/rnscreens/Screen;)V", "getScreen", "()Lcom/swmansion/rnscreens/Screen;", "reactEventDispatcher", "Lcom/facebook/react/uimanager/events/EventDispatcher;", "getReactEventDispatcher", "()Lcom/facebook/react/uimanager/events/EventDispatcher;", "reactSurfaceId", "", "getReactSurfaceId", "()I", "dispatchOnWillAppear", "", "()Lkotlin/Unit;", "dispatchOnAppear", "dispatchOnWillDisappear", "dispatchOnDisappear", "dispatchOnDismissed", "dispatchTransitionProgress", "progress", "", "isExitAnimation", "", "isGoingForward", "react-native-screens_release"})
public final class ScreenEventEmitter {
    @NotNull
    private final Screen screen;

    public ScreenEventEmitter(@NotNull Screen screen) {
        Intrinsics.checkNotNullParameter((Object)screen, (String)"screen");
        this.screen = screen;
    }

    @NotNull
    public final Screen getScreen() {
        return this.screen;
    }

    @Nullable
    public final EventDispatcher getReactEventDispatcher() {
        return this.screen.getReactEventDispatcher();
    }

    public final int getReactSurfaceId() {
        return UIManagerHelper.getSurfaceId((View)((View)this.screen));
    }

    @Nullable
    public final Unit dispatchOnWillAppear() {
        Unit unit;
        EventDispatcher eventDispatcher = this.getReactEventDispatcher();
        if (eventDispatcher != null) {
            eventDispatcher.dispatchEvent((Event)new ScreenWillAppearEvent(this.getReactSurfaceId(), this.screen.getId()));
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    @Nullable
    public final Unit dispatchOnAppear() {
        Unit unit;
        EventDispatcher eventDispatcher = this.getReactEventDispatcher();
        if (eventDispatcher != null) {
            eventDispatcher.dispatchEvent((Event)new ScreenAppearEvent(this.getReactSurfaceId(), this.screen.getId()));
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    @Nullable
    public final Unit dispatchOnWillDisappear() {
        Unit unit;
        EventDispatcher eventDispatcher = this.getReactEventDispatcher();
        if (eventDispatcher != null) {
            eventDispatcher.dispatchEvent((Event)new ScreenWillDisappearEvent(this.getReactSurfaceId(), this.screen.getId()));
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    @Nullable
    public final Unit dispatchOnDisappear() {
        Unit unit;
        EventDispatcher eventDispatcher = this.getReactEventDispatcher();
        if (eventDispatcher != null) {
            eventDispatcher.dispatchEvent((Event)new ScreenDisappearEvent(this.getReactSurfaceId(), this.screen.getId()));
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    @Nullable
    public final Unit dispatchOnDismissed() {
        Unit unit;
        EventDispatcher eventDispatcher = this.getReactEventDispatcher();
        if (eventDispatcher != null) {
            eventDispatcher.dispatchEvent((Event)new ScreenDismissedEvent(this.getReactSurfaceId(), this.screen.getId()));
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    public final void dispatchTransitionProgress(float progress, boolean isExitAnimation, boolean isGoingForward) {
        block0: {
            float sanitizedProgress = RangesKt.coerceIn((float)progress, (float)0.0f, (float)1.0f);
            short coalescingKey = ScreenFragment.Companion.getCoalescingKey(sanitizedProgress);
            EventDispatcher eventDispatcher = this.getReactEventDispatcher();
            if (eventDispatcher == null) break block0;
            eventDispatcher.dispatchEvent((Event)new ScreenTransitionProgressEvent(this.getReactSurfaceId(), this.screen.getId(), sanitizedProgress, isExitAnimation, isGoingForward, coalescingKey));
        }
    }
}

