/*
 * Decompiled with CFR 0.152.
 */
package com.swmansion.rnscreens.gamma.helpers;

import android.content.Context;
import android.content.ContextWrapper;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import com.facebook.react.ReactRootView;
import com.swmansion.rnscreens.gamma.common.FragmentProviding;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u000b"}, d2={"Lcom/swmansion/rnscreens/gamma/helpers/FragmentManagerHelper;", "", "<init>", "()V", "findFragmentManagerForView", "Landroidx/fragment/app/FragmentManager;", "view", "Landroid/view/ViewGroup;", "resolveFragmentManagerForReactRootView", "rootView", "Lcom/facebook/react/ReactRootView;", "react-native-screens_release"})
public final class FragmentManagerHelper {
    @NotNull
    public static final FragmentManagerHelper INSTANCE = new FragmentManagerHelper();

    private FragmentManagerHelper() {
    }

    @Nullable
    public final FragmentManager findFragmentManagerForView(@NotNull ViewGroup view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        ViewGroup parent = null;
        parent = view;
        while (!(parent instanceof ReactRootView) && !(parent instanceof FragmentProviding) && ((ViewParent)parent).getParent() != null) {
            Intrinsics.checkNotNullExpressionValue((Object)((ViewParent)parent).getParent(), (String)"getParent(...)");
        }
        if (parent instanceof FragmentProviding) {
            Fragment fragment = ((FragmentProviding)parent).getAssociatedFragment();
            if (fragment == null) {
                boolean $i$a$-checkNotNull-FragmentManagerHelper$findFragmentManagerForView$22 = false;
                String $i$a$-checkNotNull-FragmentManagerHelper$findFragmentManagerForView$22 = "[RNScreens] Parent fragment providing view " + parent + " returned nullish fragment";
                throw new IllegalStateException($i$a$-checkNotNull-FragmentManagerHelper$findFragmentManagerForView$22.toString());
            }
            return fragment.getChildFragmentManager();
        }
        if (!(parent instanceof ReactRootView)) {
            boolean bl = false;
            String string = "[RNScreens] Expected parent to be a ReactRootView, instead found: " + parent.getClass().getName();
            throw new IllegalStateException(string.toString());
        }
        return this.resolveFragmentManagerForReactRootView((ReactRootView)parent);
    }

    private final FragmentManager resolveFragmentManagerForReactRootView(ReactRootView rootView) {
        FragmentManager fragmentManager;
        Context context = rootView.getContext();
        while (!(context instanceof FragmentActivity) && context instanceof ContextWrapper) {
            context = ((ContextWrapper)context).getBaseContext();
        }
        if (!(context instanceof FragmentActivity)) {
            boolean $i$a$-check-FragmentManagerHelper$resolveFragmentManagerForReactRootView$22 = false;
            String $i$a$-check-FragmentManagerHelper$resolveFragmentManagerForReactRootView$22 = "[RNScreens] In order to use react-native-screens components your app's activity need to extend ReactActivity";
            throw new IllegalStateException($i$a$-check-FragmentManagerHelper$resolveFragmentManagerForReactRootView$22.toString());
        }
        if (((FragmentActivity)context).getSupportFragmentManager().getFragments().isEmpty()) {
            fragmentManager = ((FragmentActivity)context).getSupportFragmentManager();
        } else {
            FragmentManager fragmentManager2;
            try {
                fragmentManager2 = FragmentManager.findFragment((View)((View)rootView)).getChildFragmentManager();
            }
            catch (IllegalStateException ex) {
                fragmentManager2 = ((FragmentActivity)context).getSupportFragmentManager();
            }
            fragmentManager = fragmentManager2;
        }
        return fragmentManager;
    }
}

