/*
 * Decompiled with CFR 0.152.
 */
package com.swmansion.rnscreens.bottomsheet;

import android.animation.ValueAnimator;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import androidx.fragment.app.Fragment;
import com.facebook.react.uimanager.ThemedReactContext;
import com.google.android.material.bottomsheet.BottomSheetBehavior;
import com.swmansion.rnscreens.Screen;
import com.swmansion.rnscreens.ScreenStackFragment;
import com.swmansion.rnscreens.bottomsheet.DimmingView;
import java.util.Collection;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001#B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0017J\u001c\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u001aJ\u0016\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u001eJ\u0016\u0010\u001f\u001a\u00020\u00152\u000e\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u001aJ\u0010\u0010 \u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u001a\u0010!\u001a\u00020\u00132\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\"\u001a\u00020\u001cH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/swmansion/rnscreens/bottomsheet/DimmingViewManager;", "", "reactContext", "Lcom/facebook/react/uimanager/ThemedReactContext;", "screen", "Lcom/swmansion/rnscreens/Screen;", "<init>", "(Lcom/facebook/react/uimanager/ThemedReactContext;Lcom/swmansion/rnscreens/Screen;)V", "getReactContext", "()Lcom/facebook/react/uimanager/ThemedReactContext;", "dimmingView", "Lcom/swmansion/rnscreens/bottomsheet/DimmingView;", "getDimmingView$react_native_screens_release", "()Lcom/swmansion/rnscreens/bottomsheet/DimmingView;", "maxAlpha", "", "getMaxAlpha$react_native_screens_release", "()F", "dimmingViewCallback", "Lcom/google/android/material/bottomsheet/BottomSheetBehavior$BottomSheetCallback;", "onViewHierarchyCreated", "", "root", "Landroid/view/ViewGroup;", "onBehaviourAttached", "behavior", "Lcom/google/android/material/bottomsheet/BottomSheetBehavior;", "willDimForDetentIndex", "", "index", "", "invalidate", "createDimmingView", "requireBottomSheetCallback", "forceCreation", "AnimateDimmingViewCallback", "react-native-screens_release"})
@SourceDebugExtension(value={"SMAP\nDimmingViewManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DimmingViewManager.kt\ncom/swmansion/rnscreens/bottomsheet/DimmingViewManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,181:1\n1#2:182\n*E\n"})
public final class DimmingViewManager {
    @NotNull
    private final ThemedReactContext reactContext;
    @NotNull
    private final DimmingView dimmingView;
    private final float maxAlpha;
    @Nullable
    private BottomSheetBehavior.BottomSheetCallback dimmingViewCallback;

    public DimmingViewManager(@NotNull ThemedReactContext reactContext, @NotNull Screen screen) {
        Intrinsics.checkNotNullParameter((Object)reactContext, (String)"reactContext");
        Intrinsics.checkNotNullParameter((Object)screen, (String)"screen");
        this.reactContext = reactContext;
        this.dimmingView = this.createDimmingView(screen);
        this.maxAlpha = 0.3f;
    }

    @NotNull
    public final ThemedReactContext getReactContext() {
        return this.reactContext;
    }

    @NotNull
    public final DimmingView getDimmingView$react_native_screens_release() {
        return this.dimmingView;
    }

    public final float getMaxAlpha$react_native_screens_release() {
        return this.maxAlpha;
    }

    public final void onViewHierarchyCreated(@NotNull Screen screen, @NotNull ViewGroup root) {
        Intrinsics.checkNotNullParameter((Object)screen, (String)"screen");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        root.addView((View)this.dimmingView, 0);
        if (!this.willDimForDetentIndex(screen, screen.getSheetInitialDetentIndex())) {
            this.dimmingView.setAlpha(0.0f);
        } else {
            this.dimmingView.setAlpha(this.maxAlpha);
        }
    }

    public final void onBehaviourAttached(@NotNull Screen screen, @NotNull BottomSheetBehavior<Screen> behavior) {
        Intrinsics.checkNotNullParameter((Object)screen, (String)"screen");
        Intrinsics.checkNotNullParameter(behavior, (String)"behavior");
        behavior.addBottomSheetCallback(this.requireBottomSheetCallback(screen, true));
    }

    public final boolean willDimForDetentIndex(@NotNull Screen screen, int index) {
        Intrinsics.checkNotNullParameter((Object)screen, (String)"screen");
        return index > screen.getSheetLargestUndimmedDetentIndex();
    }

    public final void invalidate(@Nullable BottomSheetBehavior<Screen> behavior) {
        block1: {
            BottomSheetBehavior.BottomSheetCallback bottomSheetCallback = this.dimmingViewCallback;
            if (bottomSheetCallback == null) break block1;
            BottomSheetBehavior.BottomSheetCallback callback = bottomSheetCallback;
            boolean bl = false;
            BottomSheetBehavior<Screen> bottomSheetBehavior = behavior;
            if (bottomSheetBehavior != null) {
                bottomSheetBehavior.removeBottomSheetCallback(callback);
            }
        }
    }

    private final DimmingView createDimmingView(Screen screen) {
        DimmingView dimmingView;
        DimmingView $this$createDimmingView_u24lambda_u242 = dimmingView = new DimmingView((Context)this.reactContext, this.maxAlpha);
        boolean bl = false;
        $this$createDimmingView_u24lambda_u242.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        $this$createDimmingView_u24lambda_u242.setOnClickListener(arg_0 -> DimmingViewManager.createDimmingView$lambda$2$lambda$1(screen, arg_0));
        return dimmingView;
    }

    private final BottomSheetBehavior.BottomSheetCallback requireBottomSheetCallback(Screen screen, boolean forceCreation) {
        if (this.dimmingViewCallback == null || forceCreation) {
            this.dimmingViewCallback = new AnimateDimmingViewCallback(screen, (View)this.dimmingView, this.maxAlpha);
        }
        BottomSheetBehavior.BottomSheetCallback bottomSheetCallback = this.dimmingViewCallback;
        Intrinsics.checkNotNull((Object)bottomSheetCallback);
        return bottomSheetCallback;
    }

    static /* synthetic */ BottomSheetBehavior.BottomSheetCallback requireBottomSheetCallback$default(DimmingViewManager dimmingViewManager, Screen screen, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return dimmingViewManager.requireBottomSheetCallback(screen, bl);
    }

    private static final void createDimmingView$lambda$2$lambda$1(Screen $screen, View it) {
        if ($screen.getSheetClosesOnTouchOutside()) {
            Fragment fragment = $screen.getFragment();
            Intrinsics.checkNotNull((Object)fragment, (String)"null cannot be cast to non-null type com.swmansion.rnscreens.ScreenStackFragment");
            ((ScreenStackFragment)fragment).dismissSelf$react_native_screens_release();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u0007H\u0016J\u0010\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001aH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n \u0015*\u0004\u0018\u00010\u00140\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/swmansion/rnscreens/bottomsheet/DimmingViewManager$AnimateDimmingViewCallback;", "Lcom/google/android/material/bottomsheet/BottomSheetBehavior$BottomSheetCallback;", "screen", "Lcom/swmansion/rnscreens/Screen;", "viewToAnimate", "Landroid/view/View;", "maxAlpha", "", "<init>", "(Lcom/swmansion/rnscreens/Screen;Landroid/view/View;F)V", "getScreen", "()Lcom/swmansion/rnscreens/Screen;", "getViewToAnimate", "()Landroid/view/View;", "getMaxAlpha", "()F", "largestUndimmedOffset", "firstDimmedOffset", "intervalLength", "animator", "Landroid/animation/ValueAnimator;", "kotlin.jvm.PlatformType", "onStateChanged", "", "bottomSheet", "newState", "", "onSlide", "slideOffset", "computeOffsetFromDetentIndex", "index", "react-native-screens_release"})
    private static final class AnimateDimmingViewCallback
    extends BottomSheetBehavior.BottomSheetCallback {
        @NotNull
        private final Screen screen;
        @NotNull
        private final View viewToAnimate;
        private final float maxAlpha;
        private float largestUndimmedOffset;
        private float firstDimmedOffset;
        private float intervalLength;
        private final ValueAnimator animator;

        /*
         * WARNING - void declaration
         */
        public AnimateDimmingViewCallback(@NotNull Screen screen, @NotNull View viewToAnimate, float maxAlpha) {
            void $this$animator_u24lambda_u241;
            Intrinsics.checkNotNullParameter((Object)screen, (String)"screen");
            Intrinsics.checkNotNullParameter((Object)viewToAnimate, (String)"viewToAnimate");
            this.screen = screen;
            this.viewToAnimate = viewToAnimate;
            this.maxAlpha = maxAlpha;
            this.largestUndimmedOffset = this.computeOffsetFromDetentIndex(this.screen.getSheetLargestUndimmedDetentIndex());
            this.firstDimmedOffset = this.computeOffsetFromDetentIndex(RangesKt.coerceIn((int)(this.screen.getSheetLargestUndimmedDetentIndex() + 1), (int)0, (int)(((Collection)this.screen.getSheetDetents()).size() - 1)));
            this.intervalLength = this.firstDimmedOffset - this.largestUndimmedOffset;
            Object object = new float[]{0.0f, this.maxAlpha};
            Object object2 = object = (Object)ValueAnimator.ofFloat((float[])object);
            AnimateDimmingViewCallback animateDimmingViewCallback = this;
            boolean bl = false;
            $this$animator_u24lambda_u241.setDuration(1L);
            $this$animator_u24lambda_u241.addUpdateListener(arg_0 -> AnimateDimmingViewCallback.animator$lambda$1$lambda$0(this, arg_0));
            animateDimmingViewCallback.animator = (ValueAnimator)object;
        }

        @NotNull
        public final Screen getScreen() {
            return this.screen;
        }

        @NotNull
        public final View getViewToAnimate() {
            return this.viewToAnimate;
        }

        public final float getMaxAlpha() {
            return this.maxAlpha;
        }

        public void onStateChanged(@NotNull View bottomSheet, int newState) {
            Intrinsics.checkNotNullParameter((Object)bottomSheet, (String)"bottomSheet");
            switch (newState) {
                case 1: 
                case 2: {
                    boolean bl;
                    this.largestUndimmedOffset = this.computeOffsetFromDetentIndex(this.screen.getSheetLargestUndimmedDetentIndex());
                    this.firstDimmedOffset = this.computeOffsetFromDetentIndex(RangesKt.coerceIn((int)(this.screen.getSheetLargestUndimmedDetentIndex() + 1), (int)0, (int)(((Collection)this.screen.getSheetDetents()).size() - 1)));
                    boolean bl2 = bl = this.firstDimmedOffset >= this.largestUndimmedOffset;
                    if (_Assertions.ENABLED && !bl) {
                        boolean bl3 = false;
                        String string = "[RNScreens] Invariant violation: firstDimmedOffset (" + this.firstDimmedOffset + ") < largestDimmedOffset (" + this.largestUndimmedOffset + ")";
                        throw new AssertionError((Object)string);
                    }
                    this.intervalLength = this.firstDimmedOffset - this.largestUndimmedOffset;
                }
            }
        }

        public void onSlide(@NotNull View bottomSheet, float slideOffset) {
            Intrinsics.checkNotNullParameter((Object)bottomSheet, (String)"bottomSheet");
            if (this.largestUndimmedOffset < slideOffset && slideOffset < this.firstDimmedOffset) {
                float fraction = (slideOffset - this.largestUndimmedOffset) / this.intervalLength;
                this.animator.setCurrentFraction(fraction);
            }
        }

        private final float computeOffsetFromDetentIndex(int index) {
            return switch (this.screen.getSheetDetents().size()) {
                case 1 -> {
                    switch (index) {
                        case -1: {
                            yield -1.0f;
                        }
                        case 0: {
                            yield 1.0f;
                        }
                    }
                    yield -1.0f;
                }
                case 2 -> {
                    switch (index) {
                        case -1: {
                            yield -1.0f;
                        }
                        case 0: {
                            yield 0.0f;
                        }
                        case 1: {
                            yield 1.0f;
                        }
                    }
                    yield -1.0f;
                }
                case 3 -> {
                    switch (index) {
                        case -1: {
                            yield -1.0f;
                        }
                        case 0: {
                            yield 0.0f;
                        }
                        case 1: {
                            BottomSheetBehavior<Screen> v1 = this.screen.getSheetBehavior();
                            Intrinsics.checkNotNull(v1);
                            yield v1.getHalfExpandedRatio();
                        }
                        case 2: {
                            yield 1.0f;
                        }
                    }
                    yield -1.0f;
                }
                default -> -1.0f;
            };
        }

        private static final void animator$lambda$1$lambda$0(AnimateDimmingViewCallback this$0, ValueAnimator it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            View view = this$0.viewToAnimate;
            Object object = it.getAnimatedValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Float");
            view.setAlpha(((Float)object).floatValue());
        }
    }
}

