/*
 * Decompiled with CFR 0.152.
 */
package com.horcrux.svg;

import android.annotation.SuppressLint;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Xfermode;
import com.facebook.react.bridge.ReactContext;
import com.horcrux.svg.CustomFilter;
import com.horcrux.svg.CustomFilterFunction;
import com.horcrux.svg.FilterPrimitiveView;
import com.horcrux.svg.FilterProperties;
import com.horcrux.svg.SVGLength;
import java.util.HashMap;

@SuppressLint(value={"ViewConstructor"})
class FeBlendView
extends FilterPrimitiveView {
    String mIn1;
    String mIn2;
    FilterProperties.FeBlendMode mMode;

    public FeBlendView(ReactContext reactContext) {
        super(reactContext);
        this.mFilterSubregion.mX = new SVGLength(0.0);
        this.mFilterSubregion.mY = new SVGLength(0.0);
        this.mFilterSubregion.mW = new SVGLength("100%");
        this.mFilterSubregion.mH = new SVGLength("100%");
    }

    public void setIn1(String in1) {
        this.mIn1 = in1;
        this.invalidate();
    }

    public void setIn2(String in2) {
        this.mIn2 = in2;
        this.invalidate();
    }

    public void setMode(String mode) {
        this.mMode = FilterProperties.FeBlendMode.getEnum(mode);
        this.invalidate();
    }

    @Override
    public Bitmap applyFilter(HashMap<String, Bitmap> resultsMap, Bitmap prevResult) {
        Bitmap in1 = FeBlendView.getSource(resultsMap, prevResult, this.mIn1);
        Bitmap in2 = FeBlendView.getSource(resultsMap, prevResult, this.mIn2);
        if (this.mMode == FilterProperties.FeBlendMode.MULTIPLY) {
            CustomFilterFunction multiply = (src, dst) -> {
                float[] res = new float[]{1.0f - (1.0f - src[0]) * (1.0f - dst[0]), src[1] * src[0] * (1.0f - dst[0]) + dst[1] * dst[0] * (1.0f - src[0]) + src[1] * src[0] * dst[1] * dst[0], src[2] * src[0] * (1.0f - dst[0]) + dst[2] * dst[0] * (1.0f - src[0]) + src[2] * src[0] * dst[2] * dst[0], src[3] * src[0] * (1.0f - dst[0]) + dst[3] * dst[0] * (1.0f - src[0]) + src[3] * src[0] * dst[3] * dst[0]};
                return res;
            };
            return CustomFilter.apply(in1, in2, multiply);
        }
        Bitmap result = Bitmap.createBitmap((int)in1.getWidth(), (int)in1.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(result);
        Paint paint = new Paint(1);
        canvas.drawBitmap(in1, 0.0f, 0.0f, paint);
        switch (this.mMode) {
            case UNKNOWN: 
            case NORMAL: {
                paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_OVER));
                break;
            }
            case SCREEN: {
                paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SCREEN));
                break;
            }
            case LIGHTEN: {
                paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.LIGHTEN));
                break;
            }
            case DARKEN: {
                paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DARKEN));
                break;
            }
        }
        canvas.drawBitmap(in2, 0.0f, 0.0f, paint);
        return result;
    }
}

