/*
 * Decompiled with CFR 0.152.
 */
package com.horcrux.svg;

import android.annotation.SuppressLint;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.RectF;
import com.facebook.react.bridge.Dynamic;
import com.facebook.react.bridge.ReactContext;
import com.horcrux.svg.FilterPrimitiveView;
import com.horcrux.svg.SVGLength;
import java.util.HashMap;

@SuppressLint(value={"ViewConstructor"})
class FeOffsetView
extends FilterPrimitiveView {
    String mIn1;
    SVGLength mDx;
    SVGLength mDy;

    public FeOffsetView(ReactContext reactContext) {
        super(reactContext);
    }

    public void setIn1(String in1) {
        this.mIn1 = in1;
        this.invalidate();
    }

    public void setDx(Dynamic dx) {
        this.mDx = SVGLength.from(dx);
        this.invalidate();
    }

    public void setDy(Dynamic dy) {
        this.mDy = SVGLength.from(dy);
        this.invalidate();
    }

    @Override
    public Bitmap applyFilter(HashMap<String, Bitmap> resultsMap, Bitmap prevResult) {
        Bitmap source = FeOffsetView.getSource(resultsMap, prevResult, this.mIn1);
        Bitmap result = Bitmap.createBitmap((int)prevResult.getWidth(), (int)prevResult.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(result);
        float dx = this.mDx != null ? (float)this.relativeOnWidth(this.mDx) : 0.0f;
        float dy = this.mDy != null ? (float)this.relativeOnHeight(this.mDy) : 0.0f;
        RectF frame = new RectF(0.0f, 0.0f, dx, dy);
        this.getSvgView().getCtm().mapRect(frame);
        dx = frame.left < 0.0f ? frame.left : frame.width();
        dy = frame.top < 0.0f ? frame.top : frame.height();
        canvas.drawBitmap(source, dx, dy, null);
        return result;
    }
}

