/*
 * Decompiled with CFR 0.152.
 */
package com.horcrux.svg;

import android.annotation.SuppressLint;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.RectF;
import android.util.Log;
import android.view.View;
import com.facebook.react.bridge.Dynamic;
import com.facebook.react.bridge.ReactContext;
import com.horcrux.svg.DefinitionView;
import com.horcrux.svg.FilterPrimitiveView;
import com.horcrux.svg.FilterProperties;
import com.horcrux.svg.FilterRegion;
import com.horcrux.svg.FilterUtils;
import com.horcrux.svg.SvgView;
import java.util.HashMap;

@SuppressLint(value={"ViewConstructor"})
class FilterView
extends DefinitionView {
    private final HashMap<String, Bitmap> mResultsMap = new HashMap();
    private FilterProperties.Units mFilterUnits;
    private FilterProperties.Units mPrimitiveUnits;
    private final FilterRegion mFilterRegion = new FilterRegion();

    public FilterView(ReactContext reactContext) {
        super(reactContext);
    }

    public void setX(Dynamic x) {
        this.mFilterRegion.setX(x);
        this.invalidate();
    }

    public void setY(Dynamic y) {
        this.mFilterRegion.setY(y);
        this.invalidate();
    }

    public void setWidth(Dynamic width) {
        this.mFilterRegion.setWidth(width);
        this.invalidate();
    }

    public void setHeight(Dynamic height) {
        this.mFilterRegion.setHeight(height);
        this.invalidate();
    }

    public void setFilterUnits(String filterUnits) {
        this.mFilterUnits = FilterProperties.Units.getEnum(filterUnits);
        this.invalidate();
    }

    public void setPrimitiveUnits(String primitiveUnits) {
        this.mPrimitiveUnits = FilterProperties.Units.getEnum(primitiveUnits);
        this.invalidate();
    }

    public FilterRegion getFilterRegion() {
        return this.mFilterRegion;
    }

    @Override
    void saveDefinition() {
        SvgView svg;
        if (this.mName != null && (svg = this.getSvgView()) != null) {
            svg.defineFilter(this, this.mName);
        }
    }

    public Bitmap applyFilter(Bitmap source, Bitmap background, RectF renderableBounds) {
        this.mResultsMap.clear();
        this.mResultsMap.put("SourceGraphic", source);
        this.mResultsMap.put("SourceAlpha", FilterUtils.applySourceAlphaFilter(source));
        this.mResultsMap.put("BackgroundImage", background);
        this.mResultsMap.put("BackgroundAlpha", FilterUtils.applySourceAlphaFilter(background));
        Bitmap res = source;
        Bitmap resultBitmap = Bitmap.createBitmap((int)res.getWidth(), (int)res.getHeight(), (Bitmap.Config)res.getConfig());
        Canvas canvas = new Canvas(resultBitmap);
        Rect filterRegionRect = this.mFilterRegion.getCropRect(this, this.mFilterUnits, renderableBounds);
        for (int i = 0; i < this.getChildCount(); ++i) {
            View node = this.getChildAt(i);
            if (node instanceof FilterPrimitiveView) {
                FilterPrimitiveView currentFilter = (FilterPrimitiveView)node;
                resultBitmap.eraseColor(0);
                Rect cropRect = currentFilter.mFilterSubregion.getCropRect(currentFilter, this.mPrimitiveUnits, this.mPrimitiveUnits == FilterProperties.Units.USER_SPACE_ON_USE ? new RectF(filterRegionRect) : renderableBounds);
                canvas.drawBitmap(currentFilter.applyFilter(this.mResultsMap, res), cropRect, cropRect, null);
                res = resultBitmap.copy(Bitmap.Config.ARGB_8888, true);
                String resultName = currentFilter.getResult();
                if (resultName == null) continue;
                this.mResultsMap.put(resultName, res);
                continue;
            }
            Log.e((String)"RNSVG", (String)"Invalid `Filter` child: Filter children can only be `Fe...` components");
        }
        resultBitmap.eraseColor(0);
        canvas.drawBitmap(res, filterRegionRect, filterRegionRect, null);
        return resultBitmap;
    }
}

