/*
 * Decompiled with CFR 0.152.
 */
package com.horcrux.svg;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.net.Uri;
import android.view.View;
import com.facebook.common.executors.UiThreadImmediateExecutorService;
import com.facebook.common.logging.FLog;
import com.facebook.common.references.CloseableReference;
import com.facebook.datasource.DataSource;
import com.facebook.datasource.DataSubscriber;
import com.facebook.drawee.backends.pipeline.Fresco;
import com.facebook.imagepipeline.core.ImagePipeline;
import com.facebook.imagepipeline.datasource.BaseBitmapDataSubscriber;
import com.facebook.imagepipeline.image.CloseableBitmap;
import com.facebook.imagepipeline.image.CloseableImage;
import com.facebook.imagepipeline.request.ImageRequest;
import com.facebook.react.bridge.Dynamic;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.uimanager.UIManagerHelper;
import com.facebook.react.uimanager.events.Event;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.react.views.imagehelper.ImageSource;
import com.facebook.react.views.imagehelper.ResourceDrawableIdHelper;
import com.horcrux.svg.RenderableView;
import com.horcrux.svg.SVGLength;
import com.horcrux.svg.SvgView;
import com.horcrux.svg.ViewBox;
import com.horcrux.svg.events.SvgLoadEvent;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@SuppressLint(value={"ViewConstructor"})
class ImageView
extends RenderableView {
    private SVGLength mX;
    private SVGLength mY;
    private SVGLength mW;
    private SVGLength mH;
    private String uriString;
    private int mImageWidth;
    private int mImageHeight;
    private String mAlign;
    private int mMeetOrSlice;
    private final AtomicBoolean mLoading = new AtomicBoolean(false);

    public ImageView(ReactContext reactContext) {
        super(reactContext);
    }

    public void setX(Dynamic x) {
        this.mX = SVGLength.from(x);
        this.invalidate();
    }

    public void setY(Dynamic y) {
        this.mY = SVGLength.from(y);
        this.invalidate();
    }

    public void setWidth(Dynamic width) {
        this.mW = SVGLength.from(width);
        this.invalidate();
    }

    public void setHeight(Dynamic height) {
        this.mH = SVGLength.from(height);
        this.invalidate();
    }

    public void setSrc(@Nullable ReadableMap src) {
        if (src != null) {
            this.uriString = src.getString("uri");
            if (this.uriString == null || this.uriString.isEmpty()) {
                return;
            }
            if (src.hasKey("width") && src.hasKey("height")) {
                this.mImageWidth = src.getInt("width");
                this.mImageHeight = src.getInt("height");
            } else {
                this.mImageWidth = 0;
                this.mImageHeight = 0;
            }
            Uri mUri = Uri.parse((String)this.uriString);
            if (mUri.getScheme() == null) {
                ResourceDrawableIdHelper.getInstance();
                ResourceDrawableIdHelper.getResourceDrawableUri((Context)this.mContext, (String)this.uriString);
            }
        }
    }

    public void setAlign(String align) {
        this.mAlign = align;
        this.invalidate();
    }

    public void setMeetOrSlice(int meetOrSlice) {
        this.mMeetOrSlice = meetOrSlice;
        this.invalidate();
    }

    @Override
    void draw(Canvas canvas, Paint paint, float opacity) {
        if (!this.mLoading.get()) {
            ImageSource imageSource;
            ImageRequest request;
            ImagePipeline imagePipeline = Fresco.getImagePipeline();
            boolean inMemoryCache = imagePipeline.isInBitmapMemoryCache(request = ImageRequest.fromUri((Uri)(imageSource = new ImageSource((Context)this.mContext, this.uriString)).getUri()));
            if (inMemoryCache) {
                this.tryRenderFromBitmapCache(imagePipeline, request, canvas, paint, opacity * this.mOpacity);
            } else {
                this.loadBitmap(imagePipeline, request);
            }
        }
    }

    @Override
    Path getPath(Canvas canvas, Paint paint) {
        this.mPath = new Path();
        this.mPath.addRect(this.getRect(), Path.Direction.CW);
        return this.mPath;
    }

    private void loadBitmap(ImagePipeline imagePipeline, ImageRequest request) {
        this.mLoading.set(true);
        DataSource dataSource = imagePipeline.fetchDecodedImage(request, (Object)this.mContext);
        BaseBitmapDataSubscriber subscriber = new BaseBitmapDataSubscriber(){

            public void onNewResultImpl(Bitmap bitmap) {
                EventDispatcher mEventDispatcher = UIManagerHelper.getEventDispatcherForReactTag((ReactContext)ImageView.this.mContext, (int)ImageView.this.getId());
                mEventDispatcher.dispatchEvent((Event)new SvgLoadEvent(UIManagerHelper.getSurfaceId((View)ImageView.this), ImageView.this.getId(), ImageView.this.mContext, ImageView.this.uriString, bitmap.getWidth(), bitmap.getHeight()));
                ImageView.this.mLoading.set(false);
                SvgView view = ImageView.this.getSvgView();
                if (view != null) {
                    view.invalidate();
                }
            }

            public void onFailureImpl(DataSource dataSource) {
                ImageView.this.mLoading.set(false);
                FLog.w((String)"ReactNative", (Throwable)dataSource.getFailureCause(), (String)"RNSVG: fetchDecodedImage failed!", (Object[])new Object[0]);
            }
        };
        dataSource.subscribe((DataSubscriber)subscriber, (Executor)UiThreadImmediateExecutorService.getInstance());
    }

    @Nonnull
    private RectF getRect() {
        double x = this.relativeOnWidth(this.mX);
        double y = this.relativeOnHeight(this.mY);
        double w = this.relativeOnWidth(this.mW);
        double h = this.relativeOnHeight(this.mH);
        if (w == 0.0) {
            w = (float)this.mImageWidth * this.mScale;
        }
        if (h == 0.0) {
            h = (float)this.mImageHeight * this.mScale;
        }
        return new RectF((float)x, (float)y, (float)(x + w), (float)(y + h));
    }

    private void doRender(Canvas canvas, Paint paint, Bitmap bitmap, float opacity) {
        if (this.mImageWidth == 0 || this.mImageHeight == 0) {
            this.mImageWidth = bitmap.getWidth();
            this.mImageHeight = bitmap.getHeight();
        }
        RectF renderRect = this.getRect();
        RectF vbRect = new RectF(0.0f, 0.0f, (float)this.mImageWidth, (float)this.mImageHeight);
        Matrix transform = ViewBox.getTransform(vbRect, renderRect, this.mAlign, this.mMeetOrSlice);
        transform.mapRect(vbRect);
        canvas.clipPath(this.getPath(canvas, paint));
        Path clipPath = this.getClipPath(canvas, paint);
        if (clipPath != null) {
            canvas.clipPath(clipPath);
        }
        Paint alphaPaint = new Paint();
        alphaPaint.setAlpha((int)(opacity * 255.0f));
        canvas.drawBitmap(bitmap, null, vbRect, alphaPaint);
        this.mCTM.mapRect(vbRect);
        this.setClientRect(vbRect);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void tryRenderFromBitmapCache(ImagePipeline imagePipeline, ImageRequest request, Canvas canvas, Paint paint, float opacity) {
        try (DataSource dataSource = imagePipeline.fetchImageFromBitmapCache(request, (Object)this.mContext);){
            CloseableReference imageReference = (CloseableReference)dataSource.getResult();
            if (imageReference == null) {
                return;
            }
            try {
                CloseableImage closeableImage = (CloseableImage)imageReference.get();
                if (!(closeableImage instanceof CloseableBitmap)) {
                    return;
                }
                CloseableBitmap closeableBitmap = (CloseableBitmap)closeableImage;
                Bitmap bitmap = closeableBitmap.getUnderlyingBitmap();
                if (bitmap == null) {
                    return;
                }
                this.doRender(canvas, paint, bitmap, opacity);
                return;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            finally {
                CloseableReference.closeSafely((CloseableReference)imageReference);
            }
        }
    }
}

