/*
 * Decompiled with CFR 0.152.
 */
package com.horcrux.svg;

import android.annotation.SuppressLint;
import android.graphics.Matrix;
import com.facebook.common.logging.FLog;
import com.facebook.react.bridge.Dynamic;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReadableArray;
import com.horcrux.svg.Brush;
import com.horcrux.svg.DefinitionView;
import com.horcrux.svg.PropHelper;
import com.horcrux.svg.SVGLength;
import com.horcrux.svg.SvgView;
import javax.annotation.Nullable;

@SuppressLint(value={"ViewConstructor"})
class LinearGradientView
extends DefinitionView {
    private SVGLength mX1;
    private SVGLength mY1;
    private SVGLength mX2;
    private SVGLength mY2;
    private ReadableArray mGradient;
    private Brush.BrushUnits mGradientUnits;
    private static final float[] sRawMatrix = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f};
    private Matrix mMatrix = null;

    public LinearGradientView(ReactContext reactContext) {
        super(reactContext);
    }

    public void setX1(Dynamic x1) {
        this.mX1 = SVGLength.from(x1);
        this.invalidate();
    }

    public void setY1(Dynamic y1) {
        this.mY1 = SVGLength.from(y1);
        this.invalidate();
    }

    public void setX2(Dynamic x2) {
        this.mX2 = SVGLength.from(x2);
        this.invalidate();
    }

    public void setY2(Dynamic y2) {
        this.mY2 = SVGLength.from(y2);
        this.invalidate();
    }

    public void setGradient(ReadableArray gradient) {
        this.mGradient = gradient;
        this.invalidate();
    }

    public void setGradientUnits(int gradientUnits) {
        switch (gradientUnits) {
            case 0: {
                this.mGradientUnits = Brush.BrushUnits.OBJECT_BOUNDING_BOX;
                break;
            }
            case 1: {
                this.mGradientUnits = Brush.BrushUnits.USER_SPACE_ON_USE;
            }
        }
        this.invalidate();
    }

    public void setGradientTransform(@Nullable ReadableArray matrixArray) {
        if (matrixArray != null) {
            int matrixSize = PropHelper.toMatrixData(matrixArray, sRawMatrix, this.mScale);
            if (matrixSize == 6) {
                if (this.mMatrix == null) {
                    this.mMatrix = new Matrix();
                }
                this.mMatrix.setValues(sRawMatrix);
            } else if (matrixSize != -1) {
                FLog.w((String)"ReactNative", (String)"RNSVG: Transform matrices must be of size 6");
            }
        } else {
            this.mMatrix = null;
        }
        this.invalidate();
    }

    @Override
    void saveDefinition() {
        if (this.mName != null) {
            SVGLength[] points = new SVGLength[]{this.mX1, this.mY1, this.mX2, this.mY2};
            Brush brush = new Brush(Brush.BrushType.LINEAR_GRADIENT, points, this.mGradientUnits);
            brush.setGradientColors(this.mGradient);
            if (this.mMatrix != null) {
                brush.setGradientTransform(this.mMatrix);
            }
            SvgView svg = this.getSvgView();
            if (this.mGradientUnits == Brush.BrushUnits.USER_SPACE_ON_USE) {
                brush.setUserSpaceBoundingBox(svg.getCanvasBounds());
            }
            svg.defineBrush(brush, this.mName);
        }
    }
}

