/*
 * Decompiled with CFR 0.152.
 */
package com.horcrux.svg;

import android.annotation.SuppressLint;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.RectF;
import android.view.View;
import com.facebook.react.bridge.Dynamic;
import com.facebook.react.bridge.ReactContext;
import com.horcrux.svg.GroupView;
import com.horcrux.svg.Point;
import com.horcrux.svg.RNSVGMarkerPosition;
import com.horcrux.svg.SVGLength;
import com.horcrux.svg.SvgView;
import com.horcrux.svg.ViewBox;
import com.horcrux.svg.VirtualView;

@SuppressLint(value={"ViewConstructor"})
class MarkerView
extends GroupView {
    private SVGLength mRefX;
    private SVGLength mRefY;
    private SVGLength mMarkerWidth;
    private SVGLength mMarkerHeight;
    private String mMarkerUnits;
    private String mOrient;
    private float mMinX;
    private float mMinY;
    private float mVbWidth;
    private float mVbHeight;
    String mAlign;
    int mMeetOrSlice;
    Matrix markerTransform = new Matrix();

    public MarkerView(ReactContext reactContext) {
        super(reactContext);
    }

    public void setRefX(Dynamic refX) {
        this.mRefX = SVGLength.from(refX);
        this.invalidate();
    }

    public void setRefY(Dynamic refY) {
        this.mRefY = SVGLength.from(refY);
        this.invalidate();
    }

    public void setMarkerWidth(Dynamic markerWidth) {
        this.mMarkerWidth = SVGLength.from(markerWidth);
        this.invalidate();
    }

    public void setMarkerHeight(Dynamic markerHeight) {
        this.mMarkerHeight = SVGLength.from(markerHeight);
        this.invalidate();
    }

    public void setMarkerUnits(String markerUnits) {
        this.mMarkerUnits = markerUnits;
        this.invalidate();
    }

    public void setOrient(String orient) {
        this.mOrient = orient;
        this.invalidate();
    }

    public void setMinX(float minX) {
        this.mMinX = minX;
        this.invalidate();
    }

    public void setMinY(float minY) {
        this.mMinY = minY;
        this.invalidate();
    }

    public void setVbWidth(float vbWidth) {
        this.mVbWidth = vbWidth;
        this.invalidate();
    }

    public void setVbHeight(float vbHeight) {
        this.mVbHeight = vbHeight;
        this.invalidate();
    }

    public void setAlign(String align) {
        this.mAlign = align;
        this.invalidate();
    }

    public void setMeetOrSlice(int meetOrSlice) {
        this.mMeetOrSlice = meetOrSlice;
        this.invalidate();
    }

    @Override
    void saveDefinition() {
        if (this.mName != null) {
            SvgView svg = this.getSvgView();
            svg.defineMarker(this, this.mName);
            for (int i = 0; i < this.getChildCount(); ++i) {
                View node = this.getChildAt(i);
                if (!(node instanceof VirtualView)) continue;
                ((VirtualView)node).saveDefinition();
            }
        }
    }

    void renderMarker(Canvas canvas, Paint paint, float opacity, RNSVGMarkerPosition position, float strokeWidth) {
        int count = this.saveAndSetupCanvas(canvas, this.mCTM);
        this.markerTransform.reset();
        Point origin = position.origin;
        this.markerTransform.setTranslate((float)origin.x, (float)origin.y);
        double markerAngle = "auto".equals(this.mOrient) ? -1.0 : Double.parseDouble(this.mOrient);
        float degrees = 180.0f + (float)(markerAngle == -1.0 ? position.angle : markerAngle);
        this.markerTransform.preRotate(degrees);
        boolean useStrokeWidth = "strokeWidth".equals(this.mMarkerUnits);
        if (useStrokeWidth) {
            this.markerTransform.preScale(strokeWidth / this.mScale, strokeWidth / this.mScale);
        }
        double width = this.relativeOnWidth(this.mMarkerWidth) / (double)this.mScale;
        double height = this.relativeOnHeight(this.mMarkerHeight) / (double)this.mScale;
        RectF eRect = new RectF(0.0f, 0.0f, (float)width, (float)height);
        if (this.mAlign != null) {
            RectF vbRect = new RectF(this.mMinX * this.mScale, this.mMinY * this.mScale, (this.mMinX + this.mVbWidth) * this.mScale, (this.mMinY + this.mVbHeight) * this.mScale);
            Matrix viewBoxMatrix = ViewBox.getTransform(vbRect, eRect, this.mAlign, this.mMeetOrSlice);
            float[] values = new float[9];
            viewBoxMatrix.getValues(values);
            this.markerTransform.preScale(values[0], values[4]);
        }
        double x = this.relativeOnWidth(this.mRefX);
        double y = this.relativeOnHeight(this.mRefY);
        this.markerTransform.preTranslate((float)(-x), (float)(-y));
        canvas.concat(this.markerTransform);
        this.drawGroup(canvas, paint, opacity);
        this.restoreCanvas(canvas, count);
    }
}

