/*
 * Decompiled with CFR 0.152.
 */
package com.horcrux.svg;

import android.annotation.SuppressLint;
import com.facebook.react.bridge.Dynamic;
import com.facebook.react.bridge.ReactContext;
import com.horcrux.svg.Brush;
import com.horcrux.svg.GroupView;
import com.horcrux.svg.SVGLength;
import com.horcrux.svg.SvgView;

@SuppressLint(value={"ViewConstructor"})
class MaskView
extends GroupView {
    SVGLength mX;
    SVGLength mY;
    SVGLength mW;
    SVGLength mH;
    private Brush.BrushUnits mMaskUnits;
    private Brush.BrushUnits mMaskContentUnits;
    MaskType mMaskType;

    public MaskView(ReactContext reactContext) {
        super(reactContext);
    }

    public void setX(Dynamic x) {
        this.mX = SVGLength.from(x);
        this.invalidate();
    }

    public void setY(Dynamic y) {
        this.mY = SVGLength.from(y);
        this.invalidate();
    }

    public void setWidth(Dynamic width) {
        this.mW = SVGLength.from(width);
        this.invalidate();
    }

    public void setHeight(Dynamic height) {
        this.mH = SVGLength.from(height);
        this.invalidate();
    }

    public Brush.BrushUnits getMaskUnits() {
        return this.mMaskUnits;
    }

    public void setMaskUnits(int maskUnits) {
        switch (maskUnits) {
            case 0: {
                this.mMaskUnits = Brush.BrushUnits.OBJECT_BOUNDING_BOX;
                break;
            }
            case 1: {
                this.mMaskUnits = Brush.BrushUnits.USER_SPACE_ON_USE;
            }
        }
        this.invalidate();
    }

    public void setMaskContentUnits(int maskContentUnits) {
        switch (maskContentUnits) {
            case 0: {
                this.mMaskContentUnits = Brush.BrushUnits.OBJECT_BOUNDING_BOX;
                break;
            }
            case 1: {
                this.mMaskContentUnits = Brush.BrushUnits.USER_SPACE_ON_USE;
            }
        }
        this.invalidate();
    }

    public MaskType getMaskType() {
        return this.mMaskType;
    }

    public void setMaskType(int maskType) {
        switch (maskType) {
            case 0: {
                this.mMaskType = MaskType.LUMINANCE;
                break;
            }
            case 1: {
                this.mMaskType = MaskType.ALPHA;
            }
        }
        this.invalidate();
    }

    @Override
    void saveDefinition() {
        if (this.mName != null) {
            SvgView svg = this.getSvgView();
            svg.defineMask(this, this.mName);
        }
    }

    static enum MaskType {
        LUMINANCE,
        ALPHA;

    }
}

