/*
 * Decompiled with CFR 0.152.
 */
package com.horcrux.svg;

import android.annotation.SuppressLint;
import android.graphics.Matrix;
import android.graphics.RectF;
import com.facebook.common.logging.FLog;
import com.facebook.react.bridge.Dynamic;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReadableArray;
import com.horcrux.svg.Brush;
import com.horcrux.svg.GroupView;
import com.horcrux.svg.PropHelper;
import com.horcrux.svg.SVGLength;
import com.horcrux.svg.SvgView;
import javax.annotation.Nullable;

@SuppressLint(value={"ViewConstructor"})
class PatternView
extends GroupView {
    private SVGLength mX;
    private SVGLength mY;
    private SVGLength mW;
    private SVGLength mH;
    private Brush.BrushUnits mPatternUnits;
    private Brush.BrushUnits mPatternContentUnits;
    private float mMinX;
    private float mMinY;
    private float mVbWidth;
    private float mVbHeight;
    String mAlign;
    int mMeetOrSlice;
    private static final float[] sRawMatrix = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f};
    private Matrix mMatrix = null;

    public PatternView(ReactContext reactContext) {
        super(reactContext);
    }

    public void setX(Dynamic x) {
        this.mX = SVGLength.from(x);
        this.invalidate();
    }

    public void setY(Dynamic y) {
        this.mY = SVGLength.from(y);
        this.invalidate();
    }

    public void setWidth(Dynamic width) {
        this.mW = SVGLength.from(width);
        this.invalidate();
    }

    public void setHeight(Dynamic height) {
        this.mH = SVGLength.from(height);
        this.invalidate();
    }

    public void setPatternUnits(int patternUnits) {
        switch (patternUnits) {
            case 0: {
                this.mPatternUnits = Brush.BrushUnits.OBJECT_BOUNDING_BOX;
                break;
            }
            case 1: {
                this.mPatternUnits = Brush.BrushUnits.USER_SPACE_ON_USE;
            }
        }
        this.invalidate();
    }

    public void setPatternContentUnits(int patternContentUnits) {
        switch (patternContentUnits) {
            case 0: {
                this.mPatternContentUnits = Brush.BrushUnits.OBJECT_BOUNDING_BOX;
                break;
            }
            case 1: {
                this.mPatternContentUnits = Brush.BrushUnits.USER_SPACE_ON_USE;
            }
        }
        this.invalidate();
    }

    public void setPatternTransform(@Nullable ReadableArray matrixArray) {
        if (matrixArray != null) {
            int matrixSize = PropHelper.toMatrixData(matrixArray, sRawMatrix, this.mScale);
            if (matrixSize == 6) {
                if (this.mMatrix == null) {
                    this.mMatrix = new Matrix();
                }
                this.mMatrix.setValues(sRawMatrix);
            } else if (matrixSize != -1) {
                FLog.w((String)"ReactNative", (String)"RNSVG: Transform matrices must be of size 6");
            }
        } else {
            this.mMatrix = null;
        }
        this.invalidate();
    }

    public void setMinX(float minX) {
        this.mMinX = minX;
        this.invalidate();
    }

    public void setMinY(float minY) {
        this.mMinY = minY;
        this.invalidate();
    }

    public void setVbWidth(float vbWidth) {
        this.mVbWidth = vbWidth;
        this.invalidate();
    }

    public void setVbHeight(float vbHeight) {
        this.mVbHeight = vbHeight;
        this.invalidate();
    }

    public void setAlign(String align) {
        this.mAlign = align;
        this.invalidate();
    }

    public void setMeetOrSlice(int meetOrSlice) {
        this.mMeetOrSlice = meetOrSlice;
        this.invalidate();
    }

    RectF getViewBox() {
        return new RectF(this.mMinX * this.mScale, this.mMinY * this.mScale, (this.mMinX + this.mVbWidth) * this.mScale, (this.mMinY + this.mVbHeight) * this.mScale);
    }

    @Override
    void saveDefinition() {
        if (this.mName != null) {
            SVGLength[] points = new SVGLength[]{this.mX, this.mY, this.mW, this.mH};
            Brush brush = new Brush(Brush.BrushType.PATTERN, points, this.mPatternUnits);
            brush.setContentUnits(this.mPatternContentUnits);
            brush.setPattern(this);
            if (this.mMatrix != null) {
                brush.setGradientTransform(this.mMatrix);
            }
            SvgView svg = this.getSvgView();
            if (this.mPatternUnits == Brush.BrushUnits.USER_SPACE_ON_USE || this.mPatternContentUnits == Brush.BrushUnits.USER_SPACE_ON_USE) {
                brush.setUserSpaceBoundingBox(svg.getCanvasBounds());
            }
            svg.defineBrush(brush, this.mName);
        }
    }
}

