/*
 * Decompiled with CFR 0.152.
 */
package com.horcrux.svg;

import com.facebook.react.bridge.ReadableArray;
import com.horcrux.svg.SVGLength;

class PropHelper {
    private static final int inputMatrixDataSize = 6;

    PropHelper() {
    }

    static int toMatrixData(ReadableArray value, float[] sRawMatrix, float mScale) {
        int fromSize = value.size();
        if (fromSize != 6) {
            return fromSize;
        }
        sRawMatrix[0] = (float)value.getDouble(0);
        sRawMatrix[1] = (float)value.getDouble(2);
        sRawMatrix[2] = (float)value.getDouble(4) * mScale;
        sRawMatrix[3] = (float)value.getDouble(1);
        sRawMatrix[4] = (float)value.getDouble(3);
        sRawMatrix[5] = (float)value.getDouble(5) * mScale;
        return 6;
    }

    static double fromRelative(String length, double relative, double scale, double fontSize) {
        length = length.trim();
        int stringLength = length.length();
        int percentIndex = stringLength - 1;
        if (stringLength == 0 || length.equals("normal")) {
            return 0.0;
        }
        if (length.codePointAt(percentIndex) == 37) {
            return Double.valueOf(length.substring(0, percentIndex)) / 100.0 * relative;
        }
        int twoLetterUnitIndex = stringLength - 2;
        if (twoLetterUnitIndex > 0) {
            String lastTwo = length.substring(twoLetterUnitIndex);
            int end = twoLetterUnitIndex;
            double unit = 1.0;
            switch (lastTwo) {
                case "px": {
                    break;
                }
                case "em": {
                    unit = fontSize;
                    break;
                }
                case "pt": {
                    unit = 1.25;
                    break;
                }
                case "pc": {
                    unit = 15.0;
                    break;
                }
                case "mm": {
                    unit = 3.543307;
                    break;
                }
                case "cm": {
                    unit = 35.43307;
                    break;
                }
                case "in": {
                    unit = 90.0;
                    break;
                }
                default: {
                    end = stringLength;
                }
            }
            return Double.valueOf(length.substring(0, end)) * unit * scale;
        }
        return Double.valueOf(length) * scale;
    }

    static double fromRelative(SVGLength length, double relative, double offset, double scale, double fontSize) {
        if (length == null) {
            return offset;
        }
        SVGLength.UnitType unitType = length.unit;
        double value = length.value;
        double unit = 1.0;
        switch (unitType) {
            case NUMBER: 
            case PX: {
                break;
            }
            case PERCENTAGE: {
                return value / 100.0 * relative + offset;
            }
            case EMS: {
                unit = fontSize;
                break;
            }
            case EXS: {
                unit = fontSize / 2.0;
                break;
            }
            case CM: {
                unit = 35.43307;
                break;
            }
            case MM: {
                unit = 3.543307;
                break;
            }
            case IN: {
                unit = 90.0;
                break;
            }
            case PT: {
                unit = 1.25;
                break;
            }
            case PC: {
                unit = 15.0;
                break;
            }
            default: {
                return value * scale + offset;
            }
        }
        return value * unit * scale + offset;
    }
}

